/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.ExternalOptionState;
import com.intellij.openapi.externalSystem.ExternalStateComponent;
import com.intellij.openapi.externalSystem.ExternalStateModule;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManagerKt;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalSystem")
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001'B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\b\u0010\f\u001a\u0004\u0018\u00010\nJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\b\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\nJ \u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0015H\u0007J\u0006\u0010%\u001a\u00020\u0017J\u0006\u0010&\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/externalSystem/ExternalSystemModulePropertyManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/ExternalStateComponent;", "Lcom/intellij/openapi/roots/ProjectModelElement;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "store", "Lcom/intellij/openapi/externalSystem/ExternalOptionState;", "getExternalModuleGroup", "", "getExternalModuleType", "getExternalModuleVersion", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getExternalSystemId", "getLinkedProjectId", "getLinkedProjectPath", "getRootProjectPath", "getState", "isMavenized", "", "loadState", "", "state", "setExternalId", "id", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "setExternalModuleType", "type", "setExternalOptions", "moduleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "setMavenized", "mavenized", "swapStore", "unlinkExternalOptions", "Companion", "external-system-api"})
public final class ExternalSystemModulePropertyManager
implements PersistentStateComponent<ExternalStateComponent>,
ProjectModelElement {
    private ExternalOptionState store;
    private final Module module;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        ProjectModelExternalSource projectModelExternalSource;
        String string = this.store.getExternalSystem();
        if (string != null) {
            String string2;
            String it = string2 = string;
            projectModelExternalSource = ExternalProjectSystemRegistry.getInstance().getSourceById(it);
        } else {
            projectModelExternalSource = null;
        }
        return projectModelExternalSource;
    }

    @Override
    @NotNull
    public ExternalStateComponent getState() {
        ExternalStateComponent externalStateComponent;
        ExternalOptionState externalOptionState = this.store;
        if (!(externalOptionState instanceof ExternalStateComponent)) {
            externalOptionState = null;
        }
        if ((externalStateComponent = (ExternalStateComponent)externalOptionState) == null) {
            externalStateComponent = ExternalSystemModulePropertyManagerKt.getEMPTY_STATE();
        }
        return externalStateComponent;
    }

    @Override
    public void loadState(@NotNull ExternalStateComponent state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.store = state;
    }

    @Nullable
    public final String getExternalSystemId() {
        return this.store.getExternalSystem();
    }

    @Nullable
    public final String getExternalModuleType() {
        return this.store.getExternalSystemModuleType();
    }

    @Nullable
    public final String getExternalModuleVersion() {
        return this.store.getExternalSystemModuleVersion();
    }

    @Nullable
    public final String getExternalModuleGroup() {
        return this.store.getExternalSystemModuleGroup();
    }

    @Nullable
    public final String getLinkedProjectId() {
        return this.store.getLinkedProjectId();
    }

    @Nullable
    public final String getRootProjectPath() {
        return this.store.getRootProjectPath();
    }

    @Nullable
    public final String getLinkedProjectPath() {
        return this.store.getLinkedProjectPath();
    }

    public final boolean isMavenized() {
        return this.store.isMavenized();
    }

    public final void setMavenized(boolean mavenized) {
        if (mavenized) {
            this.unlinkExternalOptions();
        }
        this.store.setMavenized(mavenized);
    }

    public final void swapStore() {
        ExternalOptionState oldStore = this.store;
        boolean isMaven = oldStore.isMavenized();
        this.store = oldStore instanceof ExternalStateModule ? (ExternalOptionState)new ExternalStateComponent() : (ExternalOptionState)new ExternalStateModule(this.module);
        this.store.setExternalSystem((String)(this.store instanceof ExternalStateModule && isMaven ? null : oldStore.getExternalSystem()));
        if (!(this.store instanceof ExternalStateComponent)) {
            this.store.setMavenized(isMaven);
        }
        this.store.setLinkedProjectId(oldStore.getLinkedProjectId());
        this.store.setLinkedProjectPath(oldStore.getLinkedProjectPath());
        this.store.setRootProjectPath(oldStore.getRootProjectPath());
        this.store.setExternalSystemModuleGroup(oldStore.getExternalSystemModuleGroup());
        this.store.setExternalSystemModuleVersion(oldStore.getExternalSystemModuleVersion());
        if (oldStore instanceof ExternalStateModule) {
            oldStore.setMavenized(false);
            ExternalSystemModulePropertyManagerKt.access$unlinkExternalOptions(oldStore);
        }
    }

    public final void unlinkExternalOptions() {
        ExternalSystemModulePropertyManagerKt.access$unlinkExternalOptions(this.store);
    }

    public final void setExternalOptions(@NotNull ProjectSystemId id, @NotNull ModuleData moduleData, @Nullable ProjectData projectData) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)moduleData, (String)"moduleData");
        this.store.setMavenized(false);
        this.store.setExternalSystem(id.toString());
        this.store.setLinkedProjectId(moduleData.getId());
        this.store.setLinkedProjectPath(moduleData.getLinkedExternalProjectPath());
        Object object = projectData;
        if (object == null || (object = ((ProjectData)object).getLinkedExternalProjectPath()) == null) {
            object = "";
        }
        this.store.setRootProjectPath((String)object);
        this.store.setExternalSystemModuleGroup(moduleData.getGroup());
        this.store.setExternalSystemModuleVersion(moduleData.getVersion());
    }

    public final void setExternalId(@NotNull ProjectSystemId id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.store.setExternalSystem(id.getId());
    }

    public final void setExternalModuleType(@Nullable String type) {
        this.store.setExternalSystemModuleType(type);
    }

    public ExternalSystemModulePropertyManager(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.module = module;
        this.store = ProjectUtilCore.isExternalStorageEnabled(this.module.getProject()) ? (ExternalOptionState)new ExternalStateComponent() : (ExternalOptionState)new ExternalStateModule(this.module);
    }

    @JvmStatic
    @NotNull
    public static final ExternalSystemModulePropertyManager getInstance(@NotNull Module module) {
        return Companion.getInstance(module);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/ExternalSystemModulePropertyManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/externalSystem/ExternalSystemModulePropertyManager;", "module", "Lcom/intellij/openapi/module/Module;", "external-system-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ExternalSystemModulePropertyManager getInstance(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            ExternalSystemModulePropertyManager externalSystemModulePropertyManager = ModuleServiceManager.getService(module, ExternalSystemModulePropertyManager.class);
            if (externalSystemModulePropertyManager == null) {
                Intrinsics.throwNpe();
            }
            return externalSystemModulePropertyManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

