/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

class FSTProxySerializer
extends FSTBasicObjectSerializer {
    FSTProxySerializer() {
    }

    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Class<?>[] ifaces = clzInfo.getClazz().getInterfaces();
        out.writeInt(ifaces.length);
        for (Class<?> i : ifaces) {
            out.writeUTF(i.getName());
        }
        out.writeObject((Object)Proxy.getInvocationHandler(toWrite));
    }

    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws IOException, ClassNotFoundException {
        ClassLoader cl = in.getConf().getClassLoader();
        int numIfaces = in.readInt();
        String[] interfaces = new String[numIfaces];
        for (int i = 0; i < numIfaces; ++i) {
            interfaces[i] = in.readUTF();
        }
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                classObjs[i] = Class.forName(interfaces[i], false, cl);
                continue;
            }
            catch (ClassNotFoundException e) {
                classObjs[i] = Class.forName(interfaces[i], false, ((Object)((Object)this)).getClass().getClassLoader());
            }
        }
        InvocationHandler ih = (InvocationHandler)in.readObject();
        Object res = Proxy.newProxyInstance(cl, classObjs, ih);
        in.registerObject(res, streamPosition, serializationInfo, referencee);
        return res;
    }
}

