/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ComboBoxWithWidePopup<E>
extends JComboBox<E> {
    private boolean myLayingOut;
    private int myMinLength;

    public ComboBoxWithWidePopup() {
        this.myMinLength = 20;
        this.init();
    }

    public ComboBoxWithWidePopup(@NotNull ComboBoxModel<E> model) {
        if (model == null) {
            ComboBoxWithWidePopup.$$$reportNull$$$0(0);
        }
        super(model);
        this.myMinLength = 20;
        this.init();
    }

    public ComboBoxWithWidePopup(@NotNull E[] items) {
        if (items == null) {
            ComboBoxWithWidePopup.$$$reportNull$$$0(1);
        }
        super(items);
        this.myMinLength = 20;
        this.init();
    }

    private void init() {
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    @Override
    public void setRenderer(ListCellRenderer<? super E> renderer) {
        if (renderer instanceof SimpleColoredComponent) {
            SimpleColoredComponent scc = (SimpleColoredComponent)((Object)renderer);
            scc.getIpad().bottom = 0;
            scc.getIpad().top = 0;
        }
        super.setRenderer(new AdjustingListCellRenderer(this, renderer));
    }

    public void setMinLength(int minLength) {
        this.myMinLength = minLength;
    }

    protected int getMinLength() {
        return this.myMinLength;
    }

    @Override
    public void doLayout() {
        try {
            this.myLayingOut = true;
            super.doLayout();
        }
        finally {
            this.myLayingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension size = super.getSize();
        if (!this.myLayingOut) {
            size.width = Math.max(size.width, this.getOriginalPreferredSize().width);
        }
        return size;
    }

    private Dimension _getSuperSize() {
        return super.getSize();
    }

    protected Dimension getOriginalPreferredSize() {
        return this.getPreferredSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "items";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/ui/ComboBoxWithWidePopup";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AdjustingListCellRenderer
    implements ListCellRenderer<E> {
        private final ListCellRenderer<? super E> myOldRenderer;
        private final ComboBoxWithWidePopup myComboBox;

        AdjustingListCellRenderer(ComboBoxWithWidePopup<E> comboBox, ListCellRenderer<? super E> oldRenderer) {
            this.myComboBox = comboBox;
            this.myOldRenderer = oldRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1 && value instanceof String && !this.myComboBox.isValid()) {
                int minLength = ComboBoxWithWidePopup.this.getMinLength();
                Dimension size = this.myComboBox._getSuperSize();
                String stringValue = (String)value;
                if (size.width == 0 && stringValue.length() > minLength) {
                    String e = stringValue.substring(0, minLength);
                    value = e;
                }
            }
            return this.myOldRenderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
        }
    }
}

