/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.values.ClassSerializer;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleDeriveProcessor {
    protected final LangCodeStyleExtractor myLangExtractor;

    protected CodeStyleDeriveProcessor(LangCodeStyleExtractor langExtractor) {
        this.myLangExtractor = langExtractor;
    }

    public abstract ValuesExtractionResult runWithProgress(Project var1, CodeStyleSettings var2, PsiFile var3, ProgressIndicator var4);

    public Map<Value, Object> backupValues(CodeStyleSettings settings, Language language) {
        List<Value> baseValues = this.getFormattingValues(settings, language);
        HashMap res = ContainerUtil.newHashMap();
        for (Value baseValue : baseValues) {
            res.put(baseValue, baseValue.value);
        }
        return res;
    }

    @NotNull
    private Collection<Value.VAR_KIND> getVarKinds() {
        LinkedList<Value.VAR_KIND> varKinds = new LinkedList<Value.VAR_KIND>();
        varKinds.addAll(this.myLangExtractor.getCustomVarKinds());
        varKinds.addAll(Arrays.asList(Value.VAR_KIND.defaultKinds));
        LinkedList<Value.VAR_KIND> linkedList = varKinds;
        if (linkedList == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(0);
        }
        return linkedList;
    }

    @NotNull
    private Value.VAR_KIND getVarKind(@NotNull String name, @NotNull Object value) {
        if (name == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(1);
        }
        if (value == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(2);
        }
        for (Value.VAR_KIND varKind : this.getVarKinds()) {
            if (!varKind.accepts(name, value)) continue;
            Value.VAR_KIND vAR_KIND = varKind;
            if (vAR_KIND == null) {
                CodeStyleDeriveProcessor.$$$reportNull$$$0(3);
            }
            return vAR_KIND;
        }
        Value.VAR_KIND vAR_KIND = Value.VAR_KIND.NOTHING;
        if (vAR_KIND == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(4);
        }
        return vAR_KIND;
    }

    @NotNull
    private List<Value> readAll(@NotNull String instanceName, @NotNull Object instance) {
        if (instanceName == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(5);
        }
        if (instance == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(6);
        }
        Class<?> cls = instance.getClass();
        ArrayList<Value> ret = new ArrayList<Value>();
        ClassSerializer serializer2 = new ClassSerializer(instanceName, instance);
        for (Field field : cls.getDeclaredFields()) {
            if ((field = ClassSerializer.getPreparedField(field)) == null || field.getName().endsWith("_FORCE")) continue;
            try {
                ret.add(this.buildFValue(field, instance, serializer2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Value> arrayList = ret;
        if (arrayList == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private Value buildFValue(@NotNull Field field, @NotNull Object instance, @NotNull ClassSerializer serializer2) throws IllegalAccessException {
        if (field == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(8);
        }
        if (instance == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(9);
        }
        if (serializer2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(10);
        }
        String name = field.getName();
        Object value = field.get(instance);
        Value.VAR_KIND varKind = this.getVarKind(name, value);
        Value value2 = new Value(name, value, serializer2, varKind);
        if (value2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(11);
        }
        return value2;
    }

    @NotNull
    protected List<Value> getFormattingValues(CodeStyleSettings settings, Language language) {
        LanguageCodeStyleSettingsProvider provider;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            Utils.logError("IndentOptions from common settings are null; using indent options from settings.");
            indentOptions = settings.getIndentOptions();
        }
        CustomCodeStyleSettings languageSettings = Utils.getLanguageSettings(settings, language);
        List<Value> values = this.readAll("commonSettings", commonSettings);
        if (languageSettings != null) {
            values.addAll(this.readAll("ocSettings", languageSettings));
        }
        if ((provider = LanguageCodeStyleSettingsProvider.forLanguage(language)) != null) {
            Set<String> supportedFields = provider.getSupportedFields();
            ArrayList<Value> cvalues = new ArrayList<Value>(values.size());
            for (Value value : values) {
                if (!supportedFields.contains(value.name)) continue;
                cvalues.add(value);
            }
            values = cvalues;
        }
        if (indentOptions != null) {
            List<Value> valuesOrder = this.readAll("indentOptions", indentOptions);
            valuesOrder.addAll(values);
            List<Value> list = valuesOrder;
            if (list == null) {
                CodeStyleDeriveProcessor.$$$reportNull$$$0(12);
            }
            return list;
        }
        Utils.logError("Not indent options detected.");
        List<Value> list = values;
        if (list == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceName";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKinds";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readAll";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattingValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVarKind";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readAll";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

