/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.xml.JspBlock;
import com.intellij.psi.formatter.xml.JspSyntheticBlock;
import com.intellij.psi.formatter.xml.JspTextBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspXml.JspDeclaration;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.List;

public class JspTagBlock
extends XmlTagBlock {
    public JspTagBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
        super(node, wrap, alignment, policy, indent);
    }

    protected void processSimpleChild(ASTNode child, Indent indent, List<Block> result, Wrap wrap, Alignment alignment) {
        Pair<PsiElement, Language> root;
        PsiElement element = child.getPsi();
        if (this.myXmlFormattingPolicy.processJsp() && (child.getElementType() == BaseJspElementType.JSP_XML_TEXT || element instanceof OuterLanguageElement && !(element instanceof ELExpressionHolder)) && (root = JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree())) != null) {
            this.createJspTextNode(result, child, indent);
            return;
        }
        super.processSimpleChild(child, indent, result, wrap, alignment);
    }

    protected void createJspTextNode(List<Block> localResult, ASTNode child, Indent indent) {
        localResult.add((Block)new JspTextBlock(child, this.myXmlFormattingPolicy, JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree()), indent));
    }

    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return JspTextBlock.findJspTag(child, startOffset);
    }

    protected boolean isJspxJavaContainingNode(ASTNode child) {
        if (child.getElementType() != XmlElementType.XML_TEXT) {
            return false;
        }
        ASTNode treeParent = child.getTreeParent();
        if (treeParent == null) {
            return false;
        }
        if (treeParent.getElementType() != XmlElementType.XML_TAG) {
            return false;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)treeParent);
        String name = ((XmlTag)psiElement).getName();
        if (!Comparing.equal((String)name, (String)"jsp:scriptlet") && !Comparing.equal((String)name, (String)"jsp:declaration")) {
            return false;
        }
        if (child.getText().trim().isEmpty()) {
            return false;
        }
        return JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree()) != null;
    }

    protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
        return myLanguage == childLanguage || childLanguage == StdLanguages.JAVA || childLanguage == StdLanguages.HTML || childLanguage == StdLanguages.XHTML || childLanguage == StdLanguages.XML || childLanguage == StdLanguages.JSP || childLanguage == StdLanguages.JSPX || LanguageFormatting.INSTANCE.forContext(childPsi) == null;
    }

    protected ASTNode createAnotherTreeNode(List<Block> result, ASTNode child, PsiElement tag, Indent indent, Wrap wrap, Alignment alignment) {
        TextRange childRange;
        Indent childIndent = indent;
        if (this.myNode.getElementType() == XmlElementType.HTML_DOCUMENT && tag.getParent() instanceof XmlTag && this.myXmlFormattingPolicy.indentChildrenOf((XmlTag)tag.getParent())) {
            childIndent = Indent.getNormalIndent();
        }
        result.add(this.createAnotherTreeTagBlock(tag, childIndent));
        TextRange tagRange = tag.getTextRange();
        ASTNode currentChild = JspTagBlock.findChildAfter((ASTNode)child, (int)tagRange.getEndOffset());
        TextRange textRange = childRange = currentChild != null ? currentChild.getTextRange() : null;
        while (currentChild != null && childRange.getEndOffset() > tagRange.getEndOffset()) {
            XmlTag psiElement = this.findXmlTagAt(currentChild, tagRange.getEndOffset());
            if (psiElement != null) {
                if (psiElement instanceof XmlTag && psiElement.getTextRange().getStartOffset() >= childRange.getStartOffset() && this.containsTag((PsiElement)psiElement) && this.doesNotIntersectSubTagsWith((PsiElement)psiElement)) {
                    result.add(this.createAnotherTreeTagBlock((PsiElement)psiElement, childIndent));
                    currentChild = JspTagBlock.findChildAfter((ASTNode)currentChild, (int)psiElement.getTextRange().getEndOffset());
                    childRange = currentChild != null ? currentChild.getTextRange() : null;
                    tagRange = psiElement.getTextRange();
                    continue;
                }
                result.add((Block)new JspBlock(currentChild, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(tagRange.getEndOffset(), childRange.getEndOffset())));
                return currentChild;
            }
            result.add((Block)new JspBlock(currentChild, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(tagRange.getEndOffset(), childRange.getEndOffset())));
            return currentChild;
        }
        return currentChild;
    }

    protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new JspBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, null);
    }

    protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new JspTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent());
    }

    protected Block createSyntheticBlock(ArrayList<Block> localResult, Indent childrenIndent) {
        return new JspSyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
    }

    protected Block createAnotherTreeTagBlock(PsiElement tag, Indent childIndent) {
        if (this.isXmlTag(tag)) {
            return new JspTagBlock(tag.getNode(), null, null, this.createPolicyFor(), childIndent);
        }
        return new JspBlock(tag.getNode(), null, null, this.createPolicyFor(), childIndent, tag.getTextRange());
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag && !(psi instanceof JspScriptlet) && !(psi instanceof JspDeclaration);
    }

    protected XmlTag getAnotherTreeTag(ASTNode child) {
        boolean b = !(!this.myXmlFormattingPolicy.processJsp() || JspPsiUtil.getJspFile((PsiElement)this.myNode.getPsi()) == null || !this.isXmlTag(this.myNode) && this.myNode.getElementType() != XmlElementType.HTML_DOCUMENT && !(this.myNode.getPsi() instanceof PsiFile) || child.getElementType() != XmlTokenType.XML_DATA_CHARACTERS && child.getElementType() != BaseJspElementType.JSP_XML_TEXT && !(child.getPsi() instanceof OuterLanguageElement));
        return b ? this.findXmlTagAt(child, child.getStartOffset()) : null;
    }

    protected boolean isJspResult(ArrayList<Block> localResult) {
        return localResult.size() == 1 && localResult.get(0) instanceof JspTextBlock;
    }
}

