/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;

public class SimpleMethodCallLookupElement
extends LookupElement {
    private final PsiMethod myMethod;

    public SimpleMethodCallLookupElement(PsiMethod method) {
        this.myMethod = method;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myMethod.getName();
        if (string == null) {
            SimpleMethodCallLookupElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void handleInsert(InsertionContext context) {
        new MethodParenthesesHandler(this.myMethod, true).handleInsert(context, this);
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myMethod.getIcon(1));
        presentation.setItemText(this.myMethod.getName());
        presentation.setTailText(PsiFormatUtil.formatMethod(this.myMethod, PsiSubstitutor.EMPTY, 256, 3));
        PsiType returnType = this.myMethod.getReturnType();
        if (returnType != null) {
            presentation.setTypeText(returnType.getCanonicalText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/util/SimpleMethodCallLookupElement", "getLookupString"));
    }
}

