/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor) {
        return PsiSuperMethodUtil.findConstructorInSuper(constructor, (Set<PsiMethod>)new HashSet());
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor, Set<PsiMethod> visited) {
        PsiClass superClass;
        PsiClass containingClass;
        PsiElement firstChild;
        PsiStatement[] statements;
        if (visited.contains(constructor)) {
            return null;
        }
        visited.add(constructor);
        PsiCodeBlock body = constructor.getBody();
        if (body != null && (statements = body.getStatements()).length > 0 && (firstChild = statements[0].getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)firstChild).getMethodExpression();
            String text = methodExpr.getText();
            if (text.equals("super")) {
                PsiElement superConstructor = methodExpr.resolve();
                if (superConstructor instanceof PsiMethod) {
                    return (PsiMethod)superConstructor;
                }
            } else if (text.equals("this")) {
                PsiElement resolved = methodExpr.resolve();
                if (resolved instanceof PsiMethod) {
                    return PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)resolved, visited);
                }
                return null;
            }
        }
        if ((containingClass = constructor.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(0);
        }
        if (superMethod == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(1);
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        int superSignaturesSize = superSignatures.size();
        for (int i = 0; i < superSignaturesSize; ++i) {
            HierarchicalMethodSignature supsig = superSignatures.get(i);
            PsiMethod supsigme = supsig.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(2);
        }
        if (superSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(3);
        }
        if (derivedSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(4);
        }
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(new PsiTypeParameter[typeParams.size()]));
        }
        THashMap map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type);
            if (map == null) {
                map = new THashMap();
            }
            map.put(typeParameter, t);
        }
        PsiSubstitutor psiSubstitutor = map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getInstance(superClass.getProject()).getElementFactory().createSubstitutor((Map<PsiTypeParameter, PsiType>)map);
        if (psiSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Map<MethodSignature, Set<PsiMethod>> collectOverrideEquivalents(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(6);
        }
        THashMap overrideEquivalent = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        GlobalSearchScope resolveScope = aClass.getResolveScope();
        PsiClass[] supers = aClass.getSupers();
        for (int i = 0; i < supers.length; ++i) {
            PsiClass superClass = supers[i];
            boolean subType = false;
            for (int j = 0; j < supers.length; ++j) {
                if (j == i) continue;
                subType |= supers[j].isInheritor(supers[i], true);
            }
            if (subType) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
            for (HierarchicalMethodSignature hms : superClass.getVisibleSignatures()) {
                PsiSubstitutor containingClassSubstitutor;
                PsiClass containingClass;
                PsiMethod method = hms.getMethod();
                if (MethodSignatureUtil.findMethodBySignature(aClass, method.getSignature(superClassSubstitutor), false) != null || (containingClass = PsiSuperMethodUtil.correctClassByScope(method.getContainingClass(), resolveScope)) == null || (method = containingClass.findMethodBySignature(method, false)) == null || (containingClassSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, aClass, PsiSubstitutor.EMPTY)) == null) continue;
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                LinkedHashSet<PsiMethod> methods = (LinkedHashSet<PsiMethod>)overrideEquivalent.get(signature);
                if (methods == null) {
                    methods = new LinkedHashSet<PsiMethod>();
                    overrideEquivalent.put(signature, methods);
                }
                methods.add(method);
            }
        }
        THashMap tHashMap = overrideEquivalent;
        if (tHashMap == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(7);
        }
        return tHashMap;
    }

    @Nullable
    public static PsiClass correctClassByScope(PsiClass psiClass, GlobalSearchScope resolveScope) {
        if (psiClass == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return psiClass;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file == null || !file.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index = FileIndexFacade.getInstance((Project)file.getProject());
        if (!(index.isInSource(vFile) || index.isInLibrarySource(vFile) || index.isInLibraryClasses(vFile))) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(qualifiedName, resolveScope);
    }

    @Contract(value="null, _ -> null")
    public static PsiMethod correctMethodByScope(PsiMethod method, GlobalSearchScope resolveScope) {
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return method;
        }
        PsiClass correctedClass = PsiSuperMethodUtil.correctClassByScope(aClass, resolveScope);
        if (correctedClass == null || correctedClass == aClass) {
            return method;
        }
        PsiMethod correctedClassMethodBySignature = correctedClass.findMethodBySignature(method, false);
        return correctedClassMethodBySignature == null ? method : correctedClassMethodBySignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFinalSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverrideEquivalents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectOverrideEquivalents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

