/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyConfig;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDeploymentModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullLocalHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLibertyHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLibertyLocalHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLocalRunConfigurationEditor;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.util.ArrayList;

public class WebSphereLocalModel
extends WebSphereModel {
    public SettingsEditor<CommonModel> getEditor() {
        return new WebSphereLocalRunConfigurationEditor();
    }

    @Override
    protected WebSphereFullHandler createFullHandler(WebSphereVersion version) throws RuntimeConfigurationException {
        WebSphereServerConfiguration configuration = WebSphereProfileUtil.createValidServerConfiguration(version, new File(FileUtil.toSystemDependentName((String)this.PROFILE_PATH)), this.CELL_NAME, this.NODE_NAME, this.SERVER_NAME);
        return new WebSphereFullLocalHandler(this, version, configuration);
    }

    @Override
    public WebSphereLibertyHandler createLibertyHandler() throws RuntimeConfigurationException {
        return new WebSphereLibertyLocalHandler(this);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (this.isLibertyProfile()) {
            WebSphereLibertyConfig.checkJmxAdmin(this);
            for (DeploymentModel model : this.getCommonModel().getDeploymentModels()) {
                WebSphereDeploymentModel deploymentModel = (WebSphereDeploymentModel)model;
                Artifact artifact = deploymentModel.getArtifact();
                ArrayList ejbFacets = new ArrayList();
                if (artifact != null) {
                    ejbFacets.addAll(JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(this.getCommonModel().getProject(), artifact, EjbFacet.ID));
                }
                if (ejbFacets.isEmpty()) continue;
                WebSphereLibertyConfig.checkEjbFeature(this);
                return;
            }
        }
    }

    protected String getLogFilePath(String home) {
        return this.getProfileHandler().getLogFilePath();
    }

    public boolean isDetectableServerPort() {
        return this.getProfileHandler().isDetectableServerPort();
    }
}

