/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRemoteModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRunConfigurationEditorBase;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.util.RemoteConnectionTester;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereRemoteRunConfigurationEditor
extends WebSphereRunConfigurationEditorBase {
    private JPanel myMainPanel;
    private JTextField mySOAPPortField;
    private JTextField myLibertyServerField;
    private JButton myTestConnectionButton;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JCheckBox myUseSSLCheckBox;
    private TextFieldWithBrowseButton myClientTrustFileField;
    private JPanel mySSLPanel;
    private JPasswordField myClientTrustPasswordField;
    private TextFieldWithBrowseButton myClientKeyFileField;
    private JPasswordField myClientKeyPasswordField;
    private JLabel myUsernameLabel;
    private JLabel myPasswordLabel;
    private JLabel myCellLabel;
    private JLabel myNodeLabel;
    private JLabel mySOAPPortLabel;
    private ComboBox myCellComboBox;
    private ComboBox myNodeComboBox;
    private ComboBox myServerComboBox;
    private JLabel myServerLabel;
    private JLabel myLibertyServerLabel;
    private WebSphereRemoteModel.Profile myProfile;

    public WebSphereRemoteRunConfigurationEditor(final Project project) {
        this.$$$setupUI$$$();
        this.myUseSSLCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)WebSphereRemoteRunConfigurationEditor.this.mySSLPanel, (boolean)WebSphereRemoteRunConfigurationEditor.this.myUseSSLCheckBox.isSelected(), (boolean)true);
            }
        });
        this.myTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereRemoteModel.Profile profile;
                RemoteConnectionTesterExposed connectionTester = new RemoteConnectionTesterExposed(project, WebSphereRemoteRunConfigurationEditor.this);
                connectionTester.testConnection();
                CommonModel commonModel = connectionTester.getCommonModel();
                if (commonModel == null) {
                    return;
                }
                WebSphereRemoteModel model = (WebSphereRemoteModel)commonModel.getServerModel();
                if (!model.isLibertyProfile() && (profile = model.getProfile()) != null) {
                    WebSphereRemoteRunConfigurationEditor.this.setProfile(profile);
                }
            }
        });
        WebSphereRemoteRunConfigurationEditor.setupJksFileField(this.myClientTrustFileField, project);
        WebSphereRemoteRunConfigurationEditor.setupJksFileField(this.myClientKeyFileField, project);
        this.myCellComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereRemoteRunConfigurationEditor.this.onCellChanged();
            }
        });
        this.myNodeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereRemoteRunConfigurationEditor.this.onNodeChanged();
            }
        });
    }

    private static void setupJksFileField(TextFieldWithBrowseButton field, Project project) {
        field.addBrowseFolderListener(null, null, project, new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || "jks".equals(file.getExtension()));
            }
        });
    }

    protected void resetEditorFrom(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            WebSphereRemoteRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        WebSphereRemoteModel model = (WebSphereRemoteModel)commonModel.getServerModel();
        this.mySOAPPortField.setText(String.valueOf(model.SOAP_PORT));
        if (model.isLibertyProfile()) {
            this.myLibertyServerField.setText(model.SERVER_NAME);
        } else {
            this.setProfile(model.getProfile());
            this.myCellComboBox.getEditor().setItem(model.CELL_NAME);
            this.myNodeComboBox.getEditor().setItem(model.NODE_NAME);
            this.myServerComboBox.getEditor().setItem(model.SERVER_NAME);
        }
        this.myUsernameField.setText(model.USERNAME);
        this.myPasswordField.setText(model.PASSWORD);
        this.myUseSSLCheckBox.setSelected(model.SECURED);
        UIUtil.setEnabled((Component)this.mySSLPanel, (boolean)model.SECURED, (boolean)true);
        this.myClientTrustFileField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)model.CLIENT_TRUST_FILE_PATH)));
        this.myClientTrustPasswordField.setText(model.CLIENT_TRUST_PASSWORD);
        this.myClientKeyFileField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)model.CLIENT_KEY_FILE_PATH)));
        this.myClientKeyPasswordField.setText(model.CLIENT_KEY_PASSWORD);
    }

    protected void applyEditorTo(@NotNull CommonModel commonModel) throws ConfigurationException {
        if (commonModel == null) {
            WebSphereRemoteRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        WebSphereRemoteModel model = (WebSphereRemoteModel)commonModel.getServerModel();
        try {
            model.SOAP_PORT = Integer.parseInt(this.mySOAPPortField.getText());
            if (model.isLibertyProfile()) {
                model.CELL_NAME = "";
                model.NODE_NAME = "";
                model.SERVER_NAME = this.myLibertyServerField.getText();
                model.setProfile(null);
            } else {
                model.CELL_NAME = this.myCellComboBox.getEditor().getItem().toString();
                model.NODE_NAME = this.myNodeComboBox.getEditor().getItem().toString();
                model.SERVER_NAME = this.myServerComboBox.getEditor().getItem().toString();
                model.setProfile(this.myProfile);
            }
            model.USERNAME = this.myUsernameField.getText();
            model.PASSWORD = new String(this.myPasswordField.getPassword());
            model.SECURED = this.myUseSSLCheckBox.isSelected();
            model.CLIENT_TRUST_FILE_PATH = FileUtil.toSystemIndependentName((String)this.myClientTrustFileField.getText());
            model.CLIENT_TRUST_PASSWORD = new String(this.myClientTrustPasswordField.getPassword());
            model.CLIENT_KEY_FILE_PATH = FileUtil.toSystemIndependentName((String)this.myClientKeyFileField.getText());
            model.CLIENT_KEY_PASSWORD = new String(this.myClientKeyPasswordField.getPassword());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            WebSphereRemoteRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    protected JComponent[] getLibertyExcludedComponents() {
        return new JComponent[]{this.myUsernameLabel, this.myUsernameField, this.myPasswordLabel, this.myPasswordField, this.myCellLabel, this.myCellComboBox, this.myNodeLabel, this.myNodeComboBox, this.myServerLabel, this.myServerComboBox, this.mySOAPPortLabel, this.mySOAPPortField, this.myUseSSLCheckBox, this.mySSLPanel};
    }

    @Override
    protected void onVersionChanged(@Nullable ApplicationServer server, @Nullable WebSphereVersion version, boolean libertyProfile) {
        this.myLibertyServerLabel.setVisible(libertyProfile);
        this.myLibertyServerField.setVisible(libertyProfile);
    }

    private void setProfile(WebSphereRemoteModel.Profile profile) {
        this.myProfile = profile;
        String currentCell = this.myCellComboBox.getEditor().getItem().toString();
        this.myCellComboBox.removeAllItems();
        if (profile != null) {
            for (WebSphereRemoteModel.Cell cell : profile.getCells()) {
                this.myCellComboBox.addItem((Object)new CellItem(cell));
            }
        }
        this.myCellComboBox.getEditor().setItem(currentCell);
    }

    private void onCellChanged() {
        String currentNode = this.myNodeComboBox.getEditor().getItem().toString();
        this.myNodeComboBox.removeAllItems();
        Object selectedCell = this.myCellComboBox.getSelectedItem();
        if (selectedCell instanceof CellItem) {
            CellItem cellItem = (CellItem)selectedCell;
            for (WebSphereRemoteModel.Node node : cellItem.getCell().getNodes()) {
                this.myNodeComboBox.addItem((Object)new NodeItem(node));
            }
        }
        this.myNodeComboBox.getEditor().setItem(currentNode);
    }

    private void onNodeChanged() {
        String currentServer = this.myServerComboBox.getEditor().getItem().toString();
        this.myServerComboBox.removeAllItems();
        Object selectedNode = this.myNodeComboBox.getSelectedItem();
        if (selectedNode instanceof NodeItem) {
            NodeItem nodeItem = (NodeItem)selectedNode;
            for (WebSphereRemoteModel.Server server : nodeItem.getNode().getServers()) {
                this.myServerComboBox.addItem((Object)new ServerItem(server));
            }
        }
        this.myServerComboBox.getEditor().setItem(currentServer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2ee/webSphere/runDebug/configuration/WebSphereRemoteRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2ee/webSphere/runDebug/configuration/WebSphereRemoteRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JTextField jTextField;
        JLabel jLabel;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPasswordField jPasswordField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPasswordField jPasswordField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JButton jButton;
        JPasswordField jPasswordField3;
        JLabel jLabel2;
        JTextField jTextField2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JTextField jTextField3;
        JLabel jLabel7;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("title.run.configuration.server.connection.text"), (int)0, (int)0, null, null));
        this.myServerLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.remote.server.name.text"));
        jPanel2.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySOAPPortField = jTextField3 = new JTextField();
        jTextField3.setColumns(10);
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 3, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.mySOAPPortLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.soap.port.text"));
        jPanel2.add((Component)jLabel6, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCellLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.remote.cell.text"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNodeLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.remote.node.text"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.username.text"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(70, -1), null));
        this.myPasswordLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.password.text"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField3 = new JPasswordField();
        jPanel2.add((Component)jPasswordField3, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(70, -1), null));
        this.myTestConnectionButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("button.run.configuration.test.connection"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 5, 4, 1, 1, 1, 3, 0, null, null, null));
        this.myUseSSLCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use SSL connection");
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySSLPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(false);
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 6, 0, 3, 3, 3, null, null, null, 3));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Trust store:");
        jPanel.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClientTrustFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Trust store password:");
        jPanel.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClientTrustPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Key store:");
        jPanel.add((Component)jLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClientKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Key store password:");
        jPanel.add((Component)jLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClientKeyPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myCellComboBox = comboBox3 = new ComboBox();
        comboBox3.setEditable(true);
        jPanel2.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myNodeComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel2.add((Component)comboBox2, new GridConstraints(1, 3, 1, 1, 0, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myLibertyServerLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/j2ee/webSphere/WebSphereBundle").getString("label.run.configuration.remote.server.name.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibertyServerField = jTextField = new JTextField();
        jTextField.setColumns(20);
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 2, 1, 3, 0, 1, 6, 1, null, null, null));
        this.myServerComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel6.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jPasswordField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ServerItem {
        private final WebSphereRemoteModel.Server myServer;

        public ServerItem(WebSphereRemoteModel.Server server) {
            this.myServer = server;
        }

        public WebSphereRemoteModel.Server getServer() {
            return this.myServer;
        }

        public String toString() {
            return this.myServer.getName();
        }
    }

    private static class NodeItem {
        private final WebSphereRemoteModel.Node myNode;

        public NodeItem(WebSphereRemoteModel.Node node) {
            this.myNode = node;
        }

        public WebSphereRemoteModel.Node getNode() {
            return this.myNode;
        }

        public String toString() {
            return this.myNode.getName();
        }
    }

    private static class CellItem {
        private final WebSphereRemoteModel.Cell myCell;

        public CellItem(WebSphereRemoteModel.Cell cell) {
            this.myCell = cell;
        }

        public WebSphereRemoteModel.Cell getCell() {
            return this.myCell;
        }

        public String toString() {
            return this.myCell.getName();
        }
    }

    public static class RemoteConnectionTesterExposed
    extends RemoteConnectionTester {
        private CommonModel myModel;

        public RemoteConnectionTesterExposed(@Nullable Project project, SettingsEditor<CommonModel> owner) {
            super(project, owner);
        }

        @Nullable
        public CommonModel getCommonModel() {
            if (this.myModel == null) {
                this.myModel = super.getCommonModel();
            }
            return this.myModel;
        }
    }
}

