/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightInfoComposite
extends HighlightInfo {
    @NonNls
    private static final String LINE_BREAK = "<hr size=1 noshade>";

    HighlightInfoComposite(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfoComposite.$$$reportNull$$$0(0);
        }
        super(null, null, infos.get((int)0).type, infos.get((int)0).startOffset, infos.get((int)0).endOffset, HighlightInfoComposite.createCompositeDescription(infos), HighlightInfoComposite.createCompositeTooltip(infos), infos.get((int)0).type.getSeverity(null), false, null, false, 0, infos.get(0).getProblemGroup(), infos.get(0).getGutterIconRenderer());
        this.highlighter = infos.get(0).getHighlighter();
        this.setGroup(infos.get(0).getGroup());
        ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> markers = ContainerUtil.emptyList();
        ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> ranges = ContainerUtil.emptyList();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers != null) {
                if (markers == ContainerUtil.emptyList()) {
                    markers = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>>();
                }
                markers.addAll(info.quickFixActionMarkers);
            }
            if (info.quickFixActionRanges == null) continue;
            if (ranges == ContainerUtil.emptyList()) {
                ranges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
            }
            ranges.addAll(info.quickFixActionRanges);
        }
        this.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList((Collection)markers);
        this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList((Collection)ranges);
    }

    @Nullable
    private static String createCompositeDescription(List<HighlightInfo> infos) {
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo info : infos) {
            String itemDescription = info.getDescription();
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    private static String createCompositeTooltip(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfoComposite.$$$reportNull$$$0(1);
        }
        StringBuilder result2 = new StringBuilder();
        for (HighlightInfo info : infos) {
            String toolTip = info.getToolTip();
            if (toolTip == null) continue;
            if (result2.length() != 0) {
                result2.append(LINE_BREAK);
            }
            toolTip = XmlStringUtil.stripHtml((String)toolTip);
            result2.append(toolTip);
        }
        if (result2.length() == 0) {
            return null;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "infos";
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoComposite";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompositeTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

