/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickDocUtil {
    public static void updateQuickDocAsync(@NotNull PsiElement element, @NotNull Producer<String> docProducer) {
        if (element == null) {
            QuickDocUtil.$$$reportNull$$$0(0);
        }
        if (docProducer == null) {
            QuickDocUtil.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (element == null) {
                QuickDocUtil.$$$reportNull$$$0(8);
            }
            if (docProducer == null) {
                QuickDocUtil.$$$reportNull$$$0(9);
            }
            QuickDocUtil.updateQuickDoc(project, element, (String)docProducer.produce());
        });
    }

    public static void updateQuickDoc(@NotNull Project project, @NotNull PsiElement element, @Nullable String documentation) {
        if (project == null) {
            QuickDocUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            QuickDocUtil.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)documentation)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            DocumentationComponent component;
            if (project == null) {
                QuickDocUtil.$$$reportNull$$$0(6);
            }
            if (element == null) {
                QuickDocUtil.$$$reportNull$$$0(7);
            }
            if ((component = QuickDocUtil.getActiveDocComponent(project)) != null) {
                component.replaceText(documentation, element);
            }
        });
    }

    @Nullable
    public static DocumentationComponent getActiveDocComponent(@NotNull Project project) {
        DocumentationComponent component;
        DocumentationManager documentationManager;
        JBPopup hint;
        if (project == null) {
            QuickDocUtil.$$$reportNull$$$0(4);
        }
        if ((hint = (documentationManager = DocumentationManager.getInstance(project)).getDocInfoHint()) != null) {
            component = (DocumentationComponent)((AbstractPopup)hint).getComponent();
        } else if (documentationManager.hasActiveDockedDocWindow()) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.DOCUMENTATION);
            Content selectedContent = toolWindow == null ? null : toolWindow.getContentManager().getSelectedContent();
            component = selectedContent == null ? null : (DocumentationComponent)selectedContent.getComponent();
        } else {
            component = null;
        }
        return component;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean runInReadActionWithWriteActionPriorityWithRetries(@NotNull Runnable action, long timeout, long pauseBetweenRetries, @Nullable ProgressIndicator progressIndicator) {
        void progressIndicator2;
        boolean result2;
        if (action == null) {
            QuickDocUtil.$$$reportNull$$$0(5);
        }
        long deadline = System.currentTimeMillis() + timeout;
        while (!((result2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, progressIndicator2 == null ? null : new SensitiveProgressWrapper((ProgressIndicator)progressIndicator2))) || progressIndicator2 != null && progressIndicator2.isCanceled() || System.currentTimeMillis() >= deadline)) {
            try {
                TimeUnit.MILLISECONDS.sleep(pauseBetweenRetries);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docProducer";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDocAsync";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveDocComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runInReadActionWithWriteActionPriorityWithRetries";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateQuickDoc$1";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateQuickDocAsync$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

