/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlSlashTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile editedFile, @NotNull FileType fileType) {
        if (project == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(1);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            int offset = editor.getCaretModel().getOffset();
            if (file2 == null) {
                TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
                if (result2 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(4);
                }
                return result2;
            }
            FileViewProvider provider = file2.getViewProvider();
            PsiElement element = provider.findElementAt(offset, XMLLanguage.class);
            if (element instanceof XmlToken) {
                ASTNode parentNode;
                ASTNode child;
                IElementType tokenType = ((XmlToken)element).getTokenType();
                if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
                    if (result3 == null) {
                        XmlSlashTypedHandler.$$$reportNull$$$0(5);
                    }
                    return result3;
                }
                if (tokenType == XmlTokenType.XML_TAG_END && offset == element.getTextOffset() && (child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentNode = element.getParent().getNode())) != null && offset + 1 == child.getTextRange().getStartOffset()) {
                    editor.getDocument().replaceString(offset + 1, parentNode.getTextRange().getEndOffset(), (CharSequence)"");
                }
            }
        }
        TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.CONTINUE;
        if (result4 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(6);
        }
        return result4;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile editedFile) {
        if (project == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(8);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(9);
        }
        if (!WebEditorOptions.getInstance().isAutoCloseTag()) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                XmlSlashTypedHandler.$$$reportNull$$$0(10);
            }
            return result2;
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element2;
            XmlTag tag;
            int offset;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                if (result3 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(11);
                }
                return result3;
            }
            FileViewProvider provider = file2.getViewProvider();
            PsiElement element = provider.findElementAt((offset = editor.getCaretModel().getOffset()) - 1, XMLLanguage.class);
            if (element == null) {
                TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.CONTINUE;
                if (result4 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(12);
                }
                return result4;
            }
            if (!(element.getLanguage() instanceof XMLLanguage)) {
                TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
                if (result5 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(13);
                }
                return result5;
            }
            ASTNode prevLeaf = element.getNode();
            if (prevLeaf == null) {
                TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                if (result6 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(14);
                }
                return result6;
            }
            String prevLeafText = prevLeaf.getText();
            if ("</".equals(prevLeafText) && prevLeaf.getElementType() == XmlTokenType.XML_END_TAG_START && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && StringUtil.isNotEmpty((String)tag.getName()) && TreeUtil.findSibling(prevLeaf, XmlTokenType.XML_NAME) == null) {
                PsiElement element1;
                if (provider instanceof MultiplePsiFilesPerDocumentFileViewProvider && (element1 = SingleRootFileViewProvider.findElementAt((PsiElement)file2, offset - 1)) != null) {
                    XmlTag tag1 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element1, XmlTag.class);
                    if (XmlSlashTypedHandler.shouldReplace(tag, tag1, offset)) {
                        tag = tag1;
                    } else {
                        tag1 = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element1.getParent(), XmlTag.class);
                        if (XmlSlashTypedHandler.shouldReplace(tag, tag1, offset)) {
                            tag = tag1;
                        }
                    }
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(tag.getName() + ">"), (boolean)false);
                XmlSlashTypedHandler.autoIndent(editor);
                TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.STOP;
                if (result7 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(15);
                }
                return result7;
            }
            if (!"/".equals(prevLeafText.trim())) {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.CONTINUE;
                if (result8 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(16);
                }
                return result8;
            }
            while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
            }
            if (prevLeaf instanceof OuterLanguageElement) {
                element = file2.getViewProvider().findElementAt(offset - 1, file2.getLanguage());
                ASTNode aSTNode = prevLeaf = element != null ? element.getNode() : null;
                while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
                }
            }
            if (prevLeaf == null) {
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.CONTINUE;
                if (result9 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(17);
                }
                return result9;
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf.getPsi(), XmlTag.class);
            if (tag == null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element2 = provider.findElementAt(prevLeaf.getStartOffset(), XMLLanguage.class)), XmlTag.class)) == null) {
                TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
                if (result10 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(18);
                }
                return result10;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                TypedHandlerDelegate.Result result11 = TypedHandlerDelegate.Result.CONTINUE;
                if (result11 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(19);
                }
                return result11;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) != null) {
                TypedHandlerDelegate.Result result12 = TypedHandlerDelegate.Result.CONTINUE;
                if (result12 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(20);
                }
                return result12;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                TypedHandlerDelegate.Result result13 = TypedHandlerDelegate.Result.CONTINUE;
                if (result13 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(21);
                }
                return result13;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null) {
                TypedHandlerDelegate.Result result14 = TypedHandlerDelegate.Result.CONTINUE;
                if (result14 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(22);
                }
                return result14;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)false);
            TypedHandlerDelegate.Result result15 = TypedHandlerDelegate.Result.STOP;
            if (result15 == null) {
                XmlSlashTypedHandler.$$$reportNull$$$0(23);
            }
            return result15;
        }
        TypedHandlerDelegate.Result result16 = TypedHandlerDelegate.Result.CONTINUE;
        if (result16 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(24);
        }
        return result16;
    }

    private static boolean shouldReplace(XmlTag tag, XmlTag tag1, int offset) {
        if (tag1 == null || tag1 == tag || tag1.getTextOffset() <= tag.getTextOffset()) {
            return false;
        }
        if (XmlSlashTypedHandler.hasUnclosedParent(tag1)) {
            return true;
        }
        if (XmlUtil.getTokenOfType((PsiElement)tag1, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
            return false;
        }
        XmlToken element = XmlTagUtil.getEndTagNameElement((XmlTag)tag1);
        return element != null && element.getTextOffset() > offset;
    }

    private static boolean hasUnclosedParent(XmlTag tag) {
        String name = tag.getName();
        while (tag != null) {
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null && XmlTagUtil.getEndTagNameElement((XmlTag)tag) == null && name.equals(tag.getName())) {
                return true;
            }
            tag = tag.getParentTag();
        }
        return false;
    }

    private static void autoIndent(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(25);
        }
        if ((project = editor.getProject()) != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = editor.getDocument();
            documentManager.commitDocument(document);
            int lineOffset = document.getLineStartOffset(document.getLineNumber(editor.getCaretModel().getOffset()));
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, lineOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "autoIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

