/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElementSignatureProvider
implements ElementSignatureProvider {
    static final String ELEMENTS_SEPARATOR = ";";
    static final String ELEMENT_TOKENS_SEPARATOR = "#";
    private static final String ESCAPE_CHAR = "\\";
    private static final List<String> ESCAPE_FROM = Arrays.asList("\\", "#", ";");
    private static final List<String> ESCAPE_TO = Arrays.asList("\\\\", "\\s", "\\h");

    @Override
    @Nullable
    public PsiElement restoreBySignature(@NotNull PsiFile file2, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        PsiFile parent;
        int semicolonIndex;
        if (file2 == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (signature == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if ((semicolonIndex = signature.indexOf(ELEMENTS_SEPARATOR)) >= 0) {
            String parentSignature = signature.substring(semicolonIndex + 1);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Provider '%s'. Restoring parent by signature '%s'...%n", this.getClass().getName(), parentSignature));
            }
            parent = this.restoreBySignature(file2, parentSignature, processingInfoStorage);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Restored parent by signature '%s': %s%n", parentSignature, parent));
            }
            if (parent == null) {
                return null;
            }
            signature = signature.substring(0, semicolonIndex);
        } else {
            parent = file2;
        }
        StringTokenizer tokenizer = new StringTokenizer(signature, ELEMENT_TOKENS_SEPARATOR);
        String type = tokenizer.nextToken();
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Provider '%s'. Restoring target element by signature '%s'. Parent: %s, same as the given parent: %b%n", this.getClass().getName(), signature, parent, parent == file2));
        }
        return this.restoreBySignatureTokens(file2, (PsiElement)parent, type, tokenizer, processingInfoStorage);
    }

    @Nullable
    protected abstract PsiElement restoreBySignatureTokens(@NotNull PsiFile var1, @NotNull PsiElement var2, @NotNull String var3, @NotNull StringTokenizer var4, @Nullable StringBuilder var5);

    protected static <T extends PsiNamedElement> int getChildIndex(T element, PsiElement parent, String name, Class<T> hisClass) {
        PsiElement[] children2 = parent.getChildren();
        int index = 0;
        for (PsiElement child : children2) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, child.getClass()) || !Comparing.equal((String)name, (String)(childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName()))) continue;
            if (namedChild.equals(element)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @Nullable
    static <T extends PsiNamedElement> T restoreElementInternal(@NotNull PsiElement parent, String name, int index, @NotNull Class<T> hisClass) {
        PsiElement[] children2;
        if (parent == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(2);
        }
        if (hisClass == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(3);
        }
        for (PsiElement child : children2 = parent.getChildren()) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, child.getClass()) || !Comparing.equal((String)name, (String)(childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName()))) continue;
            if (index == 0) {
                return (T)namedChild;
            }
            --index;
        }
        return null;
    }

    protected static String escape(String name) {
        return StringUtil.replace((String)name, ESCAPE_FROM, ESCAPE_TO);
    }

    protected static String unescape(String name) {
        return StringUtil.replace((String)name, ESCAPE_TO, ESCAPE_FROM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hisClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignature";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreElementInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

