/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.FoldingUpdate");
    static final Key<ParameterizedCachedValue<Runnable, Boolean>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    private static final Key<String> CODE_FOLDING_FILE_EXTENSION_KEY = Key.create((String)"code folding file extension");
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(@NotNull Editor editor, @NotNull PsiFile file2, boolean applyDefaultState, boolean quick) {
        String oldExtension;
        ParameterizedCachedValue value;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = file2.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        String currentFileExtension = null;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            currentFileExtension = virtualFile.getExtension();
        }
        if ((value = (ParameterizedCachedValue)editor.getUserData(CODE_FOLDING_KEY)) != null && ((oldExtension = (String)editor.getUserData(CODE_FOLDING_FILE_EXTENSION_KEY)) == null ? currentFileExtension != null : !oldExtension.equals(currentFileExtension))) {
            value = null;
            editor.putUserData(CODE_FOLDING_KEY, null);
        }
        editor.putUserData(CODE_FOLDING_FILE_EXTENSION_KEY, (Object)currentFileExtension);
        if (value != null && value.hasUpToDateValue() && !applyDefaultState) {
            return (Runnable)value.getValue(null);
        }
        if (quick) {
            return (Runnable)FoldingUpdate.getUpdateResult(file2, document, true, project, editor, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, param -> {
            if (editor == null) {
                FoldingUpdate.$$$reportNull$$$0(16);
            }
            Document document1 = editor.getDocument();
            PsiFile file1 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document1);
            return FoldingUpdate.getUpdateResult(file1, document1, false, project, editor, param);
        }, false, (Object)applyDefaultState);
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(PsiFile file2, @NotNull Document document, boolean quick, Project project, Editor editor, boolean applyDefaultState) {
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(2);
        }
        List<RegionInfo> elementsToFold = FoldingUpdate.getFoldingsFor(file2, document, quick);
        UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project, editor, file2, elementsToFold, applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO, !applyDefaultState, false);
        long documentTimestamp = document.getModificationStamp();
        int documentLength = document.getTextLength();
        AtomicBoolean alreadyExecuted = new AtomicBoolean();
        Runnable runnable2 = () -> {
            if (alreadyExecuted.compareAndSet(false, true)) {
                if (documentTimestamp != editor.getDocument().getModificationStamp()) {
                    LOG.error("Document has changed since fold regions were calculated");
                } else if (documentLength != editor.getDocument().getTextLength()) {
                    LOG.error("Document length has changed since fold regions were calculated");
                }
                editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(document);
        dependencies.add(editor.getFoldingModel());
        for (RegionInfo info : elementsToFold) {
            dependencies.addAll(info.descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create((Object)runnable2, (Object[])ArrayUtil.toObjectArray(dependencies));
    }

    @Nullable
    public static Runnable updateInjectedFoldRegions(@NotNull Editor editor, @NotNull PsiFile file2, boolean applyDefaultState) {
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(4);
        }
        if (file2 instanceof PsiCompiledElement) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = file2.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        FoldingModel foldingModel = editor.getFoldingModel();
        long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        List injectedDocuments = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(file2, file2.getTextRange());
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        ArrayList injectedEditors = new ArrayList();
        ArrayList injectedFiles = new ArrayList();
        ArrayList lists = new ArrayList();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate(injectedDocument, file2, (injectedFile, places) -> {
                if (editor == null) {
                    FoldingUpdate.$$$reportNull$$$0(15);
                }
                if (!injectedFile.isValid()) {
                    return;
                }
                Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                if (!(injectedEditor instanceof EditorWindow)) {
                    return;
                }
                injectedEditors.add((EditorWindow)injectedEditor);
                injectedFiles.add(injectedFile);
                ArrayList<RegionInfo> map = new ArrayList<RegionInfo>();
                lists.add(map);
                FoldingUpdate.getFoldingsFor(injectedFile, injectedEditor.getDocument(), map, false);
            });
        }
        return () -> {
            if (editor == null) {
                FoldingUpdate.$$$reportNull$$$0(14);
            }
            ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
            for (int i = 0; i < injectedEditors.size(); ++i) {
                EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                if (!injectedEditor.getDocument().isValid()) continue;
                List list2 = (List)lists.get(i);
                updateOperations.add(new UpdateFoldRegionsOperation(project, injectedEditor, injectedFile, list2, applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO, !applyDefaultState, true));
            }
            foldingModel.runBatchFoldingOperation(() -> {
                for (Runnable operation : updateOperations) {
                    operation.run();
                }
            });
            editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
        };
    }

    public static boolean supportsDumbModeFolding(@NotNull Editor editor) {
        PsiFile file2;
        Project project;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(5);
        }
        if ((project = editor.getProject()) != null && (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return FoldingUpdate.supportsDumbModeFolding(file2);
        }
        return true;
    }

    static boolean supportsDumbModeFolding(@NotNull PsiFile file2) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(6);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware((Object)foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    static List<RegionInfo> getFoldingsFor(@NotNull PsiFile file2, @NotNull Document document, boolean quick) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(7);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(8);
        }
        ArrayList<RegionInfo> foldingMap = new ArrayList<RegionInfo>();
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        FoldingUpdate.getFoldingsFor(file2, document, foldingMap, quick);
        return foldingMap;
    }

    private static void getFoldingsFor(@NotNull PsiFile file2, @NotNull Document document, @NotNull List<RegionInfo> elementsToFold, boolean quick) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(9);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(10);
        }
        if (elementsToFold == null) {
            FoldingUpdate.$$$reportNull$$$0(11);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psi = viewProvider.getPsi(language);
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (psi == null || foldingBuilder == null) continue;
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)quick)) {
                PsiElement psiElement = descriptor.getElement().getPsi();
                if (psiElement == null) {
                    LOG.error("No PSI for folding descriptor " + descriptor);
                    continue;
                }
                if (!docRange.contains(descriptor.getRange())) {
                    FoldingUpdate.diagnoseIncorrectRange(psi, document, language, foldingBuilder, descriptor, psiElement);
                    continue;
                }
                RegionInfo regionInfo = new RegionInfo(descriptor, psiElement);
                elementsToFold.add(regionInfo);
            }
        }
    }

    private static void diagnoseIncorrectRange(@NotNull PsiFile file2, @NotNull Document document, Language language, FoldingBuilder foldingBuilder, FoldingDescriptor descriptor, PsiElement psiElement) {
        Attachment[] attachmentArray;
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(12);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(13);
        }
        String message = "Folding descriptor " + descriptor + " made by " + foldingBuilder + " for " + language + " is outside document range, PSI element: " + psiElement + ", PSI element range: " + psiElement.getTextRange() + "; " + DebugUtil.diagnosePsiDocumentInconsistency(psiElement, document);
        if (ApplicationManager.getApplication().isInternal()) {
            Attachment[] attachmentArray2 = new Attachment[2];
            attachmentArray2[0] = AttachmentFactory.createAttachment(document);
            attachmentArray = attachmentArray2;
            attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString((PsiElement)file2, false, true));
        } else {
            attachmentArray = Attachment.EMPTY_ARRAY;
        }
        LOG.error(message, attachmentArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFoldRegions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpdateResult";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInjectedFoldRegions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsDumbModeFolding";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getFoldingsFor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "diagnoseIncorrectRange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateInjectedFoldRegions$4";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateInjectedFoldRegions$2";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateFoldRegions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class RegionInfo {
        @NotNull
        public final FoldingDescriptor descriptor;
        public final PsiElement element;
        public final String signature;
        public final boolean collapsedByDefault;

        private RegionInfo(@NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement) {
            if (descriptor == null) {
                RegionInfo.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(1);
            }
            this.descriptor = descriptor;
            this.element = psiElement;
            this.collapsedByDefault = FoldingPolicy.isCollapseByDefault(psiElement);
            this.signature = RegionInfo.createSignature(psiElement);
        }

        private static String createSignature(@NotNull PsiElement element) {
            PsiFile containingFile;
            PsiElement restoredElement;
            String signature;
            if (element == null) {
                RegionInfo.$$$reportNull$$$0(2);
            }
            if ((signature = FoldingPolicy.getSignature(element)) != null && !element.equals(restoredElement = FoldingPolicy.restoreBySignature(containingFile = element.getContainingFile(), signature))) {
                StringBuilder trace = new StringBuilder();
                PsiElement restoredAgain = FoldingPolicy.restoreBySignature(containingFile, signature, trace);
                LOG.error("element: " + element + "(" + element.getText() + "); restoredElement: " + restoredElement + "; signature: '" + signature + "'; file: " + containingFile + "; injected: " + InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(containingFile) + "; languages: " + containingFile.getViewProvider().getLanguages() + "; restored again: " + restoredAgain + "; restore produces same results: " + (restoredAgain == restoredElement) + "; trace:\n" + trace);
            }
            return signature;
        }

        public String toString() {
            return this.descriptor + ", collapsedByDefault=" + this.collapsedByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate$RegionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSignature";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

