/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.PsiUtilBase;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentMacro
extends MacroBase {
    private final Function<Commenter, String> myCommenterFunction;

    protected CommentMacro(String name, String description, Function<Commenter, String> commenterFunction) {
        super(name, description);
        this.myCommenterFunction = commenterFunction;
    }

    @Override
    @Nullable
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context, boolean quick) {
        Editor editor;
        if (params == null) {
            CommentMacro.$$$reportNull$$$0(0);
        }
        Language language = (editor = context.getEditor()) == null ? null : PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)context.getProject());
        Commenter commenter = language == null ? null : (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        String lineCommentPrefix = commenter == null ? null : this.myCommenterFunction.apply(commenter);
        return lineCommentPrefix == null ? null : new TextResult(lineCommentPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/CommentMacro", "calculateResult"));
    }

    public static class AnyCommentEnd
    extends CommentMacro {
        public AnyCommentEnd() {
            super("commentEnd", "Comment end characters for the current language, empty if the language has line comments", commenter -> {
                String line = commenter.getLineCommentPrefix();
                return StringUtil.isNotEmpty((String)line) ? "" : commenter.getBlockCommentSuffix();
            });
        }
    }

    public static class AnyCommentStart
    extends CommentMacro {
        public AnyCommentStart() {
            super("commentStart", "Comment start characters for the current language, preferring line comment, if it exists", commenter -> {
                String line = commenter.getLineCommentPrefix();
                return StringUtil.isNotEmpty((String)line) ? line : commenter.getBlockCommentPrefix();
            });
        }
    }

    public static class BlockCommentEnd
    extends CommentMacro {
        public BlockCommentEnd() {
            super("blockCommentEnd", "Block comment end characters for the current language", Commenter::getBlockCommentSuffix);
        }
    }

    public static class BlockCommentStart
    extends CommentMacro {
        public BlockCommentStart() {
            super("blockCommentStart", "Block comment start characters for the current language", Commenter::getBlockCommentPrefix);
        }
    }

    public static class LineCommentStart
    extends CommentMacro {
        public LineCommentStart() {
            super("lineCommentStart", "Line comment start characters for the current language", Commenter::getLineCommentPrefix);
        }
    }
}

