/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionRVContentProviderImpl
extends InspectionRVContentProvider {
    public InspectionRVContentProviderImpl(Project project) {
        super(project);
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        if (context == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(0);
        }
        if (toolWrapper == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(1);
        }
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        presentation.updateContent();
        AnalysisScope scope = context.getCurrentScope();
        if (scope == null) {
            return false;
        }
        SearchScope searchScope = scope.toSearchScope();
        if (searchScope instanceof LocalSearchScope) {
            Map<String, Set<RefEntity>> contents = presentation.getContent();
            SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation.getProblemElements();
            for (Set<RefEntity> entities : contents.values()) {
                Iterator<RefEntity> iterator = entities.iterator();
                while (iterator.hasNext()) {
                    TextRange range2;
                    PsiElement element;
                    VirtualFile vFile;
                    SmartPsiElementPointer pointer;
                    RefEntity entity = iterator.next();
                    if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (vFile = pointer.getVirtualFile()) != null && searchScope.contains(vFile) && (element = ((RefElement)entity).getElement()) != null && (range2 = element.getTextRange()) != null && ((LocalSearchScope)searchScope).containsRange(element.getContainingFile(), range2)) continue;
                    problemElements.remove(entity);
                    iterator.remove();
                }
            }
        }
        return presentation.hasReportedProblems();
    }

    @Override
    @NotNull
    public QuickFixAction[] getCommonQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        if (toolWrapper == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(2);
        }
        if (tree == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(3);
        }
        InspectionToolPresentation presentation = tree.getContext().getPresentation(toolWrapper);
        QuickFixAction[] fixes = InspectionRVContentProviderImpl.getCommonFixes(presentation, tree.getSelectedDescriptors());
        QuickFixAction[] quickFixActionArray = (QuickFixAction[])ArrayUtil.mergeArrays((Object[])fixes, (Object[])presentation.getQuickFixes(tree.getSelectedElements()), QuickFixAction[]::new);
        if (quickFixActionArray == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(4);
        }
        return quickFixActionArray;
    }

    @Override
    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Function<RefEntity, CommonProblemDescriptor[]> problems) {
        if (context == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(5);
        }
        if (toolNode == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(7);
        }
        if (contents == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(8);
        }
        if (problems == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(9);
        }
        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
        InspectionNode mergedToolNode = (InspectionNode)InspectionRVContentProviderImpl.merge(toolNode, parentNode, !groupBySeverity);
        this.buildTree(context, contents, false, toolWrapper, refElement -> {
            if (problems == null) {
                InspectionRVContentProviderImpl.$$$reportNull$$$0(14);
            }
            return new InspectionRVContentProvider.RefEntityContainer<Object>((RefEntity)refElement, (Descriptor[])((Object[])problems.apply((RefEntity)refElement)));
        }, showStructure, node -> InspectionRVContentProviderImpl.merge(node, mergedToolNode, true));
        return mergedToolNode;
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container, @NotNull InspectionTreeNode pNode, boolean canPackageRepeat) {
        if (context == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(10);
        }
        if (toolWrapper == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(11);
        }
        if (container == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(12);
        }
        if (pNode == null) {
            InspectionRVContentProviderImpl.$$$reportNull$$$0(13);
        }
        RefEntity refElement = container.getRefEntity();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        CommonProblemDescriptor[] problems = (CommonProblemDescriptor[])container.getDescriptors();
        if (problems != null && problems.length != 0) {
            RefElementNode elemNode = InspectionRVContentProviderImpl.addNodeToParent(container, presentation, pNode);
            for (CommonProblemDescriptor problem : problems) {
                assert (problem != null);
                elemNode.insertByOrder((InspectionTreeNode)ReadAction.compute(() -> new ProblemDescriptionNode(refElement, problem, presentation)), false);
                elemNode.setProblem(elemNode.getChildCount() == 1 ? problems[0] : null);
            }
        } else {
            HashSet currentEntities;
            Set<RefEntity> currentElements;
            if (canPackageRepeat && pNode instanceof InspectionPackageNode && (currentElements = presentation.getContent().get(((InspectionPackageNode)pNode).getPackageName())) != null && RefUtil.contains((RefEntity)refElement, (Collection)(currentEntities = new HashSet(currentElements)))) {
                return;
            }
            InspectionRVContentProviderImpl.addNodeToParent(container, presentation, pNode);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkReportedProblems";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommonQuickFixes";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendToolNodeContent";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendToolNodeContent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

