/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.SequentialTask;
import org.jetbrains.annotations.NotNull;

public abstract class PerformFixesModalTask
implements SequentialTask {
    @NotNull
    protected final Project myProject;
    private final CommonProblemDescriptor[] myDescriptors;
    private final PsiDocumentManager myDocumentManager;
    private int myCount;

    public PerformFixesModalTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors) {
        if (project == null) {
            PerformFixesModalTask.$$$reportNull$$$0(0);
        }
        if (descriptors == null) {
            PerformFixesModalTask.$$$reportNull$$$0(1);
        }
        this.myCount = 0;
        this.myProject = project;
        this.myDescriptors = descriptors;
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myCount > this.myDescriptors.length - 1;
    }

    public boolean iteration() {
        return true;
    }

    public void doRun(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        while (!this.isDone() && !indicator.isCanceled()) {
            this.iteration(indicator);
        }
    }

    public boolean iteration(ProgressIndicator indicator) {
        CommonProblemDescriptor descriptor = this.myDescriptors[this.myCount++];
        if (indicator != null) {
            PsiElement psiElement;
            indicator.setFraction((double)this.myCount / (double)this.myDescriptors.length);
            String presentableText = "usages";
            if (descriptor instanceof ProblemDescriptor && (psiElement = ((ProblemDescriptor)descriptor).getPsiElement()) != null) {
                presentableText = SymbolPresentationUtil.getSymbolPresentableText(psiElement);
            }
            indicator.setText("Processing " + presentableText);
        }
        boolean[] runInReadAction = new boolean[]{false};
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null) {
            for (QuickFix fix : fixes) {
                if (fix.startInWriteAction()) {
                    runInReadAction[0] = false;
                    break;
                }
                runInReadAction[0] = true;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myDocumentManager.commitAllDocuments();
            if (!runInReadAction[0]) {
                this.applyFix(this.myProject, descriptor);
            }
        });
        if (runInReadAction[0]) {
            this.applyFix(this.myProject, descriptor);
        }
        return this.isDone();
    }

    public void stop() {
    }

    protected abstract void applyFix(Project var1, CommonProblemDescriptor var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptors";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/ex/PerformFixesModalTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

