/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUnknownTagInspectionBase
extends HtmlUnknownElementInspection {
    public static final Key<HtmlUnknownElementInspection> TAG_KEY = Key.create((String)"HtmlUnknownTag");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection");

    public HtmlUnknownTagInspectionBase(@NotNull String defaultValues) {
        if (defaultValues == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(0);
        }
        super(defaultValues);
    }

    public HtmlUnknownTagInspectionBase() {
        this("nobr,noembed,comment,noscript,embed,script");
    }

    private static boolean isAbstractDescriptor(XmlElementDescriptor descriptor) {
        return descriptor == null || descriptor instanceof AnyXmlElementDescriptor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.tag", (Object[])new Object[0]);
        if (string == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownTag" == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(2);
        }
        return "HtmlUnknownTag";
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        String string = XmlBundle.message((String)"html.inspections.unknown.tag.title", (Object[])new Object[0]);
        if (string == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlElementDescriptor ownDescriptor;
        if (tag == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(6);
        }
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        XmlElementDescriptor descriptorFromContext = XmlUtil.getDescriptorFromContext(tag);
        PsiElement parent = tag.getParent();
        XmlElementDescriptor parentDescriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
        XmlElementDescriptor xmlElementDescriptor = ownDescriptor = HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext) ? tag.getDescriptor() : descriptorFromContext;
        if (HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) || parentDescriptor instanceof HtmlElementDescriptorImpl && ownDescriptor instanceof HtmlElementDescriptorImpl && HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext)) {
            String name = tag.getName();
            if (!this.isCustomValuesEnabled() || !this.isCustomValue(name)) {
                ProblemHighlightType highlightType;
                AddCustomHtmlElementIntentionAction action = new AddCustomHtmlElementIntentionAction(TAG_KEY, name, XmlBundle.message((String)"add.custom.html.tag", (Object[])new Object[]{name}));
                String message = HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) ? XmlErrorMessages.message("unknown.html.tag", name) : XmlErrorMessages.message("element.is.not.allowed.here", name);
                XmlToken startTagName = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                assert (startTagName != null);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
                ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>();
                quickfixes.add(action);
                if (isOnTheFly) {
                    PsiFile file2 = startTagName.getContainingFile();
                    if (file2 instanceof XmlFile) {
                        quickfixes.add(XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)startTagName, "", null));
                    }
                    ContainerUtil.addIfNotNull(quickfixes, (Object)this.createChangeTemplateDataFix(file2));
                }
                if (HtmlUtil.isHtml5Tag(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag)) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                ProblemHighlightType problemHighlightType = highlightType = tag.getContainingFile().getContext() == null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                if (startTagName.getTextLength() > 0) {
                    holder.registerProblem((PsiElement)startTagName, message, highlightType, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
                }
                if (endTagName != null) {
                    holder.registerProblem((PsiElement)endTagName, message, highlightType, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
                }
            }
        }
    }

    @Nullable
    protected LocalQuickFix createChangeTemplateDataFix(PsiFile file2) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

