/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixPreviewPanelFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixPreviewPanelFactory.class);
    private static final int MAX_FIX_COUNT = 3;

    @Nullable
    public static JComponent create(@NotNull InspectionResultsView view) {
        if (view == null) {
            QuickFixPreviewPanelFactory.$$$reportNull$$$0(0);
        }
        if (view.isUpdating() && !view.getTree().areDescriptorNodesSelected()) {
            return new LoadingInProgressPreview(view);
        }
        QuickFixReadyPanel panel2 = new QuickFixReadyPanel(view);
        return panel2.isEmpty() ? null : panel2;
    }

    @NotNull
    private static SimpleColoredComponent getLabel(int problemsCount) {
        SimpleColoredComponent label = new SimpleColoredComponent();
        QuickFixPreviewPanelFactory.appendTextToLabel(label, problemsCount);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)2));
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            QuickFixPreviewPanelFactory.$$$reportNull$$$0(1);
        }
        return simpleColoredComponent;
    }

    private static void appendTextToLabel(SimpleColoredComponent label, int problemsCount) {
        label.append(problemsCount + " " + StringUtil.pluralize((String)"problem", (int)problemsCount) + ":");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoadingInProgressPreview
    extends JPanel
    implements InspectionTreeLoadingProgressAware {
        private final InspectionResultsView myView;
        private SimpleColoredComponent myWaitingLabel;

        private LoadingInProgressPreview(InspectionResultsView view) {
            this.myView = view;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder((Border)JBUI.Borders.empty((int)16, (int)9, (int)13, (int)0));
            AsyncProcessIcon waitingIcon = new AsyncProcessIcon("Inspection preview panel updating...");
            Disposer.register((Disposable)this, (Disposable)waitingIcon);
            this.myWaitingLabel = QuickFixPreviewPanelFactory.getLabel(this.myView.getTree().getSelectedProblemCount(false));
            this.add((Component)this.myWaitingLabel);
            this.add((Component)waitingIcon);
        }

        @Override
        public void updateLoadingProgress() {
            if (this.myWaitingLabel != null) {
                this.myWaitingLabel.clear();
                InspectionTree tree = this.myView.getTree();
                QuickFixPreviewPanelFactory.appendTextToLabel(this.myWaitingLabel, tree.getSelectedProblemCount(false));
            }
        }

        @Override
        public void treeLoaded() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                }
            });
        }

        @Override
        public void dispose() {
        }
    }

    private static class QuickFixReadyPanel
    extends JPanel {
        @NotNull
        private final InspectionResultsView myView;
        private final InspectionToolWrapper myWrapper;
        private final boolean myEmpty;

        public QuickFixReadyPanel(@NotNull InspectionResultsView view) {
            if (view == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(0);
            }
            this.myView = view;
            this.myWrapper = view.getTree().getSelectedToolWrapper(true);
            LOG.assertTrue(this.myWrapper != null);
            QuickFixAction[] commonFixes = view.getProvider().getCommonQuickFixes(this.myWrapper, view.getTree());
            boolean multipleDescriptors = this.myView.getTree().getSelectedDescriptors(false, null, false, true).length > 1;
            QuickFixAction[] partialFixes = QuickFixAction.EMPTY;
            if (multipleDescriptors && commonFixes.length == 0) {
                partialFixes = view.getProvider().getPartialQuickFixes(this.myWrapper, view.getTree());
            }
            this.myEmpty = this.fillPanel(commonFixes, partialFixes, multipleDescriptors, view);
        }

        public boolean isEmpty() {
            return this.myEmpty;
        }

        private boolean fillPanel(@NotNull QuickFixAction[] fixes, @NotNull QuickFixAction[] partialFixes, boolean multipleDescriptors, @NotNull InspectionResultsView view) {
            AnAction suppressionCombo;
            if (fixes == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(1);
            }
            if (partialFixes == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(2);
            }
            if (view == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(3);
            }
            boolean hasFixes = fixes.length != 0;
            this.setLayout(new BoxLayout(this, 2));
            boolean hasComponents = false;
            int actualProblemCount = this.myView.getTree().getContext().getPresentation(this.myWrapper).getProblemsCount(this.myView.getTree());
            if (actualProblemCount > 1 || actualProblemCount == 1 && multipleDescriptors) {
                this.add((Component)QuickFixPreviewPanelFactory.getLabel(actualProblemCount));
                hasComponents = true;
            }
            DefaultActionGroup actions = new DefaultActionGroup();
            if (hasFixes) {
                actions.addAll(QuickFixReadyPanel.createFixActions(fixes, multipleDescriptors));
            }
            if ((suppressionCombo = QuickFixReadyPanel.createSuppressionCombo(this.myView)) != null) {
                actions.add(suppressionCombo);
            }
            if (partialFixes.length != 0) {
                actions.add(QuickFixReadyPanel.createPartialFixCombo(partialFixes));
            }
            if (actions.getChildrenCount() != 0) {
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("inspection.view.quick.fix.preview", (ActionGroup)actions, true);
                JComponent component = toolbar.getComponent();
                toolbar.setTargetComponent((JComponent)view);
                this.add(component);
                hasComponents = true;
            }
            if (hasComponents) {
                int top = hasFixes ? 2 : 9;
                int left = hasFixes || multipleDescriptors ? 8 : 5;
                int bottom = hasFixes ? 0 : 8;
                this.setBorder((Border)JBUI.Borders.empty((int)top, (int)left, (int)bottom, (int)0));
            }
            return !hasComponents;
        }

        @NotNull
        private static AnAction createPartialFixCombo(QuickFixAction[] fixes) {
            final DefaultActionGroup group = new DefaultActionGroup();
            for (QuickFixAction fix : fixes) {
                group.add((AnAction)fix);
            }
            ComboBoxAction comboBoxAction = new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText("Fix partially");
                    this.setSmallVariant(false);
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                    DefaultActionGroup defaultActionGroup = group;
                    if (defaultActionGroup == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return defaultActionGroup;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$1", "createPopupActionGroup"));
                }
            };
            if (comboBoxAction == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(4);
            }
            return comboBoxAction;
        }

        @Nullable
        private static AnAction createSuppressionCombo(InspectionResultsView view) {
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"CodeInspection", null, (DataContext)DataManager.getInstance().getDataContext((Component)view));
            AnAction[] suppressors = new SuppressActionWrapper().getChildren(event);
            final AnAction[] availableSuppressors = (AnAction[])Arrays.stream(suppressors).filter(s -> {
                event.getPresentation().setEnabled(false);
                s.update(event);
                return event.getPresentation().isEnabled();
            }).toArray(AnAction[]::new);
            if (availableSuppressors.length == 0) {
                return null;
            }
            ComboBoxAction action = new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText("Suppress");
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                    DefaultCompactActionGroup group = new DefaultCompactActionGroup();
                    group.addAll(availableSuppressors);
                    DefaultCompactActionGroup defaultCompactActionGroup = group;
                    if (defaultCompactActionGroup == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return defaultCompactActionGroup;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$2", "createPopupActionGroup"));
                }
            };
            action.setSmallVariant(false);
            return action;
        }

        @NotNull
        private static AnAction[] createFixActions(final QuickFixAction[] fixes, final boolean multipleDescriptors) {
            if (fixes.length > 3) {
                ComboBoxAction fixComboBox = new ComboBoxAction(){
                    {
                        this.getTemplatePresentation().setText("Apply quick fixes" + (multipleDescriptors ? " to all the problems" : ""));
                        this.getTemplatePresentation().setIcon(AllIcons.Actions.CreateFromUsage);
                        this.setSmallVariant(false);
                    }

                    @NotNull
                    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                        DefaultActionGroup actionGroup = new DefaultActionGroup();
                        for (QuickFixAction fix : fixes) {
                            actionGroup.add((AnAction)fix);
                        }
                        DefaultActionGroup defaultActionGroup = actionGroup;
                        if (defaultActionGroup == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return defaultActionGroup;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$3", "createPopupActionGroup"));
                    }
                };
                AnAction[] anActionArray = new AnAction[]{fixComboBox};
                if (anActionArray == null) {
                    QuickFixReadyPanel.$$$reportNull$$$0(5);
                }
                return anActionArray;
            }
            if (fixes == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(6);
            }
            return fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "partialFixes";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPartialFixCombo";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFixActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillPanel";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

