/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StorageUtilKt$getOrCreateVirtualFile$;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002\u001a2\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0018H\u0002\u001a0\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u001a\u0018\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 \" \u0010\u0000\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006!"}, d2={"DEBUG_LOG", "", "getDEBUG_LOG", "()Ljava/lang/String;", "setDEBUG_LOG", "(Ljava/lang/String;)V", "NOTIFICATION_GROUP_ID", "getNOTIFICATION_GROUP_ID", "checkUnknownMacros", "", "project", "Lcom/intellij/openapi/project/Project;", "notify", "", "showDialog", "unknownMacros", "", "substitutorToStore", "", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "collect", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "", "doNotify", "macros", "getOrCreateVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestor", "", "file", "Ljava/nio/file/Path;", "platform-impl"})
public final class StorageUtilKt {
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Load Error";
    @Nullable
    private static String DEBUG_LOG;

    @NotNull
    public static final String getNOTIFICATION_GROUP_ID() {
        return NOTIFICATION_GROUP_ID;
    }

    @Nullable
    public static final String getDEBUG_LOG() {
        return DEBUG_LOG;
    }

    public static final void setDEBUG_LOG(@Nullable String string) {
        DEBUG_LOG = string;
    }

    public static final void doNotify(@NotNull Set<String> macros, @NotNull Project project, @NotNull Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> substitutorToStore) {
        Intrinsics.checkParameterIsNotNull(macros, (String)"macros");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(substitutorToStore, (String)"substitutorToStore");
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String content = "<p><i>" + CollectionsKt.joinToString$default((Iterable)macros, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "</i> " + (macros.size() == 1 ? "is" : "are") + " undefined. <a href=\"define\">Fix it</a></p>" + "<br>Path variables are used to substitute absolute paths in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
        new UnknownMacroNotification(NOTIFICATION_GROUP_ID, "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(project, macros, substitutorToStore){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $macros;
            final /* synthetic */ Map $substitutorToStore;

            public final void hyperlinkUpdate(@NotNull Notification $noName_0, @NotNull HyperlinkEvent $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                StorageUtilKt.access$checkUnknownMacros(this.$project, true, this.$macros, this.$substitutorToStore);
            }
            {
                this.$project = project;
                this.$macros = set2;
                this.$substitutorToStore = map;
            }
        }, (Collection<String>)macros).notify(project);
    }

    public static final void checkUnknownMacros(@NotNull Project project, boolean notify) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LinkedHashSet unknownMacros = new LinkedHashSet();
        LinkedHashMap substitutorToStore = new LinkedHashMap();
        StorageUtilKt.collect((ComponentManager)project, unknownMacros, substitutorToStore);
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            StorageUtilKt.collect((ComponentManager)module2, unknownMacros, substitutorToStore);
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        if (notify) {
            StorageUtilKt.doNotify(unknownMacros, project, substitutorToStore);
            return;
        }
        StorageUtilKt.checkUnknownMacros(project, false, unknownMacros, substitutorToStore);
    }

    private static final void checkUnknownMacros(Project project, boolean showDialog, Set<String> unknownMacros, Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> substitutorToStore) {
        if (unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(project, (Set)new THashSet((Collection)unknownMacros))) {
            return;
        }
        PathMacros pathMacros = PathMacros.getInstance();
        CollectionsKt.removeAll((Iterable)unknownMacros, (Function1)((Function1)new Function1<String, Boolean>(pathMacros){
            final /* synthetic */ PathMacros $pathMacros;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CharSequence charSequence = this.$pathMacros.getValue(it);
                return (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !this.$pathMacros.isIgnoredMacroName(it);
            }
            {
                this.$pathMacros = pathMacros;
                super(1);
            }
        }));
        if (unknownMacros.isEmpty()) {
            return;
        }
        NotificationsManager notificationManager2 = NotificationsManager.getNotificationsManager();
        Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> map = substitutorToStore;
        Iterator<Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<String> components;
            Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore> entry;
            Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore> entry2 = entry = iterator.next();
            TrackingPathMacroSubstitutor substitutor = entry2.getKey();
            entry2 = entry;
            IComponentStore store = entry2.getValue();
            if (store.isReloadPossible(components = substitutor.getComponents((Collection<String>)unknownMacros))) {
                substitutor.invalidateUnknownMacros(unknownMacros);
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])notificationManager2.getNotificationsOfType(UnknownMacroNotification.class, project)) {
                    Collection<String> collection = notification.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"notification.macros");
                    if (!unknownMacros.containsAll(collection)) continue;
                    notification.expire();
                }
                store.reloadStates(components, project.getMessageBus());
                continue;
            }
            if (Messages.showYesNoDialog((Project)project, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) != 0) continue;
            ProjectManagerEx.getInstanceEx().reloadProject(project);
        }
    }

    private static final void collect(ComponentManager componentManager, Set<String> unknownMacros, Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        IComponentStore store = ServiceKt.getStateStore(componentManager);
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set<String> macros = substitutor.getUnknownMacros(null);
        if (macros.isEmpty()) {
            return;
        }
        Set<String> set2 = macros;
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"macros");
        unknownMacros.addAll((Collection<String>)set2);
        substitutorToStore.put(substitutor, store);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final VirtualFile getOrCreateVirtualFile(@Nullable Object requestor, @NotNull Path file2) {
        void result$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)file2));
        if (virtualFile != null) {
            return virtualFile;
        }
        Path absoluteFile = file2.toAbsolutePath();
        Path parentFile = absoluteFile.getParent();
        PathKt.createDirectories((Path)parentFile);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)parentFile));
        if (virtualFile2 == null) {
            throw (Throwable)new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        VirtualFile parentVirtualFile = virtualFile2;
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            VirtualFile virtualFile3 = parentVirtualFile.createChildData(requestor, ((Object)file2.getFileName()).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"parentVirtualFile.create\u2026file.fileName.toString())");
            return virtualFile3;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, parentVirtualFile, requestor, file2){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ VirtualFile $parentVirtualFile$inlined;
            final /* synthetic */ Object $requestor$inlined;
            final /* synthetic */ Path $file$inlined;
            {
                this.$result = objectRef;
                this.$parentVirtualFile$inlined = virtualFile;
                this.$requestor$inlined = object;
                this.$file$inlined = path;
            }

            public final void run() {
                this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ getOrCreateVirtualFile$$inlined$runUndoTransparentWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        VirtualFile virtualFile = this.this$0.$parentVirtualFile$inlined.createChildData(this.this$0.$requestor$inlined, ((Object)this.this$0.$file$inlined.getFileName()).toString());
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"parentVirtualFile.create\u2026file.fileName.toString())");
                        return (T)virtualFile;
                    }
                });
            }
        });
        Object object = result$iv.element;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runUndoTransparentWriteA\u2026le.fileName.toString()) }");
        return (VirtualFile)object;
    }

    static {
        NOTIFICATION_GROUP_ID = NOTIFICATION_GROUP_ID;
    }

    public static final /* synthetic */ void access$checkUnknownMacros(@NotNull Project project, boolean showDialog, @NotNull Set unknownMacros, @NotNull Map substitutorToStore) {
        StorageUtilKt.checkUnknownMacros(project, showDialog, unknownMacros, substitutorToStore);
    }
}

