/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataStateChanged;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StorageBaseEx;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.JdomKt;
import gnu.trove.THashMap;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B=\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aH\u0014J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002H$J*\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00022\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0004H\u0014J\b\u0010'\u001a\u00020\u0002H\u0014J\u0014\u0010(\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010)\u001a\u00020%H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u001aH$J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u001a\u0010,\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010-\u001a\u00020.H\u0014J\u000e\u0010/\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aJ\u001a\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00022\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0002J\n\u00103\u001a\u0004\u0018\u00010\u001fH\u0016J$\u00104\u001a\u00020\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u00106\u001a\u00020%2\u0006\u0010)\u001a\u00020%J\u001c\u00107\u001a\u00020\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u00106\u001a\u00020%R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u00069"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/StorageBaseEx;", "Lcom/intellij/configurationStore/StateMap;", "fileSpec", "", "rootElementName", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "getFileSpec", "()Ljava/lang/String;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "getRootElementName", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "archiveState", "storageData", "componentName", "serializedState", "Lorg/jdom/Element;", "beforeElementLoaded", "element", "beforeElementSaved", "createSaveSession", "Lcom/intellij/openapi/components/StateStorage$ExternalizationSession;", "states", "getSerializedState", "component", "", "archive", "", "hasState", "loadData", "loadElement", "useStreamProvider", "loadLocalData", "loadState", "providerDataStateChanged", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "setDefaultState", "setStates", "oldStorageData", "newStorageData", "startExternalization", "updatedFrom", "changedComponentNames", "deleted", "updatedFromStreamProvider", "XmlElementStorageSaveSession", "configuration-store-impl"})
public abstract class XmlElementStorage
extends StorageBaseEx<StateMap> {
    @NotNull
    private final RoamingType roamingType;
    @NotNull
    private final String fileSpec;
    @Nullable
    private final String rootElementName;
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;
    private final StreamProvider provider;

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    public final Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.getState(componentName, archive);
    }

    @Override
    public void archiveState(@NotNull StateMap storageData, @NotNull String componentName, @Nullable Element serializedState) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        storageData.archive(componentName, serializedState);
    }

    @Override
    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasState(componentName);
    }

    @Override
    @NotNull
    protected StateMap loadData() {
        Element element;
        Element it;
        Object object = XmlElementStorage.loadElement$default(this, false, 1, null);
        if (object == null || (object = this.loadState(it = (element = object))) == null) {
            object = StateMap.Companion.getEMPTY();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Element loadElement(boolean useStreamProvider) {
        void element;
        block5: {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            try {
                if (useStreamProvider) {
                    StreamProvider streamProvider = this.provider;
                    if (streamProvider != null && streamProvider.read(this.fileSpec, this.roamingType, (Function1)new Function1<InputStream, Unit>(this, (Ref.ObjectRef)element){
                        final /* synthetic */ XmlElementStorage this$0;
                        final /* synthetic */ Ref.ObjectRef $element;

                        public final void invoke(@Nullable InputStream it) {
                            block0: {
                                InputStream inputStream;
                                InputStream inputStream2 = it;
                                if (inputStream2 == null) break block0;
                                InputStream it2 = inputStream = inputStream2;
                                this.$element.element = JdomKt.loadElement((InputStream)it2);
                                this.this$0.providerDataStateChanged((Element)this.$element.element, DataStateChanged.LOADED);
                            }
                        }
                        {
                            this.this$0 = xmlElementStorage;
                            this.$element = objectRef;
                            super(1);
                        }
                    })) break block5;
                }
                element.element = this.loadLocalData();
            }
            catch (FileNotFoundException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error(e);
            }
        }
        return (Element)element.element;
    }

    static /* bridge */ /* synthetic */ Element loadElement$default(XmlElementStorage xmlElementStorage, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadElement");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return xmlElementStorage.loadElement(bl);
    }

    protected void providerDataStateChanged(@Nullable Element element, @NotNull DataStateChanged type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
    }

    private final StateMap loadState(Element element) {
        this.beforeElementLoaded(element);
        Map<String, Element> map = FileStorageCoreUtil.load(element, this.pathMacroSubstitutor);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"FileStorageCoreUtil.load\u2026nt, pathMacroSubstitutor)");
        return StateMap.Companion.fromMap(map);
    }

    public final void setDefaultState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = this.rootElementName;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        element.setName(string);
        this.getStorageDataRef().set(this.loadState(element));
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? null : this.createSaveSession((StateMap)StateStorageBase.getStorageData$default(this, false, 1, null));
    }

    @NotNull
    protected abstract StateStorage.ExternalizationSession createSaveSession(@NotNull StateMap var1);

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap oldData = (StateMap)this.getStorageDataRef().get();
        StateMap newData = (StateMap)this.getStorageData(true);
        if (oldData == null) {
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString();
                logger.debug(string, (Throwable)e$iv);
            }
            CollectionsKt.addAll((Collection)componentNames, (Object[])newData.keys());
        } else {
            Set changedComponentNames = XmlElementStorageKt.access$getChangedComponentNames(oldData, newData);
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "analyzeExternalChangesAndUpdateIfNeed: changedComponentNames " + changedComponentNames + " for " + this.toString();
                logger.debug(string, (Throwable)e$iv);
            }
            Collection collection = changedComponentNames;
            if (!collection.isEmpty()) {
                componentNames.addAll(changedComponentNames);
            }
        }
    }

    private final void setStates(StateMap oldStorageData, StateMap newStorageData) {
        if (oldStorageData != newStorageData && this.getStorageDataRef().getAndSet(newStorageData) != oldStorageData) {
            ComponentStoreImplKt.getLOG().warn("Old storage data is not equal to current, new storage data was set anyway");
        }
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeElementSaved(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.pathMacroSubstitutor;
        if (trackingPathMacroSubstitutor != null) {
            TrackingPathMacroSubstitutor trackingPathMacroSubstitutor2;
            TrackingPathMacroSubstitutor it = trackingPathMacroSubstitutor2 = trackingPathMacroSubstitutor;
            try {
                it.collapsePaths(element);
            }
            finally {
                it.reset();
            }
        }
    }

    public final void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        Intrinsics.checkParameterIsNotNull(changedComponentNames, (String)"changedComponentNames");
        this.updatedFrom(changedComponentNames, deleted, true);
    }

    public final void updatedFrom(@NotNull Set<String> changedComponentNames, boolean deleted, boolean useStreamProvider) {
        Intrinsics.checkParameterIsNotNull(changedComponentNames, (String)"changedComponentNames");
        if (Intrinsics.areEqual((Object)this.roamingType, (Object)RoamingType.DISABLED)) {
            return;
        }
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        try {
            Element newElement = deleted ? null : this.loadElement(useStreamProvider);
            StateMap states = (StateMap)this.getStorageDataRef().get();
            if (newElement == null) {
                if (states != null) {
                    CollectionsKt.addAll((Collection)changedComponentNames, (Object[])states.keys());
                    this.setStates(states, null);
                }
            } else if (states != null) {
                StateMap newStates = this.loadState(newElement);
                changedComponentNames.addAll(XmlElementStorageKt.access$getChangedComponentNames(states, newStates));
                this.setStates(states, newStates);
            }
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
    }

    @NotNull
    public final String getFileSpec() {
        return this.fileSpec;
    }

    @Nullable
    protected final String getRootElementName() {
        return this.rootElementName;
    }

    protected XmlElementStorage(@NotNull String fileSpec, @Nullable String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        this.fileSpec = fileSpec;
        this.rootElementName = rootElementName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        this.provider = provider;
        RoamingType roamingType2 = roamingType;
        if (roamingType2 == null) {
            roamingType2 = RoamingType.DEFAULT;
        }
        this.roamingType = roamingType2;
    }

    public /* synthetic */ XmlElementStorage(String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 8) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            streamProvider = null;
        }
        this(string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH$J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0014R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "T", "Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/SaveSessionBase;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/XmlElementStorage;)V", "copiedStates", "", "", "", "newLiveStates", "Lgnu/trove/THashMap;", "Lorg/jdom/Element;", "getStorage", "()Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "createSaveSession", "save", "", "saveLocally", "element", "setSerializedState", "componentName", "configuration-store-impl"})
    public static abstract class XmlElementStorageSaveSession<T extends XmlElementStorage>
    extends SaveSessionBase {
        private Map<String, Object> copiedStates;
        private final THashMap<String, Element> newLiveStates;
        private final StateMap originalStates;
        @NotNull
        private final T storage;

        @Nullable
        public XmlElementStorageSaveSession<T> createSaveSession() {
            return this.copiedStates == null || ((StateStorageBase)this.storage).checkIsSavingDisabled() ? null : this;
        }

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            Element normalized;
            Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
            Element element2 = element;
            Object object = normalized = element2 != null ? XmlElementStorageKt.normalizeRootName(element2) : null;
            if (this.copiedStates == null) {
                this.copiedStates = StateMapKt.setStateAndCloneIfNeed(componentName, normalized, this.originalStates, (Map)this.newLiveStates);
            } else {
                Map<String, Object> map = this.copiedStates;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                StateMapKt.updateState(map, componentName, normalized, (Map)this.newLiveStates);
            }
        }

        public void save() {
            StateMap stateMap;
            Element element;
            Map<String, Object> map = this.copiedStates;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            if ((element = XmlElementStorageKt.access$save(stateMap = StateMap.Companion.fromMap(map), ((XmlElementStorage)this.storage).getRootElementName(), (Map)this.newLiveStates)) != null) {
                ((XmlElementStorage)this.storage).beforeElementSaved(element);
            }
            boolean isSavedLocally = false;
            StreamProvider provider = ((XmlElementStorage)this.storage).provider;
            if (element == null) {
                if (provider == null || !provider.delete(((XmlElementStorage)this.storage).getFileSpec(), ((XmlElementStorage)this.storage).getRoamingType())) {
                    isSavedLocally = true;
                    this.saveLocally(null);
                }
            } else if (provider != null && provider.isApplicable(((XmlElementStorage)this.storage).getFileSpec(), ((XmlElementStorage)this.storage).getRoamingType())) {
                provider.write(((XmlElementStorage)this.storage).getFileSpec(), JdomKt.toBufferExposingByteArray$default((Parent)((Parent)element), null, (int)1, null), ((XmlElementStorage)this.storage).getRoamingType());
            } else {
                isSavedLocally = true;
                this.saveLocally(element);
            }
            if (!isSavedLocally) {
                ((XmlElementStorage)this.storage).providerDataStateChanged(element, DataStateChanged.SAVED);
            }
            ((XmlElementStorage)this.storage).setStates(this.originalStates, stateMap);
        }

        protected abstract void saveLocally(@Nullable Element var1);

        @NotNull
        protected final T getStorage() {
            return this.storage;
        }

        public XmlElementStorageSaveSession(@NotNull StateMap originalStates, @NotNull T storage2) {
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            Intrinsics.checkParameterIsNotNull(storage2, (String)"storage");
            this.originalStates = originalStates;
            this.storage = storage2;
            this.newLiveStates = new THashMap();
        }
    }
}

