/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.SimpleLineStatusTracker;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeViewer
implements MergeTool.MergeViewer {
    private static final Logger LOG = Logger.getInstance(TextMergeViewer.class);
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final TextMergeRequest myMergeRequest;
    @NotNull
    private final MyThreesideViewer myViewer;

    public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request) {
        if (context == null) {
            TextMergeViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TextMergeViewer.$$$reportNull$$$0(1);
        }
        this.myMergeContext = context;
        this.myMergeRequest = request;
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
        SimpleDiffRequest diffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest));
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
        this.myViewer = new MyThreesideViewer(diffContext, (ContentDiffRequest)diffRequest);
    }

    @NotNull
    private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(2);
        }
        List contents = mergeRequest.getContents();
        DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
        DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
        DocumentContent output = mergeRequest.getOutputContent();
        List list2 = ContainerUtil.list((Object[])new DiffContent[]{left, output, right});
        if (list2 == null) {
            TextMergeViewer.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(4);
        }
        List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        titles.set(ThreeSide.BASE.getIndex(), DiffBundle.message((String)"merge.version.title.merged.result", (Object[])new Object[0]));
        List<String> list2 = titles;
        if (list2 == null) {
            TextMergeViewer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            TextMergeViewer.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents init = this.myViewer.init();
        components.statusPanel = init.statusPanel;
        components.toolbarActions = init.toolbarActions;
        components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext);
        MergeTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            TextMergeViewer.$$$reportNull$$$0(7);
        }
        return toolbarComponents;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result2) {
        if (result2 == null) {
            TextMergeViewer.$$$reportNull$$$0(8);
        }
        return this.myViewer.getResolveAction(result2);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public MyThreesideViewer getViewer() {
        MyThreesideViewer myThreesideViewer = this.myViewer;
        if (myThreesideViewer == null) {
            TextMergeViewer.$$$reportNull$$$0(9);
        }
        return myThreesideViewer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeRequest";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffContents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffContentTitles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDiffContents";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiffContentTitles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResolveAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InnerChunkData {
        @NotNull
        public final List<CharSequence> text;

        public InnerChunkData(@NotNull TextMergeChange change, @NotNull List<Document> documents) {
            if (change == null) {
                InnerChunkData.$$$reportNull$$$0(0);
            }
            if (documents == null) {
                InnerChunkData.$$$reportNull$$$0(1);
            }
            this.text = InnerChunkData.getChunks(change, documents);
        }

        @NotNull
        private static List<CharSequence> getChunks(@NotNull TextMergeChange change, @NotNull List<Document> documents) {
            if (change == null) {
                InnerChunkData.$$$reportNull$$$0(2);
            }
            if (documents == null) {
                InnerChunkData.$$$reportNull$$$0(3);
            }
            List list2 = ThreeSide.map(side -> {
                int endLine;
                if (change == null) {
                    InnerChunkData.$$$reportNull$$$0(5);
                }
                if (documents == null) {
                    InnerChunkData.$$$reportNull$$$0(6);
                }
                if (!change.isChange((ThreeSide)side) || change.isResolved((ThreeSide)side)) {
                    return null;
                }
                int startLine = change.getStartLine((ThreeSide)side);
                if (startLine == (endLine = change.getEndLine((ThreeSide)side))) {
                    return null;
                }
                return DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine);
            });
            if (list2 == null) {
                InnerChunkData.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documents";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$InnerChunkData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$InnerChunkData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChunks";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getChunks$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MyThreesideViewer
    extends ThreesideTextDiffViewerEx {
        @NotNull
        private final MergeModelBase myModel;
        @NotNull
        private final ModifierProvider myModifierProvider;
        @NotNull
        private final MyInnerDiffWorker myInnerDiffWorker;
        @NotNull
        private final SimpleLineStatusTracker myLineStatusTracker;
        @NotNull
        private final TextDiffProviderBase myTextDiffProvider;
        @NotNull
        private final List<TextMergeChange> myAllMergeChanges;
        private boolean myInitialRediffStarted;
        private boolean myInitialRediffFinished;
        private boolean myContentModified;

        public MyThreesideViewer(@NotNull DiffContext context, ContentDiffRequest request) {
            if (context == null) {
                MyThreesideViewer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyThreesideViewer.$$$reportNull$$$0(1);
            }
            super(context, request);
            this.myAllMergeChanges = new ArrayList<TextMergeChange>();
            this.myModel = new MyMergeModel(this.getProject(), this.getEditor().getDocument());
            this.myModifierProvider = new ModifierProvider();
            this.myInnerDiffWorker = new MyInnerDiffWorker();
            this.myLineStatusTracker = new SimpleLineStatusTracker(this.getProject(), this.getEditor().getDocument(), (Function1<? super SimpleLineStatusTracker, ? extends LineStatusMarkerRenderer>)((Function1)x$0 -> new MyLineStatusMarkerRenderer((LineStatusTrackerBase)x$0)));
            this.myTextDiffProvider = new TextDiffProviderBase(this.getTextSettings(), this.myInnerDiffWorker::onSettingsChanged, (Disposable)this, (IgnorePolicy[])ContainerUtil.ar((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT}), (HighlightPolicy[])ContainerUtil.ar((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD}));
            DiffUtil.registerAction(new ApplySelectedChangesAction(Side.LEFT, true), this.myPanel);
            DiffUtil.registerAction(new ApplySelectedChangesAction(Side.RIGHT, true), this.myPanel);
            DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.LEFT, true), this.myPanel);
            DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.RIGHT, true), this.myPanel);
            DiffUtil.registerAction(new ResolveSelectedConflictsAction(true), this.myPanel);
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(false), this.myPanel);
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(true), this.myPanel);
            ProxyUndoRedoAction.register(this.getProject(), this.getEditor(), this.myContentPanel);
        }

        @Override
        protected void onInit() {
            super.onInit();
            this.myModifierProvider.init();
        }

        @Override
        protected void onDispose() {
            Disposer.dispose((Disposable)this.myModel);
            this.myLineStatusTracker.release();
            super.onDispose();
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            group.add((AnAction)this.myEditorSettingsAction);
            DefaultActionGroup diffGroup = new DefaultActionGroup("Compare With", true);
            diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.RIGHT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, true));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.LEFT));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.BASE));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.RIGHT));
            group.add((AnAction)diffGroup);
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.BASE));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.LEFT));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.RIGHT));
            group.add((AnAction)new MagicResolvedConflictsAction());
            ArrayList<AnAction> arrayList = group;
            if (arrayList == null) {
                MyThreesideViewer.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected List<AnAction> createEditorPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            group.add(new ApplySelectedChangesAction(Side.LEFT, false));
            group.add(new ApplySelectedChangesAction(Side.RIGHT, false));
            group.add(new ResolveSelectedChangesAction(Side.LEFT));
            group.add(new ResolveSelectedChangesAction(Side.RIGHT));
            group.add(new IgnoreSelectedChangesSideAction(Side.LEFT, false));
            group.add(new IgnoreSelectedChangesSideAction(Side.RIGHT, false));
            group.add(new ResolveSelectedConflictsAction(false));
            group.add(new IgnoreSelectedChangesAction());
            group.add((AnAction)Separator.getInstance());
            group.addAll(TextDiffViewerUtil.createEditorPopupActions());
            ArrayList<AnAction> arrayList = group;
            if (arrayList == null) {
                MyThreesideViewer.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Override
        @Nullable
        protected List<AnAction> createPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            return group;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            if (result2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(4);
            }
            String caption = MergeUtil.getResolveActionTitle(result2, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((result2 == MergeResult.LEFT || result2 == MergeResult.RIGHT) && MyThreesideViewer.this.myContentModified && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.message", (Object[])new Object[]{result2 == MergeResult.LEFT ? 0 : 1}), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.RESOLVED && (MyThreesideViewer.this.getChangesCount() > 0 || MyThreesideViewer.this.getConflictsCount() > 0) && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MyThreesideViewer.this.getChangesCount(), MyThreesideViewer.this.getConflictsCount()}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.CANCEL && MyThreesideViewer.this.myContentModified && !MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext)) {
                        return;
                    }
                    MyThreesideViewer.this.destroyChangedBlocks();
                    TextMergeViewer.this.myMergeContext.finishMerge(result2);
                }
            };
        }

        private boolean setInitialOutputContent() {
            Document baseDocument = ((DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents())).getDocument();
            Document outputDocument = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument();
            return DiffUtil.executeWriteCommand(outputDocument, this.getProject(), "Init merge content", () -> {
                outputDocument.setText(baseDocument.getCharsSequence());
                DiffUtil.putNonundoableOperation(this.getProject(), outputDocument);
                if (this.getTextSettings().isEnableLstGutterMarkersInMerge()) {
                    this.myLineStatusTracker.setBaseRevision(baseDocument.getCharsSequence());
                    this.getEditor().getGutterComponentEx().setForceShowRightFreePaintersArea(true);
                }
            });
        }

        @Override
        public void rediff(boolean trySync) {
            if (this.myInitialRediffStarted) {
                return;
            }
            this.myInitialRediffStarted = true;
            assert (this.myAllMergeChanges.isEmpty());
            this.doRediff();
        }

        @Override
        @NotNull
        protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyThreesideViewer.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException();
        }

        private void doRediff() {
            this.myStatusPanel.setBusy(true);
            this.getEditor().setViewer(true);
            ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), "Computing Differences...", true){
                private Runnable myCallback;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.myCallback = MyThreesideViewer.this.doPerformRediff(indicator);
                }

                public void onCancel() {
                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    LOG.error(error);
                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }

                public void onSuccess() {
                    if (MyThreesideViewer.this.isDisposed()) {
                        return;
                    }
                    this.myCallback.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }));
        }

        @NotNull
        protected Runnable doPerformRediff(@NotNull ProgressIndicator indicator) {
            Runnable runnable2;
            if (indicator == null) {
                MyThreesideViewer.$$$reportNull$$$0(6);
            }
            try {
                indicator.checkCanceled();
                List contents = TextMergeViewer.this.myMergeRequest.getContents();
                List sequences = (List)ReadAction.compute(() -> {
                    if (indicator == null) {
                        MyThreesideViewer.$$$reportNull$$$0(43);
                    }
                    indicator.checkCanceled();
                    return ContainerUtil.map((Collection)contents, content -> content.getDocument().getImmutableCharSequence());
                });
                List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsetsUtil::create);
                ComparisonManager manager = ComparisonManager.getInstance();
                List lineFragments = manager.compareLines((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), ComparisonPolicy.DEFAULT, indicator);
                List conflictTypes = ContainerUtil.map((Collection)lineFragments, fragment -> DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, ComparisonPolicy.DEFAULT));
                runnable2 = this.apply(lineFragments, conflictTypes);
            }
            catch (DiffTooBigException e) {
                Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
                if (runnable3 == null) {
                    MyThreesideViewer.$$$reportNull$$$0(8);
                }
                return runnable3;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                Runnable runnable4 = () -> {
                    this.clearDiffPresentation();
                    this.myPanel.setErrorContent();
                };
                if (runnable4 == null) {
                    MyThreesideViewer.$$$reportNull$$$0(9);
                }
                return runnable4;
            }
            if (runnable2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(7);
            }
            return runnable2;
        }

        @NotNull
        private Runnable apply(@NotNull List<MergeLineFragment> fragments, @NotNull List<MergeConflictType> conflictTypes) {
            if (fragments == null) {
                MyThreesideViewer.$$$reportNull$$$0(10);
            }
            if (conflictTypes == null) {
                MyThreesideViewer.$$$reportNull$$$0(11);
            }
            Runnable runnable2 = () -> {
                if (fragments == null) {
                    MyThreesideViewer.$$$reportNull$$$0(41);
                }
                if (conflictTypes == null) {
                    MyThreesideViewer.$$$reportNull$$$0(42);
                }
                this.clearDiffPresentation();
                boolean success2 = this.setInitialOutputContent();
                if (!success2) {
                    this.myPanel.addNotification(DiffNotifications.createNotification("Can't resolve conflicts in a read-only file"));
                    return;
                }
                this.myModel.setChanges(ContainerUtil.map((Collection)fragments, f -> new LineRange(f.getStartLine(ThreeSide.BASE), f.getEndLine(ThreeSide.BASE))));
                this.resetChangeCounters();
                for (int index = 0; index < fragments.size(); ++index) {
                    MergeLineFragment fragment = (MergeLineFragment)fragments.get(index);
                    MergeConflictType conflictType = (MergeConflictType)conflictTypes.get(index);
                    TextMergeChange change = new TextMergeChange(index, fragment, conflictType, TextMergeViewer.this);
                    this.myAllMergeChanges.add(change);
                    this.onChangeAdded(change);
                }
                this.myInitialScrollHelper.onRediff();
                this.myContentPanel.repaintDividers();
                this.myStatusPanel.update();
                this.getEditor().setViewer(false);
                this.myInnerDiffWorker.onSettingsChanged();
                this.myInitialRediffFinished = true;
                if (TextMergeViewer.this.myViewer.getTextSettings().isAutoApplyNonConflictedChanges() && this.hasNonConflictedChanges(ThreeSide.BASE)) {
                    this.applyNonConflictedChanges(ThreeSide.BASE);
                }
            };
            if (runnable2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(12);
            }
            return runnable2;
        }

        @Override
        protected void destroyChangedBlocks() {
            super.destroyChangedBlocks();
            this.myInnerDiffWorker.stop();
            for (TextMergeChange change : this.myAllMergeChanges) {
                change.destroy();
            }
            this.myAllMergeChanges.clear();
            this.myModel.setChanges(Collections.emptyList());
        }

        @Override
        protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyThreesideViewer.$$$reportNull$$$0(13);
            }
            super.onBeforeDocumentChange(e);
            if (this.myInitialRediffFinished) {
                this.myContentModified = true;
            }
        }

        public void repaintDividers() {
            this.myContentPanel.repaintDividers();
        }

        private void onChangeResolved(@NotNull TextMergeChange change) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(14);
            }
            if (change.isResolved()) {
                this.onChangeRemoved(change);
            } else {
                this.onChangeAdded(change);
            }
            if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
                LOG.assertTrue(ContainerUtil.and(this.getAllChanges(), TextMergeChange::isResolved));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component = this.getEditor().getComponent();
                    RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() / 2, JBUI.scale((int)5)));
                    String message = DiffBundle.message((String)"merge.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup(message, point, (Disposable)this, () -> {
                        if (this.isDisposed()) {
                            return;
                        }
                        this.destroyChangedBlocks();
                        TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }

        @NotNull
        public MergeModelBase getModel() {
            MergeModelBase mergeModelBase = this.myModel;
            if (mergeModelBase == null) {
                MyThreesideViewer.$$$reportNull$$$0(15);
            }
            return mergeModelBase;
        }

        @NotNull
        public List<TextMergeChange> getAllChanges() {
            List<TextMergeChange> list2 = this.myAllMergeChanges;
            if (list2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(16);
            }
            return list2;
        }

        @NotNull
        public List<TextMergeChange> getChanges() {
            List list2 = ContainerUtil.filter(this.myAllMergeChanges, mergeChange -> !mergeChange.isResolved());
            if (list2 == null) {
                MyThreesideViewer.$$$reportNull$$$0(17);
            }
            return list2;
        }

        @Override
        @NotNull
        protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(18);
            }
            MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
            if (myDividerPaintable == null) {
                MyThreesideViewer.$$$reportNull$$$0(19);
            }
            return myDividerPaintable;
        }

        @NotNull
        public ModifierProvider getModifierProvider() {
            ModifierProvider modifierProvider = this.myModifierProvider;
            if (modifierProvider == null) {
                MyThreesideViewer.$$$reportNull$$$0(20);
            }
            return modifierProvider;
        }

        @NotNull
        public EditorEx getEditor() {
            EditorEx editorEx = this.getEditor(ThreeSide.BASE);
            if (editorEx == null) {
                MyThreesideViewer.$$$reportNull$$$0(21);
            }
            return editorEx;
        }

        public boolean executeMergeCommand(@Nullable String commandName, boolean underBulkUpdate, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
            if (task == null) {
                MyThreesideViewer.$$$reportNull$$$0(22);
            }
            this.myContentModified = true;
            TIntArrayList affectedIndexes = null;
            if (affected != null) {
                affectedIndexes = new TIntArrayList(affected.size());
                for (TextMergeChange change : affected) {
                    affectedIndexes.add(change.getIndex());
                }
            }
            return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, affectedIndexes, task);
        }

        public boolean executeMergeCommand(@Nullable String commandName, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
            if (task == null) {
                MyThreesideViewer.$$$reportNull$$$0(23);
            }
            return this.executeMergeCommand(commandName, false, affected, task);
        }

        public void markChangeResolved(@NotNull TextMergeChange change) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(24);
            }
            if (change.isResolved()) {
                return;
            }
            change.setResolved(Side.LEFT, true);
            change.setResolved(Side.RIGHT, true);
            this.onChangeResolved(change);
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void markChangeResolved(@NotNull TextMergeChange change, @NotNull Side side) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(25);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(26);
            }
            if (change.isResolved(side)) {
                return;
            }
            change.setResolved(side, true);
            if (change.isResolved()) {
                this.onChangeResolved(change);
            }
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void ignoreChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(27);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(28);
            }
            if (!change.isConflict() || resolveChange) {
                this.markChangeResolved(change);
            } else {
                this.markChangeResolved(change, side);
            }
        }

        public void replaceChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(29);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(30);
            }
            if (change.isResolved(side)) {
                return;
            }
            if (!change.isChange(side)) {
                this.markChangeResolved(change);
                return;
            }
            ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
            Document sourceDocument = this.getContent(sourceSide).getDocument();
            int sourceStartLine = change.getStartLine(sourceSide);
            int sourceEndLine = change.getEndLine(sourceSide);
            List<String> newContent = DiffUtil.getLines(sourceDocument, sourceStartLine, sourceEndLine);
            if (change.isConflict()) {
                boolean append = change.isOnesideAppliedConflict();
                if (append) {
                    this.myModel.appendChange(change.getIndex(), newContent);
                } else {
                    this.myModel.replaceChange(change.getIndex(), newContent);
                }
                if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                    this.markChangeResolved(change);
                } else {
                    change.markOnesideAppliedConflict();
                    this.markChangeResolved(change, side);
                }
            } else {
                this.myModel.replaceChange(change.getIndex(), newContent);
                this.markChangeResolved(change);
            }
        }

        private boolean hasNonConflictedChanges(@NotNull ThreeSide side) {
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(31);
            }
            return ContainerUtil.exists(this.getAllChanges(), change -> {
                if (side == null) {
                    MyThreesideViewer.$$$reportNull$$$0(40);
                }
                return !change.isConflict() && this.canResolveChangeAutomatically((TextMergeChange)change, side);
            });
        }

        private void applyNonConflictedChanges(@NotNull ThreeSide side) {
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(32);
            }
            this.executeMergeCommand("Apply Non Conflicted Changes", true, null, () -> {
                if (side == null) {
                    MyThreesideViewer.$$$reportNull$$$0(39);
                }
                ArrayList allChanges = ContainerUtil.newArrayList(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    if (change.isConflict()) continue;
                    this.resolveChangeAutomatically(change, side);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        private boolean hasResolvableConflictedChanges() {
            return ContainerUtil.exists(this.getAllChanges(), change -> this.canResolveChangeAutomatically((TextMergeChange)change, ThreeSide.BASE));
        }

        private void applyResolvableConflictedChanges() {
            this.executeMergeCommand("Resolve Simple Conflicted Changes", true, null, () -> {
                ArrayList allChanges = ContainerUtil.newArrayList(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        public boolean canResolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(33);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(34);
            }
            if (change.isConflict()) {
                return side == ThreeSide.BASE && change.getType().canBeResolved() && !change.isResolved(Side.LEFT) && !change.isResolved(Side.RIGHT) && !this.isChangeRangeModified(change);
            }
            return !change.isResolved() && change.isChange(side) && !this.isChangeRangeModified(change);
        }

        private boolean isChangeRangeModified(@NotNull TextMergeChange change) {
            CharSequence resultContent;
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(35);
            }
            MergeLineFragment changeFragment = change.getFragment();
            int baseStartLine = changeFragment.getStartLine(ThreeSide.BASE);
            int baseEndLine = changeFragment.getEndLine(ThreeSide.BASE);
            DiffContent baseDiffContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
            Document baseDocument = ((DocumentContent)baseDiffContent).getDocument();
            int resultStartLine = change.getStartLine();
            int resultEndLine = change.getEndLine();
            DocumentEx resultDocument = this.getEditor().getDocument();
            CharSequence baseContent = DiffUtil.getLinesContent(baseDocument, baseStartLine, baseEndLine);
            return !StringUtil.equals((CharSequence)baseContent, (CharSequence)(resultContent = DiffUtil.getLinesContent(resultDocument, resultStartLine, resultEndLine)));
        }

        public void resolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (change == null) {
                MyThreesideViewer.$$$reportNull$$$0(36);
            }
            if (side == null) {
                MyThreesideViewer.$$$reportNull$$$0(37);
            }
            if (!this.canResolveChangeAutomatically(change, side)) {
                return;
            }
            if (change.isConflict()) {
                List texts = ThreeSide.map(it -> {
                    if (change == null) {
                        MyThreesideViewer.$$$reportNull$$$0(38);
                    }
                    return DiffUtil.getLinesContent(this.getEditor((ThreeSide)it).getDocument(), change.getStartLine((ThreeSide)it), change.getEndLine((ThreeSide)it));
                });
                CharSequence newContent = ComparisonMergeUtil.tryResolveConflict((CharSequence)texts.get(0), (CharSequence)texts.get(1), (CharSequence)texts.get(2));
                if (newContent == null) {
                    LOG.warn(String.format("Can't resolve conflicting change:\n'%s'\n'%s'\n'%s'\n", texts.get(0), texts.get(1), texts.get(2)));
                    return;
                }
                String[] newContentLines = LineTokenizer.tokenize((CharSequence)newContent, (boolean)false);
                this.myModel.replaceChange(change.getIndex(), Arrays.asList(newContentLines));
                this.markChangeResolved(change);
            } else {
                Side masterSide = (Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT);
                this.replaceChange(change, masterSide, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: 
                case 6: 
                case 43: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 10: 
                case 41: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 11: 
                case 42: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflictTypes";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 14: 
                case 24: 
                case 25: 
                case 27: 
                case 29: 
                case 33: 
                case 35: 
                case 36: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 18: 
                case 26: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 37: 
                case 39: 
                case 40: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditorPopupActions";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doPerformRediff";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllChanges";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDividerPaintable";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifierProvider";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getResolveAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "performRediff";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerformRediff";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "onBeforeDocumentChange";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "onChangeResolved";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getDividerPaintable";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "executeMergeCommand";
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "markChangeResolved";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "ignoreChange";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceChange";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNonConflictedChanges";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "applyNonConflictedChanges";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "canResolveChangeAutomatically";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "isChangeRangeModified";
                    break;
                }
                case 36: 
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveChangeAutomatically";
                    break;
                }
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$resolveChangeAutomatically$18";
                    break;
                }
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyNonConflictedChanges$13";
                    break;
                }
                case 40: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$hasNonConflictedChanges$12";
                    break;
                }
                case 41: 
                case 42: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$apply$8";
                    break;
                }
                case 43: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$doPerformRediff$4";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class NavigateToChangeMarkerAction
        extends DumbAwareAction {
            private final boolean myGoToNext;

            protected NavigateToChangeMarkerAction(boolean goToNext) {
                this.myGoToNext = goToNext;
                ActionUtil.copyFrom((AnAction)this, (String)(this.myGoToNext ? "VcsShowNextChangeMarker" : "VcsShowPrevChangeMarker"));
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.getTextSettings().isEnableLstGutterMarkersInMerge());
            }

            public void actionPerformed(AnActionEvent e) {
                Object targetRange;
                if (!MyThreesideViewer.this.myLineStatusTracker.isValid()) {
                    return;
                }
                int line = MyThreesideViewer.this.getEditor().getCaretModel().getLogicalPosition().line;
                Object r = targetRange = this.myGoToNext ? MyThreesideViewer.this.myLineStatusTracker.getNextRange(line) : MyThreesideViewer.this.myLineStatusTracker.getPrevRange(line);
                if (targetRange != null) {
                    new MyLineStatusMarkerRenderer(MyThreesideViewer.this.myLineStatusTracker).scrollAndShow(MyThreesideViewer.this.getEditor(), (Range)targetRange);
                }
            }
        }

        private class MyLineStatusMarkerRenderer
        extends LineStatusMarkerPopupRenderer {
            public MyLineStatusMarkerRenderer(LineStatusTrackerBase tracker) {
                if (tracker == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(0);
                }
                super(tracker);
            }

            @Override
            @Nullable
            protected MarkupEditorFilter getEditorFilter() {
                return editor -> editor == MyThreesideViewer.this.getEditor();
            }

            @Override
            protected int getFramingBorderSize() {
                return JBUI.scale((int)2);
            }

            @Override
            public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
                if (editor == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(1);
                }
                if (range2 == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(2);
                }
                if (!this.myTracker.isValid()) {
                    return;
                }
                Document document = this.myTracker.getDocument();
                int line = Math.min(range2.getType() == 3 ? range2.getLine2() : range2.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
                int[] startLines = new int[]{((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line, line, ((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line};
                for (ThreeSide side : ThreeSide.values()) {
                    DiffUtil.moveCaret(MyThreesideViewer.this.getEditor(side), side.select(startLines));
                }
                MyThreesideViewer.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                this.showAfterScroll(editor, range2);
            }

            @Override
            @NotNull
            protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
                if (editor == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(3);
                }
                if (range2 == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(4);
                }
                ArrayList<AnAction> actions = new ArrayList<AnAction>();
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction(this, editor, range2, mousePosition));
                ArrayList<AnAction> arrayList = actions;
                if (arrayList == null) {
                    MyLineStatusMarkerRenderer.$$$reportNull$$$0(5);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tracker";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerRenderer";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createToolbarActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "scrollAndShow";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolbarActions";
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        public class ModifierProvider
        extends KeyboardModifierListener {
            public void init() {
                this.init(MyThreesideViewer.this.myPanel, (Disposable)TextMergeViewer.this);
            }

            @Override
            public void onModifiersChanged() {
                for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                    change.updateGutterActions(false);
                }
            }
        }

        private class MyDividerPaintable
        implements DiffDividerDrawUtil.DividerPaintable {
            @NotNull
            private final Side mySide;

            public MyDividerPaintable(Side side) {
                if (side == null) {
                    MyDividerPaintable.$$$reportNull$$$0(0);
                }
                this.mySide = side;
            }

            @Override
            public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
                if (handler2 == null) {
                    MyDividerPaintable.$$$reportNull$$$0(1);
                }
                ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                for (TextMergeChange mergeChange : MyThreesideViewer.this.myAllMergeChanges) {
                    if (!mergeChange.isChange(this.mySide)) continue;
                    Color color = mergeChange.getDiffType().getColor(MyThreesideViewer.this.getEditor());
                    boolean isResolved = mergeChange.isResolved(this.mySide);
                    if (handler2.process(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), color, isResolved)) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyDividerPaintable";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ShowDiffWithBaseAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ShowDiffWithBaseAction(ThreeSide side) {
                if (side == null) {
                    ShowDiffWithBaseAction.$$$reportNull$$$0(0);
                }
                this.mySide = side;
                String actionId = (String)this.mySide.select((Object)"Diff.CompareWithBase.Left", (Object)"Diff.CompareWithBase.Result", (Object)"Diff.CompareWithBase.Right");
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }

            public void actionPerformed(AnActionEvent e) {
                DiffContent baseContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
                String baseTitle = (String)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContentTitles());
                DiffContent otherContent = (DiffContent)this.mySide.select(MyThreesideViewer.this.myRequest.getContents());
                String otherTitle = (String)this.mySide.select(MyThreesideViewer.this.myRequest.getContentTitles());
                SimpleDiffRequest request = new SimpleDiffRequest(MyThreesideViewer.this.myRequest.getTitle(), baseContent, otherContent, baseTitle, otherTitle);
                ThreeSide currentSide = MyThreesideViewer.this.getCurrentSide();
                LogicalPosition currentPosition = DiffUtil.getCaretPosition(MyThreesideViewer.this.getCurrentEditor());
                LogicalPosition resultPosition = MyThreesideViewer.this.transferPosition(currentSide, this.mySide, currentPosition);
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)resultPosition.line));
                DiffManager.getInstance().showDiff(MyThreesideViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)MyThreesideViewer.this.myPanel));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ShowDiffWithBaseAction", "<init>"));
            }
        }

        public class MagicResolvedConflictsAction
        extends DumbAwareAction {
            public MagicResolvedConflictsAction() {
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.MagicResolveConflicts");
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasResolvableConflictedChanges());
            }

            public void actionPerformed(AnActionEvent e) {
                MyThreesideViewer.this.applyResolvableConflictedChanges();
            }
        }

        public class ApplyNonConflictsAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ApplyNonConflictsAction(ThreeSide side) {
                if (side == null) {
                    ApplyNonConflictsAction.$$$reportNull$$$0(0);
                }
                String id = (String)side.select((Object)"Diff.ApplyNonConflicts.Left", (Object)"Diff.ApplyNonConflicts", (Object)"Diff.ApplyNonConflicts.Right");
                ActionUtil.copyFrom((AnAction)this, (String)id);
                this.mySide = side;
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasNonConflictedChanges(this.mySide));
            }

            public void actionPerformed(AnActionEvent e) {
                MyThreesideViewer.this.applyNonConflictedChanges(this.mySide);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplyNonConflictsAction", "<init>"));
            }
        }

        private class ResolveSelectedConflictsAction
        extends ApplySelectedChangesActionBase {
            public ResolveSelectedConflictsAction(boolean shortcut) {
                super(shortcut);
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.ResolveConflict");
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(0);
                }
                return "Resolve Automatically";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(1);
                }
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(2);
                }
                return MyThreesideViewer.this.canResolveChangeAutomatically(change, ThreeSide.BASE);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(3);
                }
                if (changes == null) {
                    ResolveSelectedConflictsAction.$$$reportNull$$$0(4);
                }
                for (int i = changes.size() - 1; i >= 0; --i) {
                    TextMergeChange change = changes.get(i);
                    MyThreesideViewer.this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedConflictsAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ResolveSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            public ResolveSelectedChangesAction(Side side) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(0);
                }
                super(false);
                this.mySide = side;
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(1);
                }
                return (String)this.mySide.select((Object)"Resolve using Left", (Object)"Resolve using Right");
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(2);
                }
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(3);
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(4);
                }
                if (changes == null) {
                    ResolveSelectedChangesAction.$$$reportNull$$$0(5);
                }
                for (int i = changes.size() - 1; i >= 0; --i) {
                    MyThreesideViewer.this.replaceChange(changes.get(i), this.mySide, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ApplySelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            public ApplySelectedChangesAction(Side side, boolean shortcut) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(0);
                }
                super(shortcut);
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(1);
                }
                return side != ThreeSide.BASE ? "Accept" : this.getTemplatePresentation().getText();
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(2);
                }
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(3);
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(4);
                }
                if (changes == null) {
                    ApplySelectedChangesAction.$$$reportNull$$$0(5);
                }
                for (int i = changes.size() - 1; i >= 0; --i) {
                    MyThreesideViewer.this.replaceChange(changes.get(i), this.mySide, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class IgnoreSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            public IgnoreSelectedChangesAction() {
                super(false);
                this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(0);
                }
                return "Ignore";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(1);
                }
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(2);
                }
                return !change.isResolved();
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(3);
                }
                if (changes == null) {
                    IgnoreSelectedChangesAction.$$$reportNull$$$0(4);
                }
                for (TextMergeChange change : changes) {
                    MyThreesideViewer.this.markChangeResolved(change);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class IgnoreSelectedChangesSideAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            public IgnoreSelectedChangesSideAction(Side side, boolean shortcut) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(0);
                }
                super(shortcut);
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.IgnoreLeftSide", (Object)"Diff.IgnoreRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(1);
                }
                return "Ignore";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(2);
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(3);
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(4);
                }
                if (changes == null) {
                    IgnoreSelectedChangesSideAction.$$$reportNull$$$0(5);
                }
                for (TextMergeChange change : changes) {
                    MyThreesideViewer.this.ignoreChange(change, this.mySide, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVisible";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabled";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private abstract class ApplySelectedChangesActionBase
        extends AnAction
        implements DumbAware {
            private final boolean myShortcut;

            public ApplySelectedChangesActionBase(boolean shortcut) {
                this.myShortcut = shortcut;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
                }
                if (this.myShortcut) {
                    e.getPresentation().setEnabledAndVisible(true);
                    return;
                }
                Presentation presentation = e.getPresentation();
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (side == null) {
                    presentation.setEnabledAndVisible(false);
                    return;
                }
                if (!this.isVisible(side)) {
                    presentation.setEnabledAndVisible(false);
                    return;
                }
                presentation.setText(this.getText(side));
                presentation.setVisible(true);
                presentation.setEnabled(this.isSomeChangeSelected(side));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
                }
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (editor == null || side == null) {
                    return;
                }
                List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
                if (selectedChanges.isEmpty()) {
                    return;
                }
                String title = e.getPresentation().getText() + " in merge";
                MyThreesideViewer.this.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, () -> this.apply(side, selectedChanges));
            }

            private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
                EditorEx editor;
                List carets;
                if (side == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
                }
                if ((carets = (editor = MyThreesideViewer.this.getEditor(side)).getCaretModel().getAllCarets()).size() != 1) {
                    return true;
                }
                Caret caret = (Caret)carets.get(0);
                if (caret.hasSelection()) {
                    return true;
                }
                int line = editor.getDocument().getLineNumber(editor.getExpectedCaretOffset());
                List<TextMergeChange> changes = MyThreesideViewer.this.getAllChanges();
                for (TextMergeChange change : changes) {
                    int line2;
                    int line1;
                    if (!this.isEnabled(change) || !DiffUtil.isSelectedByLine(line, line1 = change.getStartLine(side), line2 = change.getEndLine(side))) continue;
                    return true;
                }
                return false;
            }

            @NotNull
            private List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
                if (side == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
                }
                BitSet lines2 = DiffUtil.getSelectedLines(MyThreesideViewer.this.getEditor(side));
                List<TextMergeChange> changes = MyThreesideViewer.this.getChanges();
                ArrayList<TextMergeChange> affectedChanges = new ArrayList<TextMergeChange>();
                for (TextMergeChange change : changes) {
                    int line2;
                    int line1;
                    if (!this.isEnabled(change) || !DiffUtil.isSelectedByLine(lines2, line1 = change.getStartLine(side), line2 = change.getEndLine(side))) continue;
                    affectedChanges.add(change);
                }
                ArrayList<TextMergeChange> arrayList = affectedChanges;
                if (arrayList == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
                }
                return arrayList;
            }

            protected abstract String getText(@NotNull ThreeSide var1);

            protected abstract boolean isVisible(@NotNull ThreeSide var1);

            protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

            protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<TextMergeChange> var2);

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isSomeChangeSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelectedChanges";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyMergeModel
        extends MergeModelBase<TextMergeChange.State> {
            public MyMergeModel(@NotNull Project project, Document document) {
                if (document == null) {
                    MyMergeModel.$$$reportNull$$$0(0);
                }
                super(project, document);
            }

            @Override
            protected void reinstallHighlighters(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                change.reinstallHighlighters();
                MyThreesideViewer.this.myInnerDiffWorker.scheduleRediff(change);
            }

            @Override
            @NotNull
            protected TextMergeChange.State storeChangeState(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                TextMergeChange.State state = change.storeState();
                if (state == null) {
                    MyMergeModel.$$$reportNull$$$0(1);
                }
                return state;
            }

            @Override
            protected void restoreChangeState(@NotNull TextMergeChange.State state) {
                if (state == null) {
                    MyMergeModel.$$$reportNull$$$0(2);
                }
                super.restoreChangeState(state);
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(state.myIndex);
                boolean wasResolved = change.isResolved();
                change.restoreState(state);
                if (wasResolved != change.isResolved()) {
                    MyThreesideViewer.this.onChangeResolved(change);
                }
            }

            @Override
            @Nullable
            protected TextMergeChange.State processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
                TextMergeChange.State state = (TextMergeChange.State)super.processDocumentChange(index, oldLine1, oldLine2, shift);
                TextMergeChange mergeChange = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                if (mergeChange.getStartLine() == mergeChange.getEndLine() && mergeChange.getDiffType() == TextDiffType.DELETED && !mergeChange.isResolved()) {
                    TextMergeViewer.this.myViewer.markChangeResolved(mergeChange);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "storeChangeState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "restoreChangeState";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyInnerDiffWorker {
            @NotNull
            private final Set<TextMergeChange> myScheduled = ContainerUtil.newHashSet();
            @NotNull
            private final Alarm myAlarm = new Alarm((Disposable)MyThreesideViewer.this);
            @Nullable
            private ProgressIndicator myProgress;
            private boolean myEnabled = false;

            private MyInnerDiffWorker() {
            }

            public void scheduleRediff(@NotNull TextMergeChange change) {
                if (change == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(0);
                }
                this.scheduleRediff(Collections.singletonList(change));
            }

            public void scheduleRediff(@NotNull Collection<TextMergeChange> changes) {
                if (changes == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(1);
                }
                if (!this.myEnabled) {
                    return;
                }
                this.putChanges(changes);
                this.schedule();
            }

            public void onSettingsChanged() {
                boolean enabled;
                boolean bl = enabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                if (this.myEnabled == enabled) {
                    return;
                }
                this.myEnabled = enabled;
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                if (this.myEnabled) {
                    this.putChanges(MyThreesideViewer.this.myAllMergeChanges);
                    this.launchRediff();
                } else {
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    this.myScheduled.clear();
                    for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                        change.setInnerFragments(null);
                    }
                }
            }

            public void stop() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                this.myScheduled.clear();
                this.myAlarm.cancelAllRequests();
            }

            private void putChanges(@NotNull Collection<TextMergeChange> changes) {
                if (changes == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(2);
                }
                for (TextMergeChange change : changes) {
                    if (change.isResolved()) continue;
                    this.myScheduled.add(change);
                }
            }

            private void schedule() {
                if (this.myProgress != null) {
                    return;
                }
                if (this.myScheduled.isEmpty()) {
                    return;
                }
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(this::launchRediff, 300);
            }

            private void launchRediff() {
                MyThreesideViewer.this.myStatusPanel.setBusy(true);
                this.myProgress = new EmptyProgressIndicator();
                ArrayList scheduled = ContainerUtil.newArrayList(this.myScheduled);
                this.myScheduled.clear();
                List documents = ThreeSide.map(side -> MyThreesideViewer.this.getEditor((ThreeSide)side).getDocument());
                List data = ContainerUtil.map((Collection)scheduled, change -> new InnerChunkData((TextMergeChange)change, documents));
                ProgressIndicator indicator = this.myProgress;
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.performRediff(scheduled, data, indicator));
            }

            private void performRediff(@NotNull List<TextMergeChange> scheduled, @NotNull List<InnerChunkData> data, @NotNull ProgressIndicator indicator) {
                if (scheduled == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(3);
                }
                if (data == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(4);
                }
                if (indicator == null) {
                    MyInnerDiffWorker.$$$reportNull$$$0(5);
                }
                ArrayList<MergeInnerDifferences> result2 = new ArrayList<MergeInnerDifferences>(data.size());
                for (InnerChunkData chunkData : data) {
                    result2.add(DiffUtil.compareThreesideInner(chunkData.text, ComparisonPolicy.DEFAULT, indicator));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (indicator == null) {
                        MyInnerDiffWorker.$$$reportNull$$$0(6);
                    }
                    if (scheduled == null) {
                        MyInnerDiffWorker.$$$reportNull$$$0(7);
                    }
                    if (!this.myEnabled || indicator.isCanceled()) {
                        return;
                    }
                    this.myProgress = null;
                    for (int i = 0; i < scheduled.size(); ++i) {
                        TextMergeChange change = (TextMergeChange)scheduled.get(i);
                        if (this.myScheduled.contains(change)) continue;
                        change.setInnerFragments((MergeInnerDifferences)result2.get(i));
                    }
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    if (!this.myScheduled.isEmpty()) {
                        this.launchRediff();
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheduled";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "scheduleRediff";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "putChanges";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performRediff";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$performRediff$3";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

