/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private static final int CURRENT_VERSION = 1;
    private final File myFile;
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    @Nullable
    private PersistentHashMap<String, Record> myMap;
    private volatile ScheduledFuture<?> myMapFlusher;

    public static File getTestHistoryRoot(Project project) {
        return new File(TEST_HISTORY_PATH, project.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project) {
        if (project == null) {
            TestStateStorage.$$$reportNull$$$0(0);
        }
        return (TestStateStorage)ServiceManager.getService((Project)project, TestStateStorage.class);
    }

    public TestStateStorage(Project project) {
        String directoryPath = TestStateStorage.getTestHistoryRoot(project).getPath();
        this.myFile = new File(directoryPath + "/testStateMap");
        FileUtilRt.createParentDirs((File)this.myFile);
        try {
            this.myMap = this.initializeMap();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.myMapFlusher = FlushingDaemon.everyFiveSeconds(this::flushMap);
    }

    private PersistentHashMap<String, Record> initializeMap() throws IOException {
        return (PersistentHashMap)IOUtil.openCleanOrResetBroken(TestStateStorage.getComputable(this.myFile), (File)this.myFile);
    }

    private synchronized void flushMap() {
        if (this.myMapFlusher == null) {
            return;
        }
        if (this.myMap != null && this.myMap.isDirty()) {
            this.myMap.force();
        }
    }

    @NotNull
    private static ThrowableComputable<PersistentHashMap<String, Record>, IOException> getComputable(File file2) {
        ThrowableComputable throwableComputable = () -> new PersistentHashMap(file2, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<Record>(){

            public void save(@NotNull DataOutput out, Record value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                out.writeInt(value.magnitude);
                out.writeLong(value.date.getTime());
                out.writeLong(value.configurationHash);
            }

            public Record read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new Record(in.readInt(), new Date(in.readLong()), in.readLong());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/TestStateStorage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 4096, 1);
        if (throwableComputable == null) {
            TestStateStorage.$$$reportNull$$$0(1);
        }
        return throwableComputable;
    }

    @Nullable
    public synchronized Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get state for " + testUrl);
            return null;
        }
    }

    public synchronized void removeState(String url) {
        if (this.myMap != null) {
            try {
                this.myMap.remove((Object)url);
            }
            catch (IOException e) {
                this.thingsWentWrongLetsReinitialize(e, "Can't remove state for " + url);
            }
        }
    }

    @Nullable
    public synchronized Map<String, Record> getRecentTests(int limit, Date since) {
        if (this.myMap == null) {
            return null;
        }
        HashMap result2 = ContainerUtil.newHashMap();
        try {
            for (String key : this.myMap.getAllKeysWithExistingMapping()) {
                Record record = (Record)this.myMap.get((Object)key);
                if (record == null || record.date.compareTo(since) <= 0) continue;
                result2.put(key, record);
                if (result2.size() < limit) continue;
                break;
            }
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get recent tests");
        }
        return result2;
    }

    public synchronized void writeState(@NotNull String testUrl, Record record) {
        if (testUrl == null) {
            TestStateStorage.$$$reportNull$$$0(2);
        }
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't write state for " + testUrl);
        }
    }

    public synchronized void dispose() {
        this.myMapFlusher.cancel(false);
        this.myMapFlusher = null;
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myMap = null;
        }
    }

    private void thingsWentWrongLetsReinitialize(IOException e, String message) {
        try {
            if (this.myMap != null) {
                try {
                    this.myMap.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
            }
            this.myMap = this.initializeMap();
            LOG.warn(message, (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error("Cannot repair", (Throwable)e1);
            this.myMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/TestStateStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/TestStateStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComputable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Record {
        public final int magnitude;
        public final long configurationHash;
        public final Date date;

        public Record(int magnitude, Date date, long configurationHash) {
            this.magnitude = magnitude;
            this.date = date;
            this.configurationHash = configurationHash;
        }
    }
}

