/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleExecuteAction
extends DumbAwareAction {
    static final String CONSOLE_EXECUTE_ACTION_ID = "Console.Execute";
    private final LanguageConsoleView myConsoleView;
    final ConsoleExecuteActionHandler myExecuteActionHandler;
    private final Condition<LanguageConsoleView> myEnabledCondition;

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler) {
        if (console == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(0);
        }
        if (executeActionHandler == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(1);
        }
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, (Condition<LanguageConsoleView>)Conditions.alwaysTrue());
    }

    ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull ConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        if (console == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(2);
        }
        if (executeActionHandler == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(3);
        }
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        if (console == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(4);
        }
        if (executeActionHandler == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(5);
        }
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView consoleView, @NotNull ConsoleExecuteActionHandler executeActionHandler, @NotNull String emptyExecuteActionId, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        if (consoleView == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(6);
        }
        if (executeActionHandler == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(7);
        }
        if (emptyExecuteActionId == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(8);
        }
        super(null, null, AllIcons.Actions.Execute);
        this.myConsoleView = consoleView;
        this.myExecuteActionHandler = executeActionHandler;
        this.myEnabledCondition = enabledCondition == null ? Conditions.alwaysTrue() : enabledCondition;
        EmptyAction.setupAction((AnAction)this, (String)emptyExecuteActionId, null);
    }

    public final void update(@NotNull AnActionEvent e) {
        EditorEx editor;
        boolean enabled;
        if (e == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(9);
        }
        boolean bl = enabled = !(editor = this.myConsoleView.getConsoleEditor()).isRendererMode() && this.isEnabled() && (this.myExecuteActionHandler.isEmptyCommandExecutionAllowed() || !StringUtil.isEmptyOrSpaces((CharSequence)editor.getDocument().getCharsSequence()));
        if (enabled) {
            LookupEx lookup = LookupManager.getActiveLookup(editor);
            enabled = lookup == null || !lookup.isCompletion() || lookup.getCurrentItem() == null || lookup instanceof LookupImpl && ((LookupImpl)lookup).getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED;
        }
        e.getPresentation().setEnabled(enabled);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(10);
        }
        this.myExecuteActionHandler.runExecuteAction(this.myConsoleView);
    }

    public boolean isEnabled() {
        return this.myEnabledCondition.value((Object)this.myConsoleView);
    }

    public void execute(@Nullable TextRange range2, @NotNull String text, @Nullable EditorEx editor) {
        if (text == null) {
            ConsoleExecuteAction.$$$reportNull$$$0(11);
        }
        if (range2 == null) {
            ((LanguageConsoleImpl)this.myConsoleView).doAddPromptToHistory();
            this.myConsoleView.print(text, ConsoleViewContentType.USER_INPUT);
            if (!text.endsWith("\n")) {
                this.myConsoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            }
        } else {
            assert (editor != null);
            ((LanguageConsoleImpl)this.myConsoleView).addTextRangeToHistory(range2, editor, this.myExecuteActionHandler.myPreserveMarkup);
        }
        this.myExecuteActionHandler.addToCommandHistoryAndExecute(this.myConsoleView, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeActionHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyExecuteActionId";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/console/ConsoleExecuteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ConsoleExecuteActionHandler {
        private boolean myAddToHistory = true;
        final boolean myPreserveMarkup;
        boolean myUseProcessStdIn;

        public ConsoleExecuteActionHandler(boolean preserveMarkup) {
            this.myPreserveMarkup = preserveMarkup;
        }

        public boolean isEmptyCommandExecutionAllowed() {
            return true;
        }

        public final void setAddCurrentToHistory(boolean addCurrentToHistory) {
            this.myAddToHistory = addCurrentToHistory;
        }

        protected void beforeExecution(@NotNull LanguageConsoleView consoleView) {
            if (consoleView == null) {
                ConsoleExecuteActionHandler.$$$reportNull$$$0(0);
            }
        }

        public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
            if (consoleView == null) {
                ConsoleExecuteActionHandler.$$$reportNull$$$0(1);
            }
            if (!this.myUseProcessStdIn) {
                this.beforeExecution(consoleView);
            }
            String text = ((LanguageConsoleImpl)consoleView).prepareExecuteAction(this.myAddToHistory && !this.myUseProcessStdIn, this.myPreserveMarkup, true);
            ((UndoManagerImpl)UndoManager.getInstance((Project)consoleView.getProject())).invalidateActionsFor(DocumentReferenceManager.getInstance().create((Document)consoleView.getCurrentEditor().getDocument()));
            if (this.myUseProcessStdIn) {
                consoleView.print(text, ConsoleViewContentType.USER_INPUT);
                consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            } else {
                this.addToCommandHistoryAndExecute(consoleView, text);
            }
        }

        private void addToCommandHistoryAndExecute(@NotNull LanguageConsoleView consoleView, @NotNull String text) {
            if (consoleView == null) {
                ConsoleExecuteActionHandler.$$$reportNull$$$0(2);
            }
            if (text == null) {
                ConsoleExecuteActionHandler.$$$reportNull$$$0(3);
            }
            ConsoleHistoryController.addToHistory(consoleView, text);
            this.doExecute(text, consoleView);
        }

        abstract void doExecute(@NotNull String var1, @NotNull LanguageConsoleView var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExecution";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runExecuteAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToCommandHistoryAndExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

