/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractRerunFailedTestsAction
extends AnAction
implements AnAction.TransparentUpdate {
    private static final Logger LOG = Logger.getInstance(AbstractRerunFailedTestsAction.class);
    private TestFrameworkRunningModel myModel;
    private Getter<TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        this.copyFrom(ActionManager.getInstance().getAction("RerunFailedTests"));
        this.registerCustomShortcutSet(this.getShortcutSet(), componentContainer.getComponent());
    }

    public void init(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void setModelProvider(Getter<TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isActive(e));
    }

    private boolean isActive(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null || model.getRoot() == null) {
            return false;
        }
        ExecutionEnvironment environment = (ExecutionEnvironment)e.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        if (environment == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        if (settings != null && !settings.getType().isDumbAware() && DumbService.isDumb((Project)project)) {
            return false;
        }
        Filter<?> filter2 = this.getFailuresFilter();
        for (AbstractTestProxy abstractTestProxy : model.getRoot().getAllTests()) {
            if (!filter2.shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(@NotNull Project project) {
        TestFrameworkRunningModel model;
        if (project == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        if ((model = this.getModel()) == null) {
            List<AbstractTestProxy> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractRerunFailedTestsAction.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<AbstractTestProxy> list3 = this.getFilter(project, model.getProperties().getScope()).select(model.getRoot().getAllTests());
        if (list3 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(6);
        }
        Filter<?> filter2 = this.getFailuresFilter();
        if (filter2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(7);
        }
        return filter2;
    }

    protected Filter<?> getFailuresFilter() {
        return AbstractRerunFailedTestsAction.getFailuresFilter(this.myConsoleProperties);
    }

    public static Filter<?> getFailuresFilter(TestConsoleProperties consoleProperties) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value((AbstractProperty.AbstractPropertyContainer)consoleProperties)) {
            return Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED).and(Filter.IGNORED.not());
        }
        return Filter.FAILED_OR_INTERRUPTED.and(Filter.IGNORED.not());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ExecutionEnvironment environment;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(8);
        }
        if ((environment = (ExecutionEnvironment)e.getData(LangDataKeys.EXECUTION_ENVIRONMENT)) == null) {
            return;
        }
        this.execute(e, environment);
    }

    void execute(@NotNull AnActionEvent e, @NotNull ExecutionEnvironment environment) {
        MyRunProfile profile2;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(10);
        }
        if ((profile2 = this.getRunProfile(environment)) == null) {
            return;
        }
        ExecutionEnvironmentBuilder environmentBuilder = new ExecutionEnvironmentBuilder(environment).runProfile((RunProfile)profile2);
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || !event.isShiftDown()) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder);
            return;
        }
        LinkedHashMap<Executor, ProgramRunner> availableRunners = new LinkedHashMap<Executor, ProgramRunner>();
        for (Executor ex : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(ex.getId(), (RunProfile)profile2);
            if (runner == null) continue;
            availableRunners.put(ex, runner);
        }
        if (availableRunners.isEmpty()) {
            LOG.error(environment.getExecutor().getActionName() + " is not available now");
        } else if (availableRunners.size() == 1) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(environment.getExecutor())));
        } else {
            JBList list2 = new JBList(availableRunners.keySet());
            list2.setSelectionMode(0);
            list2.setSelectedValue((Object)environment.getExecutor(), true);
            list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component component = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                    if (value instanceof Executor) {
                        this.setText(UIUtil.removeMnemonic((String)((Executor)value).getStartActionText()));
                        this.setIcon(((Executor)value).getIcon());
                    }
                    Component component2 = component;
                    if (component2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Restart Failed Tests").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                Object value = list2.getSelectedValue();
                if (value instanceof Executor) {
                    AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(value)).executor((Executor)value));
                }
            }).createPopup().showUnderneathOf(event.getComponent());
        }
    }

    private static void performAction(@NotNull ExecutionEnvironmentBuilder builder) {
        if (builder == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(11);
        }
        ExecutionEnvironment environment = builder.build();
        try {
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        finally {
            ((MyRunProfile)environment.getRunProfile()).clear();
        }
    }

    @Deprecated
    public MyRunProfile getRunProfile() {
        return null;
    }

    @Nullable
    protected MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(12);
        }
        return this.getRunProfile();
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return (TestFrameworkRunningModel)this.myModelProvider.get();
        }
        return null;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedTests";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFailedTests";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase> {
        private final RunConfigurationBase myConfiguration;

        @Deprecated
        public RunConfigurationBase getConfiguration() {
            return this.getPeer();
        }

        public RunConfigurationBase getPeer() {
            return this.myConfiguration;
        }

        public MyRunProfile(RunConfigurationBase configuration) {
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        public void readExternal(@NotNull Element element) throws InvalidDataException {
            if (element == null) {
                MyRunProfile.$$$reportNull$$$0(0);
            }
            this.myConfiguration.readExternal(element);
        }

        public void writeExternal(@NotNull Element element) throws WriteExternalException {
            if (element == null) {
                MyRunProfile.$$$reportNull$$$0(1);
            }
            this.myConfiguration.writeExternal(element);
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                MyRunProfile.$$$reportNull$$$0(2);
            }
            return settingsEditor;
        }

        @NotNull
        public ConfigurationType getType() {
            ConfigurationType configurationType = this.myConfiguration.getType();
            if (configurationType == null) {
                MyRunProfile.$$$reportNull$$$0(3);
            }
            return configurationType;
        }

        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        @NotNull
        public List<PredefinedLogFile> getPredefinedLogFiles() {
            List list2 = this.myConfiguration.getPredefinedLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public ArrayList<LogFileOptions> getAllLogFiles() {
            ArrayList arrayList = this.myConfiguration.getAllLogFiles();
            if (arrayList == null) {
                MyRunProfile.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @NotNull
        public List<LogFileOptions> getLogFiles() {
            List list2 = this.myConfiguration.getLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(6);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPredefinedLogFiles";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLogFiles";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

