/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CheckRequiredPluginsActivity
implements StartupActivity,
DumbAware {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Required Plugins", NotificationDisplayType.BALLOON, true);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(0);
        }
        ExternalDependenciesManager.getInstance(project);
    }

    public static void runCheck(final @NotNull Project project) {
        List<DependencyOnPlugin> dependencies;
        if (project == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(1);
        }
        if ((dependencies = ExternalDependenciesManager.getInstance(project).getDependencies(DependencyOnPlugin.class)).isEmpty()) {
            return;
        }
        List<String> customRepositories = UpdateSettings.getInstance().getStoredPluginHosts();
        ArrayList<String> errorMessages = new ArrayList<String>();
        final ArrayList<String> missingCustomRepositories = new ArrayList<String>();
        final ArrayList<IdeaPluginDescriptor> disabled = new ArrayList<IdeaPluginDescriptor>();
        final ArrayList<PluginId> notInstalled = new ArrayList<PluginId>();
        for (DependencyOnPlugin dependency : dependencies) {
            String maxVersion;
            IdeaPluginDescriptor plugin;
            PluginId pluginId = PluginId.getId((String)dependency.getPluginId());
            String channel = dependency.getChannel();
            String customRepository = CheckRequiredPluginsActivity.getCustomRepository(pluginId, channel);
            if (!StringUtil.isEmpty((String)channel) && CheckRequiredPluginsActivity.customRepositoryNotSpecified(customRepositories, customRepository)) {
                errorMessages.add("Custom repository '" + customRepository + "' required for '" + project.getName() + "' project isn't installed.");
                missingCustomRepositories.add(customRepository);
            }
            if ((plugin = PluginManager.getPlugin(pluginId)) == null) {
                errorMessages.add("Plugin '" + dependency.getPluginId() + "' required for '" + project.getName() + "' project isn't installed.");
                notInstalled.add(pluginId);
                continue;
            }
            if (!plugin.isEnabled()) {
                errorMessages.add("Plugin '" + plugin.getName() + "' required for '" + project.getName() + "' project is disabled.");
                disabled.add(plugin);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            if (minVersion != null && VersionComparatorUtil.compare((String)plugin.getVersion(), (String)minVersion) < 0) {
                errorMessages.add("Project '" + project.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + minVersion + "' or higher, but '" + plugin.getVersion() + "' is installed.");
            }
            if ((maxVersion = dependency.getMaxVersion()) == null || VersionComparatorUtil.compare((String)plugin.getVersion(), (String)maxVersion) <= 0) continue;
            errorMessages.add("Project '" + project.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + maxVersion + "' or lower, but '" + plugin.getVersion() + "' is installed.");
        }
        if (!errorMessages.isEmpty()) {
            if (!missingCustomRepositories.isEmpty()) {
                errorMessages.add("<a href=\"addRepositories\">Add custom repositories and install required plugins</a>");
            } else if (!disabled.isEmpty() && notInstalled.isEmpty()) {
                String plugins2 = disabled.size() == 1 ? ((IdeaPluginDescriptor)disabled.get(0)).getName() : "required plugins";
                errorMessages.add("<a href=\"enable\">Enable " + plugins2 + "</a>");
            } else if (!disabled.isEmpty() || !notInstalled.isEmpty()) {
                errorMessages.add("<a href=\"install\">Install required plugins</a>");
            }
            NOTIFICATION_GROUP.createNotification("Required plugins weren't loaded", StringUtil.join(errorMessages, (String)"<br>"), NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if ("addRepositories".equals(event.getDescription())) {
                            UpdateSettings.getInstance().getStoredPluginHosts().addAll(missingCustomRepositories);
                        }
                        if ("enable".equals(event.getDescription())) {
                            notification.expire();
                            for (IdeaPluginDescriptor descriptor : disabled) {
                                PluginManagerCore.enablePlugin(descriptor.getPluginId().getIdString());
                            }
                            PluginManagerMain.notifyPluginsUpdated(project);
                        } else if ("install".equals(event.getDescription()) || "addRepositories".equals(event.getDescription())) {
                            HashSet<String> pluginIds = new HashSet<String>();
                            for (IdeaPluginDescriptor descriptor : disabled) {
                                pluginIds.add(descriptor.getPluginId().getIdString());
                            }
                            for (PluginId pluginId : notInstalled) {
                                pluginIds.add(pluginId.getIdString());
                            }
                            PluginsAdvertiser.installAndEnablePlugins(pluginIds, () -> {
                                if (notification == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                notification.expire();
                            });
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "hyperlinkUpdate";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$hyperlinkUpdate$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).notify(project);
        }
    }

    private static boolean customRepositoryNotSpecified(List<String> repositories, String customRepository) {
        return !repositories.contains(customRepository);
    }

    private static String getCustomRepository(PluginId id, String channel) {
        return String.format(ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl() + "/plugins/%s/%s", channel, id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

