/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;

public class SelectedTextFormatter {
    private Project myProject;
    private Editor myEditor;
    private PsiFile myFile;
    private final String myTextBefore;
    private final int mySelectionStart;
    private final int mySelectionEnd;

    public SelectedTextFormatter(Project project, Editor editor, PsiFile file2) {
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file2;
        this.myTextBefore = this.myEditor.getSelectionModel().getSelectedText();
        this.mySelectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        this.mySelectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
    }

    public void restoreSelectedText() {
        Document document = this.myEditor.getDocument();
        int start = this.myEditor.getSelectionModel().getSelectionStart();
        int end = this.myEditor.getSelectionModel().getSelectionEnd();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> document.replaceString(start, end, (CharSequence)this.myTextBefore), "Configure code style on selected fragment: restore text before", null));
        this.myEditor.getSelectionModel().setSelection(this.mySelectionStart, this.mySelectionEnd);
    }

    void reformatSelectedText(@NotNull CodeStyleSettings reformatSettings) {
        SelectionModel model;
        if (reformatSettings == null) {
            SelectedTextFormatter.$$$reportNull$$$0(0);
        }
        if ((model = this.myEditor.getSelectionModel()).hasSelection()) {
            try {
                CodeStyleSettingsManager.getInstance((Project)this.myProject).setTemporarySettings(reformatSettings);
                SelectedTextFormatter.reformatRange(this.myFile, this.getSelectedRange());
            }
            finally {
                CodeStyleSettingsManager.getInstance((Project)this.myProject).dropTemporarySettings();
            }
        }
    }

    void reformatWholeFile() {
        SelectedTextFormatter.reformatRange(this.myFile, this.myFile.getTextRange());
    }

    private static void reformatRange(@NotNull PsiFile file2, @NotNull TextRange range2) {
        if (file2 == null) {
            SelectedTextFormatter.$$$reportNull$$$0(1);
        }
        if (range2 == null) {
            SelectedTextFormatter.$$$reportNull$$$0(2);
        }
        Project project = file2.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (file2 == null) {
                SelectedTextFormatter.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                SelectedTextFormatter.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (file2 == null) {
                    SelectedTextFormatter.$$$reportNull$$$0(6);
                }
                if (range2 == null) {
                    SelectedTextFormatter.$$$reportNull$$$0(7);
                }
                CodeStyleManager.getInstance((Project)project).reformatText(file2, range2.getStartOffset(), range2.getEndOffset());
            });
        }, "Reformat", null);
    }

    @NotNull
    TextRange getSelectedRange() {
        SelectionModel model = this.myEditor.getSelectionModel();
        int start = model.getSelectionStart();
        int end = model.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start, (int)end);
        if (textRange == null) {
            SelectedTextFormatter.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reformatSettings";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/contextConfiguration/SelectedTextFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/contextConfiguration/SelectedTextFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformatSelectedText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reformatRange$3";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

