/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairFunction;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class MicrodataUtil {
    public static final Key<List<String>> ITEM_PROP_KEYS = Key.create((String)"microdata.prop");
    public static final String ITEM_REF = "itemref";
    public static final String ITEM_SCOPE = "itemscope";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_PROP = "itemprop";
    public static final String ITEM_ID = "itemid";

    public static boolean hasScopeTag(@Nullable XmlTag tag) {
        return MicrodataUtil.findScopeTag(tag) != null;
    }

    @Nullable
    public static XmlTag findScopeTag(@Nullable XmlTag context) {
        Map<String, XmlTag> id2tag = MicrodataUtil.findScopesWithItemRef(context != null ? context.getContainingFile() : null);
        for (XmlTag tag = context; tag != null; tag = tag.getParentTag()) {
            if (tag != context && tag.getAttribute(ITEM_SCOPE) != null) {
                return tag;
            }
            String id = MicrodataUtil.getStripedAttributeValue(tag, "id");
            if (id == null || !id2tag.containsKey(id)) continue;
            return id2tag.get(id);
        }
        return null;
    }

    private static Map<String, XmlTag> findScopesWithItemRef(final @Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file2, (CachedValueProvider)new CachedValueProvider<Map<String, XmlTag>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
                THashMap result2 = new THashMap();
                file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)result2){
                    final /* synthetic */ Map val$result;
                    {
                        this.val$result = map;
                    }

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        XmlAttribute refAttr = tag.getAttribute(MicrodataUtil.ITEM_REF);
                        if (refAttr != null && tag.getAttribute(MicrodataUtil.ITEM_SCOPE) != null) {
                            MicrodataUtil.getReferencesForAttributeValue(refAttr.getValueElement(), (PairFunction<String, Integer, PsiReference>)((PairFunction)(t, v) -> {
                                this.val$result.put(t, tag);
                                return null;
                            }));
                        }
                    }
                });
                return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{file2});
            }
        });
    }

    public static List<String> extractProperties(PsiFile file2, String type) {
        List<String> result2;
        VirtualFile virtualFile = file2.getVirtualFile();
        List<String> list2 = result2 = virtualFile != null ? (List<String>)virtualFile.getUserData(ITEM_PROP_KEYS) : null;
        if (virtualFile != null && result2 == null) {
            result2 = MicrodataUtil.collectNames(file2, type);
            virtualFile.putUserData(ITEM_PROP_KEYS, result2);
        }
        return result2;
    }

    private static List<String> collectNames(PsiFile file2, String type) {
        if (file2 instanceof XmlFile) {
            CollectNamesVisitor collectNamesVisitor = MicrodataUtil.getVisitorByType(type);
            file2.accept((PsiElementVisitor)collectNamesVisitor);
            return collectNamesVisitor.getValues();
        }
        return Collections.emptyList();
    }

    private static CollectNamesVisitor getVisitorByType(String type) {
        if (type.contains("schema.org")) {
            return new CollectNamesFromSchemaOrgVisitor();
        }
        return new CollectNamesByMicrodataVisitor(type);
    }

    public static PsiReference[] getUrlReferencesForAttributeValue(XmlAttributeValue element) {
        return MicrodataUtil.getReferencesForAttributeValue(element, (PairFunction<String, Integer, PsiReference>)((PairFunction)(token, offset) -> {
            if (HtmlUtil.hasHtmlPrefix(token)) {
                TextRange range2 = TextRange.from((int)offset, (int)token.length());
                URLReference urlReference = new URLReference((PsiElement)element, range2, true);
                return new DependentNSReference((PsiElement)element, range2, urlReference, true);
            }
            return null;
        }));
    }

    public static PsiReference[] getReferencesForAttributeValue(@Nullable XmlAttributeValue element, PairFunction<String, Integer, PsiReference> refFun) {
        if (element == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = element.getText();
        String urls = StringUtil.unquoteString((String)text);
        StringTokenizer tokenizer = new StringTokenizer(urls);
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        while (tokenizer.hasMoreTokens()) {
            int index;
            String token = tokenizer.nextToken();
            PsiReference ref = (PsiReference)refFun.fun((Object)token, (Object)(index = text.indexOf(token)));
            if (ref == null) continue;
            result2.add(ref);
        }
        return result2.toArray(new PsiReference[result2.size()]);
    }

    @Nullable
    public static String getStripedAttributeValue(@Nullable XmlTag tag, @Nls String attributeName) {
        String value = tag != null ? tag.getAttributeValue(attributeName) : null;
        return value != null ? StringUtil.unquoteString((String)value) : null;
    }

    public static class CollectNamesFromSchemaOrgVisitor
    extends CollectNamesVisitor {
        public void visitXmlTag(XmlTag tag) {
            String code2;
            super.visitXmlTag(tag);
            if ("prop-nam".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag, "class")) && (code2 = tag.getSubTagText("code")) != null) {
                this.myValues.add(StringUtil.stripHtml((String)code2, (boolean)false));
            }
        }
    }

    public static class CollectNamesByMicrodataVisitor
    extends CollectNamesVisitor {
        protected final String myType;
        private boolean myCollecting = false;

        public CollectNamesByMicrodataVisitor(String type) {
            this.myType = type;
        }

        public void visitXmlTag(XmlTag tag) {
            String value = MicrodataUtil.getStripedAttributeValue(tag, MicrodataUtil.ITEM_ID);
            boolean isTypeTag = this.myType.equalsIgnoreCase(value);
            if (isTypeTag) {
                this.myCollecting = true;
            }
            if (this.myCollecting && "name".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag, MicrodataUtil.ITEM_PROP))) {
                this.myValues.add(tag.getValue().getTrimmedText());
            }
            super.visitXmlTag(tag);
            if (isTypeTag) {
                this.myCollecting = false;
            }
        }
    }

    private static class CollectNamesVisitor
    extends XmlRecursiveElementVisitor {
        protected final Set<String> myValues = new THashSet();

        private CollectNamesVisitor() {
        }

        public List<String> getValues() {
            return new ArrayList<String>(this.myValues);
        }
    }
}

