/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiActivityMonitorImpl
extends UiActivityMonitor
implements ModalityStateListener,
Disposable {
    private final Map<Project, BusyContainer> myObjects = FactoryMap.create(this::create);
    private boolean myActive;
    @NotNull
    private final BusyObject myEmptyBusy = new BusyObject.Impl(){

        public boolean isReady() {
            return true;
        }
    };

    @NotNull
    private BusyContainer create(Project key) {
        if (this.myObjects.isEmpty()) {
            this.installListener();
        }
        BusyContainer busyContainer = key == null ? new BusyContainer(null) : new BusyContainer(null){

            @Override
            @NotNull
            protected BusyImpl createBusyImpl(@NotNull Set<UiActivity> key) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                BusyImpl busyImpl = new BusyImpl(key, this){

                    @Override
                    public boolean isReady() {
                        for (Map.Entry entry : UiActivityMonitorImpl.this.myObjects.entrySet()) {
                            BusyContainer eachContainer = (BusyContainer)entry.getValue();
                            BusyImpl busy = eachContainer.getOrCreateBusy(this.myToWatchArray);
                            if (busy == this || busy.isOwnReady()) continue;
                            return false;
                        }
                        return this.isOwnReady();
                    }
                };
                if (busyImpl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return busyImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/UiActivityMonitorImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/UiActivityMonitorImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createBusyImpl";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createBusyImpl";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (busyContainer == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(0);
        }
        return busyContainer;
    }

    public void installListener() {
        LaterInvocator.addModalityStateListener(this, this);
    }

    public void dispose() {
        this.myObjects.clear();
    }

    public void beforeModalityStateChanged(boolean entering) {
        SwingUtilities.invokeLater(() -> this.maybeReady());
    }

    public void maybeReady() {
        for (BusyContainer each : this.myObjects.values()) {
            each.onReady();
        }
    }

    @NotNull
    public BusyObject getBusy(@NotNull Project project, UiActivity ... toWatch) {
        if (project == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(1);
        }
        if (toWatch == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(2);
        }
        if (!this.isActive()) {
            BusyObject busyObject = this.myEmptyBusy;
            if (busyObject == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(3);
            }
            return busyObject;
        }
        BusyImpl busyImpl = this._getBusy(project, toWatch);
        if (busyImpl == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(4);
        }
        return busyImpl;
    }

    @NotNull
    public BusyObject getBusy(UiActivity ... toWatch) {
        if (toWatch == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(5);
        }
        if (!this.isActive()) {
            BusyObject busyObject = this.myEmptyBusy;
            if (busyObject == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(6);
            }
            return busyObject;
        }
        BusyImpl busyImpl = this._getBusy(null, toWatch);
        if (busyImpl == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(7);
        }
        return busyImpl;
    }

    public void addActivity(@NotNull Project project, @NotNull UiActivity activity) {
        if (project == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(8);
        }
        if (activity == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(9);
        }
        this.addActivity(project, activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    public void addActivity(@NotNull Project project, @NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
        if (project == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(10);
        }
        if (activity == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(11);
        }
        if (effectiveModalityState == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(12);
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(28);
            }
            if (activity == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(29);
            }
            if (effectiveModalityState == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(30);
            }
            this.getBusyContainer(project).addActivity(activity, effectiveModalityState);
        });
    }

    public void removeActivity(@NotNull Project project, @NotNull UiActivity activity) {
        if (project == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(13);
        }
        if (activity == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(14);
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(26);
            }
            if (activity == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(27);
            }
            this._getBusy(project, new UiActivity[0]).removeActivity(activity);
        });
    }

    public void addActivity(@NotNull UiActivity activity) {
        if (activity == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(15);
        }
        this.addActivity(activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    private static ModalityState getDefaultModalityState() {
        return ApplicationManager.getApplication().getNoneModalityState();
    }

    public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
        if (activity == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(16);
        }
        if (effectiveModalityState == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(17);
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (activity == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(24);
            }
            if (effectiveModalityState == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(25);
            }
            this.getBusyContainer(null).addActivity(activity, effectiveModalityState);
        });
    }

    public void removeActivity(@NotNull UiActivity activity) {
        if (activity == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(18);
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (activity == null) {
                UiActivityMonitorImpl.$$$reportNull$$$0(23);
            }
            this._getBusy(null, new UiActivity[0]).removeActivity(activity);
        });
    }

    @NotNull
    private BusyImpl _getBusy(@Nullable Project key, UiActivity ... toWatch) {
        if (toWatch == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(19);
        }
        BusyImpl busyImpl = this.getBusyContainer(key).getOrCreateBusy(toWatch);
        if (busyImpl == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(20);
        }
        return busyImpl;
    }

    @NotNull
    private BusyContainer getBusyContainer(@Nullable Project key) {
        BusyContainer container = this.myObjects.get(key);
        BusyContainer busyContainer = container != null ? container : this.getGlobalBusy();
        if (busyContainer == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(21);
        }
        return busyContainer;
    }

    void initBusyObjectFor(@Nullable Project key) {
        this.myObjects.put(key, new BusyContainer(key));
    }

    boolean hasObjectFor(Project project) {
        return this.myObjects.containsKey(project);
    }

    private BusyContainer getGlobalBusy() {
        return this.myObjects.get(null);
    }

    public void clear() {
        Set<Project> keys = this.myObjects.keySet();
        for (Project each : keys) {
            this.myObjects.get(each).clear();
        }
    }

    public void setActive(boolean active) {
        if (this.myActive == active) {
            return;
        }
        if (this.myActive) {
            this.clear();
        }
        this.myActive = active;
    }

    public boolean isActive() {
        return this.myActive;
    }

    @NotNull
    protected ModalityState getCurrentState() {
        ModalityState modalityState = ModalityState.current();
        if (modalityState == null) {
            UiActivityMonitorImpl.$$$reportNull$$$0(22);
        }
        return modalityState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/UiActivityMonitorImpl";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 13: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toWatch";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 12: 
            case 17: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveModalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/UiActivityMonitorImpl";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBusy";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "_getBusy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBusyContainer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBusy";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addActivity";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeActivity";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "_getBusy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeActivity$4";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addActivity$3";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeActivity$2";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addActivity$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class BusyContainer
    implements Disposable {
        private final Map<Set<UiActivity>, BusyImpl> myActivities2Object = new HashMap<Set<UiActivity>, BusyImpl>();
        private final Map<BusyImpl, Set<UiActivity>> myObject2Activities = new HashMap<BusyImpl, Set<UiActivity>>();
        private final Set<UiActivity> myActivities = new HashSet<UiActivity>();
        private boolean myRemovingActivityNow;
        @Nullable
        private final Project myProject;

        public BusyContainer(Project project) {
            this.myProject = project;
            this.registerBusyObject(new HashSet<UiActivity>());
            if (project != null) {
                Disposer.register((Disposable)project, (Disposable)this);
            }
        }

        @NotNull
        public BusyImpl getOrCreateBusy(UiActivity ... activities) {
            HashSet<UiActivity> key;
            if (activities == null) {
                BusyContainer.$$$reportNull$$$0(0);
            }
            if (this.myActivities2Object.containsKey(key = new HashSet<UiActivity>(Arrays.asList(activities)))) {
                BusyImpl busyImpl = this.myActivities2Object.get(key);
                if (busyImpl == null) {
                    BusyContainer.$$$reportNull$$$0(1);
                }
                return busyImpl;
            }
            BusyImpl busyImpl = this.registerBusyObject(key);
            if (busyImpl == null) {
                BusyContainer.$$$reportNull$$$0(2);
            }
            return busyImpl;
        }

        @NotNull
        private BusyImpl registerBusyObject(@NotNull Set<UiActivity> key) {
            if (key == null) {
                BusyContainer.$$$reportNull$$$0(3);
            }
            BusyImpl busy = this.createBusyImpl(key);
            this.myActivities2Object.put(key, busy);
            this.myObject2Activities.put(busy, key);
            BusyImpl busyImpl = busy;
            if (busyImpl == null) {
                BusyContainer.$$$reportNull$$$0(4);
            }
            return busyImpl;
        }

        @NotNull
        protected BusyImpl createBusyImpl(@NotNull Set<UiActivity> key) {
            if (key == null) {
                BusyContainer.$$$reportNull$$$0(5);
            }
            BusyImpl busyImpl = new BusyImpl(key, this);
            if (busyImpl == null) {
                BusyContainer.$$$reportNull$$$0(6);
            }
            return busyImpl;
        }

        public void onReady() {
            Iterator<Set<UiActivity>> keyIterator = this.myActivities2Object.keySet().iterator();
            while (keyIterator.hasNext()) {
                Set<UiActivity> eachKey = keyIterator.next();
                BusyImpl busy = this.myActivities2Object.get(eachKey);
                busy.onReady();
                if (!busy.isReady()) continue;
                keyIterator.remove();
                this.myObject2Activities.remove((Object)busy);
            }
        }

        public void clear() {
            UiActivity[] activities;
            for (UiActivity each : activities = this.myActivities.toArray(new UiActivity[this.myActivities.size()])) {
                UiActivityMonitorImpl.this.removeActivity(each);
            }
        }

        public void onActivityAdded(@NotNull UiActivity activity) {
            if (activity == null) {
                BusyContainer.$$$reportNull$$$0(7);
            }
            this.myActivities.add(activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityRemoved(@NotNull BusyImpl busy, @NotNull UiActivity activity) {
            Set<UiActivity> activities;
            if (busy == null) {
                BusyContainer.$$$reportNull$$$0(8);
            }
            if (activity == null) {
                BusyContainer.$$$reportNull$$$0(9);
            }
            if (this.myRemovingActivityNow) {
                return;
            }
            HashMap<BusyImpl, Set<UiActivity>> toRemove2 = new HashMap<BusyImpl, Set<UiActivity>>();
            try {
                this.myRemovingActivityNow = true;
                this.myActivities.remove(activity);
                for (BusyImpl each : this.myObject2Activities.keySet()) {
                    if (each != busy) {
                        each.removeActivity(activity);
                    }
                    if (!each.isReady()) continue;
                    activities = this.myObject2Activities.get((Object)busy);
                    toRemove2.put(busy, activities);
                }
            }
            catch (Throwable throwable) {
                for (BusyImpl each : toRemove2.keySet()) {
                    Set<UiActivity> activities2 = this.myObject2Activities.remove((Object)each);
                    this.myActivities2Object.remove(activities2);
                }
                this.myRemovingActivityNow = false;
                throw throwable;
            }
            for (BusyImpl each : toRemove2.keySet()) {
                activities = this.myObject2Activities.remove((Object)each);
                this.myActivities2Object.remove(activities);
            }
            this.myRemovingActivityNow = false;
        }

        public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState state) {
            if (activity == null) {
                BusyContainer.$$$reportNull$$$0(10);
            }
            if (state == null) {
                BusyContainer.$$$reportNull$$$0(11);
            }
            this.getOrCreateBusy(activity);
            Set<BusyImpl> busies = this.myObject2Activities.keySet();
            for (BusyImpl each : busies) {
                each.addActivity(activity, state);
            }
        }

        public void dispose() {
            UiActivityMonitorImpl.this.myObjects.remove(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activities";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/UiActivityMonitorImpl$BusyContainer";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "busy";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/UiActivityMonitorImpl$BusyContainer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateBusy";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerBusyObject";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBusyImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateBusy";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "registerBusyObject";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createBusyImpl";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "onActivityAdded";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "onActivityRemoved";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addActivity";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class BusyImpl
    extends BusyObject.Impl {
        private final Map<UiActivity, ActivityInfo> myActivities;
        private final Set<UiActivity> myQueuedToRemove;
        protected final Set<UiActivity> myToWatch;
        protected final UiActivity[] myToWatchArray;
        private final BusyContainer myContainer;

        private BusyImpl(@NotNull Set<UiActivity> toWatch, BusyContainer container) {
            if (toWatch == null) {
                BusyImpl.$$$reportNull$$$0(0);
            }
            if (container == null) {
                BusyImpl.$$$reportNull$$$0(1);
            }
            this.myActivities = new HashMap<UiActivity, ActivityInfo>();
            this.myQueuedToRemove = new HashSet<UiActivity>();
            this.myToWatch = toWatch;
            this.myToWatchArray = toWatch.toArray(new UiActivity[toWatch.size()]);
            this.myContainer = container;
        }

        public boolean isReady() {
            return this.isOwnReady() && UiActivityMonitorImpl.this.getGlobalBusy().getOrCreateBusy(this.myToWatchArray).isOwnReady();
        }

        boolean isOwnReady() {
            HashMap<UiActivity, ActivityInfo> infoToCheck = new HashMap<UiActivity, ActivityInfo>();
            for (Set eachActivitySet : this.myContainer.myActivities2Object.keySet()) {
                BusyImpl eachBusyObject = (BusyImpl)((Object)this.myContainer.myActivities2Object.get(eachActivitySet));
                if (eachBusyObject == this) continue;
                for (UiActivity eachOtherActivity : eachActivitySet) {
                    for (UiActivity eachToWatch : this.myToWatch) {
                        if (!eachToWatch.isSameOrGeneralFor(eachOtherActivity) || !eachBusyObject.myActivities.containsKey(eachOtherActivity)) continue;
                        infoToCheck.put(eachOtherActivity, eachBusyObject.myActivities.get(eachOtherActivity));
                    }
                }
            }
            infoToCheck.putAll(this.myActivities);
            if (infoToCheck.isEmpty()) {
                return true;
            }
            ModalityState current = UiActivityMonitorImpl.this.getCurrentState();
            for (Map.Entry entry : infoToCheck.entrySet()) {
                ActivityInfo info = (ActivityInfo)entry.getValue();
                if (current.dominates(info.getEffectiveState())) continue;
                return false;
            }
            return true;
        }

        public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
            if (activity == null) {
                BusyImpl.$$$reportNull$$$0(2);
            }
            if (effectiveModalityState == null) {
                BusyImpl.$$$reportNull$$$0(3);
            }
            if (!this.myToWatch.isEmpty() && !this.myToWatch.contains(activity)) {
                return;
            }
            this.myActivities.put(activity, new ActivityInfo(effectiveModalityState));
            this.myQueuedToRemove.remove(activity);
            this.myContainer.onActivityAdded(activity);
        }

        public void removeActivity(@NotNull UiActivity activity) {
            if (activity == null) {
                BusyImpl.$$$reportNull$$$0(4);
            }
            if (!this.myActivities.containsKey(activity)) {
                return;
            }
            this.myQueuedToRemove.add(activity);
            Runnable runnable2 = () -> {
                if (activity == null) {
                    BusyImpl.$$$reportNull$$$0(5);
                }
                if (!this.myQueuedToRemove.contains(activity)) {
                    return;
                }
                this.myQueuedToRemove.remove(activity);
                this.myActivities.remove(activity);
                this.myContainer.onActivityRemoved(this, activity);
                this.onReady();
            };
            SwingUtilities.invokeLater(runnable2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toWatch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectiveModalityState";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/UiActivityMonitorImpl$BusyImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addActivity";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeActivity";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$removeActivity$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ActivityInfo {
        private final ModalityState myEffectiveState;

        private ActivityInfo(@NotNull ModalityState effectiveState) {
            if (effectiveState == null) {
                ActivityInfo.$$$reportNull$$$0(0);
            }
            this.myEffectiveState = effectiveState;
        }

        @NotNull
        public ModalityState getEffectiveState() {
            ModalityState modalityState = this.myEffectiveState;
            if (modalityState == null) {
                ActivityInfo.$$$reportNull$$$0(1);
            }
            return modalityState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectiveState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/UiActivityMonitorImpl$ActivityInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/UiActivityMonitorImpl$ActivityInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

