/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirectoryPathMatcher {
    @NotNull
    private final GotoFileModel myModel;
    @Nullable
    private final List<Pair<VirtualFile, String>> myFiles;
    @NotNull
    private final String myPattern;

    private DirectoryPathMatcher(@NotNull GotoFileModel model, @Nullable List<Pair<VirtualFile, String>> files, @NotNull String pattern) {
        if (model == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myFiles = files;
        this.myPattern = pattern;
    }

    @Nullable
    static DirectoryPathMatcher root(@NotNull GotoFileModel model, @NotNull String pattern) {
        if (model == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(3);
        }
        DirectoryPathMatcher matcher = new DirectoryPathMatcher(model, null, "");
        for (int i = 0; i < pattern.length(); ++i) {
            if ((matcher = matcher.appendChar(pattern.charAt(i))) != null) continue;
            return null;
        }
        return matcher;
    }

    @Nullable
    DirectoryPathMatcher appendChar(char c) {
        String nextPattern = this.myPattern + c;
        if (c == '*' || c == '/' || c == ' ') {
            return new DirectoryPathMatcher(this.myModel, this.myFiles, nextPattern);
        }
        List<Pair<VirtualFile, String>> files = this.myFiles != null ? this.myFiles : DirectoryPathMatcher.getProjectRoots(this.myModel);
        ArrayList<Pair<VirtualFile, String>> nextRoots = new ArrayList<Pair<VirtualFile, String>>();
        MinusculeMatcher matcher = GotoFileItemProvider.getQualifiedNameMatcher(nextPattern);
        for (Pair<VirtualFile, String> pair : files) {
            if (DirectoryPathMatcher.containsChar((String)pair.second, c) && matcher.matches((String)pair.second)) {
                nextRoots.add(pair);
                continue;
            }
            this.processSubdirectoriesContaining((VirtualFile)pair.first, c, (Processor<VirtualFile>)((Processor)sub -> {
                String fullName = this.myModel.getFullName((VirtualFile)sub);
                if (fullName == null) {
                    return false;
                }
                if (matcher.matches(fullName = FileUtil.toSystemIndependentName((String)fullName))) {
                    nextRoots.add(Pair.create((Object)sub, (Object)fullName));
                    return true;
                }
                return false;
            }));
        }
        return nextRoots.isEmpty() ? null : new DirectoryPathMatcher(this.myModel, nextRoots, nextPattern);
    }

    @NotNull
    GlobalSearchScope narrowDown(@NotNull GlobalSearchScope fileSearchScope) {
        if (fileSearchScope == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(4);
        }
        if (this.myFiles == null) {
            GlobalSearchScope globalSearchScope = fileSearchScope;
            if (globalSearchScope == null) {
                DirectoryPathMatcher.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }
        VirtualFile[] array = (VirtualFile[])ContainerUtil.map2Array(this.myFiles, VirtualFile.class, p -> (VirtualFile)p.first);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)this.myModel.getProject(), (boolean)true, (VirtualFile[])array).intersectWith(fileSearchScope);
        if (globalSearchScope == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    private void processSubdirectoriesContaining(VirtualFile root, final char c, final Processor<VirtualFile> consumer) {
        final GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myModel.getProject());
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() || !scope.contains(file2)) {
                    return false;
                }
                String name = file2.getName();
                return !DirectoryPathMatcher.containsChar(name, c) || !consumer.process((Object)file2);
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).getCachedChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/actions/DirectoryPathMatcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean containsChar(String name, char c) {
        return StringUtil.indexOfIgnoreCase((String)name, (char)c, (int)0) >= 0;
    }

    @NotNull
    private static List<Pair<VirtualFile, String>> getProjectRoots(GotoFileModel model) {
        HashSet roots = new HashSet();
        for (Module module : ModuleManager.getInstance((Project)model.getProject()).getModules()) {
            Collections.addAll(roots, ModuleRootManager.getInstance((Module)module).getContentRoots());
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(entry instanceof LibraryOrSdkOrderEntry)) continue;
                Collections.addAll(roots, entry.getFiles(OrderRootType.CLASSES));
                Collections.addAll(roots, entry.getFiles(OrderRootType.SOURCES));
            }
        }
        List<Pair<VirtualFile, String>> list2 = roots.stream().map(root -> {
            VirtualFile top = model.getTopLevelRoot((VirtualFile)root);
            return top != null ? top : root;
        }).distinct().map(r -> Pair.create((Object)r, (Object)StringUtil.notNullize((String)model.getFullName((VirtualFile)r)))).collect(Collectors.toList());
        if (list2 == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSearchScope";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/DirectoryPathMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/DirectoryPathMatcher";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowDown";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "root";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "narrowDown";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

