/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.HeldDownKeyListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(final @NotNull AnActionEvent e) {
        if (e == null) {
            GotoActionAction.$$$reportNull$$$0(0);
        }
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        GotoActionModel model = new GotoActionModel(project, component, editor);
        GotoActionBase.GotoActionCallback<Object> callback = new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            public void elementChosen(@NotNull ChooseByNamePopup popup2, @NotNull Object element) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project != null) {
                    project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                }
                String enteredText = popup2.getTrimmedText();
                GotoActionAction.openOptionOrPerformAction(((GotoActionModel.MatchedValue)element).value, enteredText, project, component, e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "popup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/GotoActionAction$1";
                objectArray[2] = "elementChosen";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Pair<String, Integer> start = GotoActionAction.getInitialText(false, e);
        this.showNavigationPopup(callback, null, GotoActionAction.createPopup(project, model, (String)start.first, (Integer)start.second, component, e), false);
    }

    @NotNull
    private static ChooseByNamePopup createPopup(@Nullable Project project, final @NotNull GotoActionModel model, String initialText, int initialIndex, final Component component, final AnActionEvent event) {
        ChooseByNamePopup oldPopup;
        if (model == null) {
            GotoActionAction.$$$reportNull$$$0(1);
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project == null ? null : (ChooseByNamePopup)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        final Disposable disposable = Disposer.newDisposable();
        final ChooseByNamePopup popup2 = new ChooseByNamePopup(project, model, new GotoActionItemProvider(model), oldPopup, initialText, false, initialIndex){
            private boolean myPaintInternalInfo;

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                this.myList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        Object value = myList.getSelectedValue();
                        String text = this.getText(value);
                        if (text != null && myDropdownPopup != null) {
                            myDropdownPopup.setAdText(text, 2);
                        }
                        String description = this.getValueDescription(value);
                        ActionMenu.showDescriptionInStatusBar(true, myList, description);
                    }

                    @Nullable
                    private String getText(@Nullable Object o) {
                        if (o instanceof GotoActionModel.MatchedValue) {
                            GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)o;
                            if (myPaintInternalInfo && mv.value instanceof GotoActionModel.ActionWrapper) {
                                AnAction action = ((GotoActionModel.ActionWrapper)mv.value).getAction();
                                String actionId = ActionManager.getInstance().getId(action);
                                return StringUtil.notNullize((String)actionId, (String)("class: " + action.getClass().getName()));
                            }
                            if (mv.value instanceof BooleanOptionDescription || mv.value instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)mv.value).getAction() instanceof ToggleAction) {
                                return "Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0)) + " to toggle option";
                            }
                        }
                        return this.getAdText();
                    }
                });
                this.myList.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        int index = myList.locationToIndex(e.getPoint());
                        if (index == -1) {
                            return;
                        }
                        Object value = myList.getModel().getElementAt(index);
                        String description = this.getValueDescription(value);
                        ActionMenu.showDescriptionInStatusBar(true, myList, description);
                    }
                });
                if (Registry.is((String)"show.configurables.ids.in.settings")) {
                    new HeldDownKeyListener(){

                        protected void heldKeyTriggered(JComponent component, boolean pressed) {
                            myPaintInternalInfo = pressed;
                            ListSelectionEvent event = new ListSelectionEvent((Object)this, -1, -1, false);
                            for (ListSelectionListener listener2 : myList.getListSelectionListeners()) {
                                listener2.valueChanged(event);
                            }
                        }
                    }.installOn((JComponent)this.myTextField);
                }
            }

            @Nullable
            private String getValueDescription(@Nullable Object value) {
                if (value instanceof GotoActionModel.MatchedValue) {
                    GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)value;
                    if (mv.value instanceof GotoActionModel.ActionWrapper) {
                        AnAction action = ((GotoActionModel.ActionWrapper)mv.value).getAction();
                        return action.getTemplatePresentation().getDescription();
                    }
                }
                return null;
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    2.$$$reportNull$$$0(0);
                }
                Set<Object> set2 = super.filter(model.sortItems(elements));
                if (set2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set2;
            }

            @Override
            protected boolean closeForbidden(boolean ok) {
                if (!ok) {
                    return false;
                }
                Object element = this.getChosenElement();
                return element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, this, component, event) || super.closeForbidden(true);
            }

            @Override
            public void setDisposed(boolean disposedFlag) {
                super.setDisposed(disposedFlag);
                Disposer.dispose((Disposable)disposable);
                ActionMenu.showDescriptionInStatusBar(true, this.myList, null);
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    this.myList.removeListSelectionListener(listener2);
                }
                UIUtil.dispose((Component)this.myList);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/GotoActionAction$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/GotoActionAction$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "filter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "filter";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, (Disposable)new Disposable(){

            public void dispose() {
                if (!popup2.checkDisposed()) {
                    popup2.repaintList();
                }
            }
        }));
        if (project != null) {
            project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)popup2);
        }
        popup2.addMouseClickListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent me) {
                Object element;
                if (me == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((element = popup2.getSelectionByPoint(me.getPoint())) instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, popup2, component, event)) {
                    me.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/ide/actions/GotoActionAction$4", "mouseClicked"));
            }
        });
        ShortcutSet shortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions");
        DumbAwareAction.create(e -> {
            GotoActionModel.ActionWrapper aw;
            boolean available;
            Comparable value;
            Object o = popup2.getChosenElement();
            if (o instanceof GotoActionModel.MatchedValue && (value = ((GotoActionModel.MatchedValue)o).value) instanceof GotoActionModel.ActionWrapper && (available = (aw = (GotoActionModel.ActionWrapper)value).isAvailable())) {
                AnAction action = aw.getAction();
                String id = ActionManager.getInstance().getId(action);
                KeymapManagerImpl km = (KeymapManagerImpl)KeymapManager.getInstance();
                Keymap k = km.getActiveKeymap();
                if (k == null || !k.canModify()) {
                    return;
                }
                KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), k, component, new QuickList[0]);
                popup2.repaintListImmediate();
            }
        }).registerCustomShortcutSet(shortcutSet, (JComponent)popup2.getTextField(), disposable);
        ChooseByNamePopup chooseByNamePopup2 = popup2;
        if (chooseByNamePopup2 == null) {
            GotoActionAction.$$$reportNull$$$0(2);
        }
        return chooseByNamePopup2;
    }

    private static boolean processOptionInplace(Object value, ChooseByNamePopup popup2, Component component, AnActionEvent e) {
        AnAction action;
        if (value instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value).isOptionEnabled());
            GotoActionAction.repaint(popup2);
            return true;
        }
        if (value instanceof GotoActionModel.ActionWrapper && (action = ((GotoActionModel.ActionWrapper)value).getAction()) instanceof ToggleAction) {
            GotoActionAction.performAction(action, component, e, () -> GotoActionAction.repaint(popup2));
            return true;
        }
        return false;
    }

    private static void repaint(@Nullable ChooseByNamePopup popup2) {
        if (popup2 != null) {
            popup2.repaintListImmediate();
        }
    }

    public static void openOptionOrPerformAction(@NotNull Object element, String enteredText, @Nullable Project project, Component component, @Nullable AnActionEvent e) {
        if (element == null) {
            GotoActionAction.$$$reportNull$$$0(3);
        }
        if (element instanceof OptionDescription) {
            OptionDescription optionDescription = (OptionDescription)element;
            String configurableId = optionDescription.getConfigurableId();
            Project disposable = project != null ? project : ApplicationManager.getApplication();
            TransactionGuard guard = TransactionGuard.getInstance();
            if (optionDescription.hasExternalEditor()) {
                guard.submitTransactionLater((Disposable)disposable, () -> optionDescription.invokeInternalEditor());
            } else {
                guard.submitTransactionLater((Disposable)disposable, () -> ShowSettingsUtilImpl.showSettingsDialog(project, configurableId, enteredText));
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (element == null) {
                    GotoActionAction.$$$reportNull$$$0(4);
                }
                IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
                    if (element == null) {
                        GotoActionAction.$$$reportNull$$$0(5);
                    }
                    GotoActionAction.performAction(element, component, e);
                });
            });
        }
    }

    public static void performAction(Object element, @Nullable Component component, @Nullable AnActionEvent e) {
        GotoActionAction.performAction(element, component, e, null);
    }

    public static void performAction(Object element, @Nullable Component component, @Nullable AnActionEvent e, @Nullable Runnable callback) {
        if (component == null) {
            return;
        }
        AnAction action = element instanceof AnAction ? (AnAction)element : ((GotoActionModel.ActionWrapper)element).getAction();
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            DataManager instance;
            DataContext context;
            InputEvent inputEvent = e == null ? null : e.getInputEvent();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)inputEvent, (String)"GoToAction", (DataContext)(context = (instance = DataManager.getInstance()) != null ? instance.getDataContext(component) : DataContext.EMPTY_CONTEXT));
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                if (action instanceof ActionGroup && ((ActionGroup)action).getChildren(event).length > 0) {
                    ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(event.getPresentation().getText(), (ActionGroup)action, context, false, callback, -1);
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window != null) {
                        popup2.showInCenterOf((Component)window);
                    } else {
                        popup2.showInFocusCenter();
                    }
                } else {
                    ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                    if (callback != null) {
                        callback.run();
                    }
                }
            }
        });
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoActionAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoActionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "gotoActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openOptionOrPerformAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openOptionOrPerformAction$6";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

