/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleGroup {
    public static final DataKey<ModuleGroup[]> ARRAY_DATA_KEY = DataKey.create((String)"moduleGroup.array");
    private final List<String> myGroupPath;

    public ModuleGroup(@NotNull List<String> groupPath) {
        if (groupPath == null) {
            ModuleGroup.$$$reportNull$$$0(0);
        }
        this.myGroupPath = groupPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroup)) {
            return false;
        }
        return this.myGroupPath.equals(((ModuleGroup)o).myGroupPath);
    }

    public int hashCode() {
        return this.myGroupPath.hashCode();
    }

    public String[] getGroupPath() {
        return ArrayUtil.toStringArray(this.myGroupPath);
    }

    public List<String> getGroupPathList() {
        return this.myGroupPath;
    }

    @NotNull
    public Collection<Module> modulesInGroup(Project project, boolean recursively) {
        Collection<Module> collection = this.modulesInGroup(ModuleGrouper.instanceFor((Project)project), recursively);
        if (collection == null) {
            ModuleGroup.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<Module> modulesInGroup(ModuleGrouper grouper, boolean recursively) {
        ArrayList<Module> result2 = new ArrayList<Module>();
        Set moduleAsGroupsPaths = ContainerUtil.map2Set((Object[])grouper.getAllModules(), module -> grouper.getModuleAsGroupPath(module));
        for (Module module2 : grouper.getAllModules()) {
            List group = grouper.getGroupPath(module2);
            if (!this.myGroupPath.equals(group) && (!ModuleGroup.isChild(this.myGroupPath, group) || !recursively && !ModuleGroup.isUnderGroupWithSameNameAsSomeModule(this.myGroupPath, group, moduleAsGroupsPaths))) continue;
            result2.add(module2);
        }
        ArrayList<Module> arrayList = result2;
        if (arrayList == null) {
            ModuleGroup.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isUnderGroupWithSameNameAsSomeModule(List<String> parent, List<String> descendant, Set<List<String>> moduleNamesAsGroups) {
        return descendant.size() > parent.size() && moduleNamesAsGroups.contains(descendant.subList(0, parent.size() + 1));
    }

    @NotNull
    public Collection<ModuleGroup> childGroups(ModuleGrouper grouper) {
        THashSet result2 = new THashSet();
        Set moduleAsGroupsPaths = ContainerUtil.map2Set((Object[])grouper.getAllModules(), module -> grouper.getModuleAsGroupPath(module));
        for (Module module2 : grouper.getAllModules()) {
            List directChild;
            List group = grouper.getGroupPath(module2);
            if (!ModuleGroup.isChild(this.myGroupPath, group) || moduleAsGroupsPaths.contains(directChild = ContainerUtil.append(this.myGroupPath, (Object[])new String[]{(String)group.get(this.myGroupPath.size())}))) continue;
            result2.add(new ModuleGroup(directChild));
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            ModuleGroup.$$$reportNull$$$0(3);
        }
        return tHashSet;
    }

    private static boolean isChild(List<String> parent, List<String> descendant) {
        return descendant.size() > parent.size() && descendant.subList(0, parent.size()).equals(parent);
    }

    public String presentableText() {
        return "'" + this.myGroupPath.get(this.myGroupPath.size() - 1) + "'";
    }

    public String toString() {
        return this.myGroupPath.get(this.myGroupPath.size() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ModuleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ModuleGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modulesInGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "childGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

