/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.todo.SetTodoFilterAction;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoCompositeRenderer;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.VisibilityWatcher;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TodoPanel
extends SimpleToolWindowPanel
implements OccurenceNavigator,
DataProvider,
Disposable {
    protected static final Logger LOG = Logger.getInstance(TodoPanel.class);
    protected Project myProject;
    private final TodoPanelSettings mySettings;
    private final boolean myCurrentFileMode;
    private final Content myContent;
    private final Tree myTree;
    private final MyTreeExpander myTreeExpander;
    private final MyOccurenceNavigator myOccurenceNavigator;
    protected final TodoTreeBuilder myTodoTreeBuilder;
    private MyVisibilityWatcher myVisibilityWatcher;
    private UsagePreviewPanel myUsagePreviewPanel;

    TodoPanel(Project project, TodoPanelSettings settings, boolean currentFileMode, Content content) {
        super(false, true);
        this.myProject = project;
        this.mySettings = settings;
        this.myCurrentFileMode = currentFileMode;
        this.myContent = content;
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        this.myTreeExpander = new MyTreeExpander();
        this.myOccurenceNavigator = new MyOccurenceNavigator();
        this.initUI();
        this.myTodoTreeBuilder = this.createTreeBuilder((JTree)this.myTree, model, this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myTodoTreeBuilder);
        this.updateTodoFilter();
        this.myTodoTreeBuilder.setShowPackages(this.mySettings.arePackagesShown);
        this.myTodoTreeBuilder.setShowModules(this.mySettings.areModulesShown);
        this.myTodoTreeBuilder.setFlattenPackages(this.mySettings.areFlattenPackages);
        this.myVisibilityWatcher = new MyVisibilityWatcher();
        this.myVisibilityWatcher.install((Component)((Object)this));
    }

    protected abstract TodoTreeBuilder createTreeBuilder(JTree var1, DefaultTreeModel var2, Project var3);

    private void initUI() {
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new TodoCompositeRenderer());
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("EditSource"));
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("VersionControlsGroup"));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)group, (String)"TodoViewPopup", (ActionManager)ActionManager.getInstance());
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!e.isConsumed() && 10 == e.getKeyCode()) {
                    TreePath path = TodoPanel.this.myTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!((userObject instanceof NodeDescriptor ? (NodeDescriptor)userObject : null) instanceof TodoItemNode)) {
                        return;
                    }
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)TodoPanel.this)), (boolean)false);
                }
            }
        });
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, FindInProjectUtil.setupViewPresentation(false, new FindModel()));
        Disposer.register((Disposable)this, (Disposable)this.myUsagePreviewPanel);
        this.myUsagePreviewPanel.setVisible(this.mySettings.showPreview);
        this.setContent(this.createCenterComponent());
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (TodoPanel.this.myUsagePreviewPanel.isVisible()) {
                        TodoPanel.this.updatePreviewPanel();
                    }
                }, ModalityState.NON_MODAL, TodoPanel.this.myProject.getDisposed());
            }
        });
        JPanel toolBarPanel = new JPanel(new GridLayout());
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        leftGroup.add((AnAction)new PreviousOccurenceToolbarAction(this.myOccurenceNavigator));
        leftGroup.add((AnAction)new NextOccurenceToolbarAction(this.myOccurenceNavigator));
        toolBarPanel.add(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)leftGroup, false).getComponent());
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this));
        rightGroup.add(expandAllAction);
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this));
        rightGroup.add(collapseAllAction);
        if (!this.myCurrentFileMode) {
            MyShowModulesAction showModulesAction = new MyShowModulesAction();
            showModulesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(77, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
            rightGroup.add((AnAction)showModulesAction);
            MyShowPackagesAction showPackagesAction = new MyShowPackagesAction();
            showPackagesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
            rightGroup.add((AnAction)showPackagesAction);
            MyFlattenPackagesAction flattenPackagesAction = new MyFlattenPackagesAction();
            flattenPackagesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(70, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
            rightGroup.add((AnAction)flattenPackagesAction);
        }
        MyAutoScrollToSourceHandler autoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        autoScrollToSourceHandler.install((JTree)this.myTree);
        rightGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
        SetTodoFilterAction setTodoFilterAction = new SetTodoFilterAction(this.myProject, this.mySettings, (Consumer<TodoFilter>)((Consumer)todoFilter -> this.setTodoFilter((TodoFilter)todoFilter)));
        rightGroup.add((AnAction)setTodoFilterAction);
        rightGroup.add((AnAction)new MyPreviewAction());
        toolBarPanel.add(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)rightGroup, false).getComponent());
        this.setToolbar(toolBarPanel);
    }

    protected JComponent createCenterComponent() {
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
        return splitter;
    }

    private void updatePreviewPanel() {
        Object element;
        TodoItemNode pointer;
        DefaultMutableTreeNode node;
        Object userObject;
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>();
        TreePath path = this.myTree.getSelectionPath();
        if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof NodeDescriptor && (pointer = this.myTodoTreeBuilder.getFirstPointerForElement(element = ((NodeDescriptor)userObject).getElement())) != null) {
            SmartTodoItemPointer value = (SmartTodoItemPointer)pointer.getValue();
            Document document = value.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            RangeMarker rangeMarker = value.getRangeMarker();
            if (psiFile != null) {
                infos.add(new UsageInfo((PsiElement)psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
            }
        }
        this.myUsagePreviewPanel.updateLayout(infos.isEmpty() ? null : infos);
    }

    public void dispose() {
        if (this.myVisibilityWatcher != null) {
            this.myVisibilityWatcher.deinstall((Component)((Object)this));
            this.myVisibilityWatcher = null;
        }
        this.myProject = null;
    }

    void rebuildCache() {
        this.myTodoTreeBuilder.rebuildCache();
    }

    void updateTree() {
        this.myTodoTreeBuilder.updateTree(false);
    }

    void updateTodoFilter() {
        TodoFilter filter2 = TodoConfiguration.getInstance().getTodoFilter(this.mySettings.todoFilterName);
        this.setTodoFilter(filter2);
    }

    private void setTodoFilter(TodoFilter filter2) {
        String filterName;
        this.mySettings.todoFilterName = filterName = filter2 != null ? filter2.getName() : null;
        this.myTodoTreeBuilder.setTodoFilter(filter2);
        this.myContent.setDescription(filterName);
    }

    @Nullable
    protected PsiFile getSelectedFile() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        LOG.assertTrue(node != null);
        if (node.getUserObject() == null) {
            return null;
        }
        return TodoTreeBuilder.getFileForNode(node);
    }

    protected void setDisplayName(String tabName) {
        this.myContent.setDisplayName(tabName);
    }

    @Nullable
    private PsiElement getSelectedElement() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        PsiElement selectedElement = TodoTreeHelper.getInstance(this.myProject).getSelectedElement(userObject);
        if (selectedElement != null) {
            return selectedElement;
        }
        return this.getSelectedFile();
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            TreePath path = this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element = ((NodeDescriptor)userObject).getElement();
            if (!(element instanceof TodoFileNode) && !(element instanceof TodoItemNode)) {
                return null;
            }
            TodoItemNode pointer = this.myTodoTreeBuilder.getFirstPointerForElement(element);
            if (pointer != null) {
                return new OpenFileDescriptor(this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset());
            }
            return null;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            PsiFile file2 = this.getSelectedFile();
            return file2 != null ? file2.getVirtualFile() : null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getSelectedElement();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            PsiFile file3 = this.getSelectedFile();
            if (file3 != null) {
                return new VirtualFile[]{file3.getVirtualFile()};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "find.todoList";
        }
        return super.getData(dataId);
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator.getNextOccurenceActionName();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator.getPreviousOccurenceActionName();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    protected void rebuildWithAlarm(Alarm alarm) {
        alarm.cancelAllRequests();
        alarm.addRequest(() -> {
            HashSet files = new HashSet();
            DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
                if (this.myTodoTreeBuilder.isDisposed()) {
                    return;
                }
                this.myTodoTreeBuilder.collectFiles((Processor<VirtualFile>)((Processor)virtualFile -> {
                    files.add(virtualFile);
                    return true;
                }));
                Runnable runnable2 = () -> {
                    if (this.myTodoTreeBuilder.isDisposed()) {
                        return;
                    }
                    this.myTodoTreeBuilder.rebuildCache(files);
                    this.updateTree();
                };
                ApplicationManager.getApplication().invokeLater(runnable2);
            });
        }, 300);
    }

    private final class MyPreviewAction
    extends ToggleAction {
        MyPreviewAction() {
            super("Preview Source", null, AllIcons.Actions.PreviewDetails);
        }

        public void update(AnActionEvent e) {
            super.update(e);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((TodoPanel)TodoPanel.this).mySettings.showPreview;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((TodoPanel)TodoPanel.this).mySettings.showPreview = state;
            TodoPanel.this.myUsagePreviewPanel.setVisible(state);
            if (state) {
                TodoPanel.this.updatePreviewPanel();
            }
        }
    }

    private final class MyVisibilityWatcher
    extends VisibilityWatcher {
        private MyVisibilityWatcher() {
        }

        @Override
        public void visibilityChanged() {
            if (TodoPanel.this.myProject.isOpen()) {
                PsiDocumentManager.getInstance((Project)TodoPanel.this.myProject).performWhenAllCommitted(() -> TodoPanel.this.myTodoTreeBuilder.setUpdatable(TodoPanel.this.isShowing()));
            }
        }
    }

    private final class MyFlattenPackagesAction
    extends ToggleAction {
        MyFlattenPackagesAction() {
            super(IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), null, PlatformIcons.FLATTEN_PACKAGES_ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(((TodoPanel)TodoPanel.this).mySettings.arePackagesShown);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((TodoPanel)TodoPanel.this).mySettings.areFlattenPackages;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((TodoPanel)TodoPanel.this).mySettings.areFlattenPackages = state;
            TodoPanel.this.myTodoTreeBuilder.setFlattenPackages(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoPanel$MyFlattenPackagesAction", "update"));
        }
    }

    private final class MyShowModulesAction
    extends ToggleAction {
        MyShowModulesAction() {
            super(IdeBundle.message((String)"action.group.by.modules", (Object[])new Object[0]), null, AllIcons.ObjectBrowser.ShowModules);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((TodoPanel)TodoPanel.this).mySettings.areModulesShown;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((TodoPanel)TodoPanel.this).mySettings.areModulesShown = state;
            TodoPanel.this.myTodoTreeBuilder.setShowModules(state);
        }
    }

    private final class MyShowPackagesAction
    extends ToggleAction {
        MyShowPackagesAction() {
            super(IdeBundle.message((String)"action.group.by.packages", (Object[])new Object[0]), null, PlatformIcons.GROUP_BY_PACKAGES);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((TodoPanel)TodoPanel.this).mySettings.arePackagesShown;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((TodoPanel)TodoPanel.this).mySettings.arePackagesShown = state;
            TodoPanel.this.myTodoTreeBuilder.setShowPackages(state);
        }
    }

    private final class MyOccurenceNavigator
    implements OccurenceNavigator {
        private MyOccurenceNavigator() {
        }

        public boolean hasNextOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return false;
            }
            if (userObject instanceof NodeDescriptor && ((NodeDescriptor)userObject).getElement() instanceof TodoItemNode) {
                return TodoPanel.this.myTree.getRowCount() != TodoPanel.this.myTree.getRowForPath(path) + 1;
            }
            return node.getChildCount() > 0;
        }

        public boolean hasPreviousOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            return userObject instanceof NodeDescriptor && !this.isFirst(node);
        }

        private boolean isFirst(TreeNode node) {
            TreeNode parent = node.getParent();
            return parent == null || parent.getIndex(node) == 0 && this.isFirst(parent);
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.goToPointer(this.getNextPointer());
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.goToPointer(this.getPreviousPointer());
        }

        public String getNextOccurenceActionName() {
            return IdeBundle.message((String)"action.next.todo", (Object[])new Object[0]);
        }

        public String getPreviousOccurenceActionName() {
            return IdeBundle.message((String)"action.previous.todo", (Object[])new Object[0]);
        }

        @Nullable
        private OccurenceNavigator.OccurenceInfo goToPointer(TodoItemNode pointer) {
            if (pointer == null) {
                return null;
            }
            TodoPanel.this.myTodoTreeBuilder.select(pointer);
            return new OccurenceNavigator.OccurenceInfo((Navigatable)new OpenFileDescriptor(TodoPanel.this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset()), -1, -1);
        }

        @Nullable
        private TodoItemNode getNextPointer() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element = ((NodeDescriptor)userObject).getElement();
            TodoItemNode pointer = element instanceof TodoItemNode ? TodoPanel.this.myTodoTreeBuilder.getNextPointer((TodoItemNode)element) : TodoPanel.this.myTodoTreeBuilder.getFirstPointerForElement(element);
            return pointer;
        }

        @Nullable
        private TodoItemNode getPreviousPointer() {
            TodoItemNode pointer;
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element = ((NodeDescriptor)userObject).getElement();
            if (element instanceof TodoItemNode) {
                pointer = TodoPanel.this.myTodoTreeBuilder.getPreviousPointer((TodoItemNode)element);
            } else {
                Object sibling = TodoPanel.this.myTodoTreeBuilder.getPreviousSibling(element);
                if (sibling == null) {
                    return null;
                }
                pointer = TodoPanel.this.myTodoTreeBuilder.getLastPointerForElement(sibling);
            }
            return pointer;
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        MyAutoScrollToSourceHandler() {
        }

        protected boolean isAutoScrollMode() {
            return ((TodoPanel)TodoPanel.this).mySettings.isAutoScrollToSource;
        }

        protected void setAutoScrollMode(boolean state) {
            ((TodoPanel)TodoPanel.this).mySettings.isAutoScrollToSource = state;
        }
    }

    private final class MyTreeExpander
    implements TreeExpander {
        private MyTreeExpander() {
        }

        public boolean canCollapse() {
            return true;
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TodoPanel.this.myTodoTreeBuilder.collapseAll();
        }

        public void expandAll() {
            TodoPanel.this.myTodoTreeBuilder.expandAll(null);
        }
    }
}

