/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    private Rectangle viewRect = new Rectangle();
    private Rectangle textRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    public static boolean isComboButton(JComponent c) {
        return c instanceof AbstractButton && c.getClientProperty("styleCombo") == Boolean.TRUE;
    }

    public static boolean isHelpButton(JComponent button) {
        return button instanceof JButton && "help".equals(button.getClientProperty("JButton.buttonType"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (DarculaButtonUI.isHelpButton(c)) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
            int off = JBUI.scale((int)22);
            int x = (w - off) / 2;
            int y = (h - off) / 2;
            g.fillOval(x, y, off, off);
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
            return false;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            if (c.isEnabled()) {
                if (DarculaButtonUI.isSquare(c)) {
                    Rectangle r = new Rectangle(w, h);
                    g2.translate(r.x, r.y);
                    g2.setPaint(UIUtil.getGradientPaint((float)r.x, (float)r.y, (Color)this.getButtonColor1(), (float)(r.x + r.width), (float)(r.y + r.height), (Color)this.getButtonColor2()));
                    float arc = JBUI.scale((float)2.0f);
                    float bw = DarculaUIUtil.bw();
                    g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
                } else {
                    g2.setPaint(DarculaButtonUI.isDefaultButton(c) ? UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getSelectedButtonColor1(), (float)0.0f, (float)h, (Color)this.getSelectedButtonColor2()) : UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
                    Insets ins = c.getInsets();
                    int yOff = (ins.top + ins.bottom) / 4;
                    int rad = JBUI.scale((int)5);
                    g2.fillRoundRect(JBUI.scale((int)4), yOff, w - 2 * JBUI.scale((int)4), h - 2 * yOff, rad, rad);
                }
            }
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.paintDecorations((Graphics2D)g, c)) {
            super.paint(g, c);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        int mnemonicIndex;
        Color selectedFg;
        if (DarculaButtonUI.isHelpButton(c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color fg = button.getForeground();
        if (fg instanceof UIResource && DarculaButtonUI.isDefaultButton(button) && (selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        g.setColor(fg);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            this.paintDisabledText(g, text, c, textRect, metrics);
        }
    }

    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.darcula.disabledText.shadow"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset() + 1, textRect.y + metrics.getAscent() + this.getTextShiftOffset() + 1);
        g.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }

    protected void paintContents(Graphics g, AbstractButton b) {
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)b, g);
        boolean isDotButton = DarculaButtonUI.isSquare(b) && b.getIcon() == AllIcons.General.Ellipsis;
        String text = isDotButton ? "..." : b.getText();
        Icon icon = isDotButton ? null : b.getIcon();
        text = this.layout(b, text, icon, fm, b.getWidth(), b.getHeight());
        if (DarculaButtonUI.isSquare(b)) {
            if (b.getIcon() == AllIcons.General.Ellipsis) {
                UISettings.setupAntialiasing((Graphics)g);
                this.paintText(g, b, this.textRect, text);
            } else if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
        } else {
            if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
            if (text != null && !text.isEmpty()) {
                View v = (View)b.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g);
                    this.paintText(g, b, this.textRect, text);
                }
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (DarculaButtonUI.isDefaultButton(c)) {
            this.setupDefaultButton((JButton)c);
        }
    }

    protected void setupDefaultButton(JButton button) {
        if (!SystemInfo.isMac && !button.getFont().isBold()) {
            button.setFont(new FontUIResource(button.getFont().deriveFont(1)));
        }
    }

    protected Color getButtonColor1() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.color1"), (Object)new ColorUIResource(0x555A5C));
    }

    protected Color getButtonColor2() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.color2"), (Object)new ColorUIResource(4277832));
    }

    protected Color getSelectedButtonColor1() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.selection.color1"), (Object)new ColorUIResource(3690347));
    }

    protected Color getSelectedButtonColor2() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.selection.color2"), (Object)new ColorUIResource(2306371));
    }

    protected String layout(AbstractButton b, String text, Icon icon, FontMetrics fm, int width, int height) {
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.viewRect.setBounds(0, 0, width, height);
        this.modifyViewRect(b, this.viewRect);
        return SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, text == null ? 0 : b.getIconTextGap());
    }

    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        if (DarculaButtonUI.isComboButton(b)) {
            rect.x += 6;
        } else if (b instanceof JBOptionButton) {
            rect.x -= 4;
        }
    }
}

