/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource,
ErrorBorderCapable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(x, y);
            float lw = DarculaUIUtil.lw(g2);
            float bw = DarculaUIUtil.bw();
            float arc = DarculaUIUtil.arc();
            Path2D.Float border = new Path2D.Float(0);
            border.append(new RoundRectangle2D.Float(bw, bw, (float)width - bw * 2.0f, (float)height - bw * 2.0f, arc, arc), false);
            border.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f, arc, arc), false);
            g2.setColor(DarculaUIUtil.getOutlineColor(c.isEnabled()));
            g2.fill(border);
            Object op = ((JComponent)c).getClientProperty("JComponent.outline");
            if (op != null) {
                DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, true, DarculaSpinnerBorder.isFocused(c), DarculaUIUtil.Outline.valueOf(op.toString()));
            } else if (DarculaSpinnerBorder.isFocused(c)) {
                DarculaUIUtil.paintFocusBorder(g2, width, height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)3, (int)8, (int)3, (int)3).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFocused(Component c) {
        JSpinner spinner;
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof JSpinner && (spinner = (JSpinner)c).getEditor() != null) {
            Object object = spinner.getEditor().getTreeLock();
            synchronized (object) {
                return spinner.getEditor().getComponent(0).hasFocus();
            }
        }
        return false;
    }
}

