/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.intellij.MacIntelliJComboBoxUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MacComboBoxBorder
extends MacIntelliJTextBorder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(x, y);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            Shape clip = g2.getClip();
            Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
            area.subtract(this.getButtonBounds(c));
            area.intersect(new Area(clip));
            g2.setClip(area);
            float arc = this.isRound(c) ? JBUI.scale((float)6.0f) : 0.0f;
            Insets i = ((JComponent)c).getInsets();
            if (c instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)c;
                ComboBoxEditor cbe = comboBox.getEditor();
                Color background = comboBox.isEditable() ? cbe.getEditorComponent().getBackground() : UIManager.getColor(comboBox.isEnabled() ? "ComboBox.background" : "ComboBox.disabledBackground");
                g2.setColor(background);
                if (comboBox.isEditable()) {
                    Rectangle2D.Double shape = new Rectangle2D.Double(i.left, i.top, width - (i.left + i.right), height - (i.top + i.bottom));
                    g2.fill(shape);
                } else {
                    Path2D.Float path = new Path2D.Float(0);
                    ((Path2D)path).moveTo((float)i.left + MacIntelliJComboBoxUI.VALUE_OFFSET, i.top);
                    ((Path2D)path).lineTo((float)i.left + MacIntelliJComboBoxUI.VALUE_OFFSET, height - i.bottom);
                    ((Path2D)path).lineTo((float)i.left + arc, height - i.bottom);
                    ((Path2D)path).quadTo(i.left, height - i.bottom, i.left, (float)height - arc - (float)i.bottom);
                    ((Path2D)path).lineTo(i.left, arc + (float)i.top);
                    ((Path2D)path).quadTo(i.left, i.top, arc + (float)i.left, i.top);
                    path.closePath();
                    g2.fill(path);
                }
            }
            Path2D.Float border = new Path2D.Float(0);
            float lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
            border.append(new RoundRectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), width - JBUI.scale((int)3) * 2, height - JBUI.scale((int)3) * 2, arc, arc), false);
            float innerArc = JBUI.scale((float)(arc > 0.0f ? arc - lw : 0.0f));
            border.append(new RoundRectangle2D.Double((float)JBUI.scale((int)3) + lw, (float)JBUI.scale((int)3) + lw, (float)width - ((float)JBUI.scale((int)3) + lw) * 2.0f, (float)height - ((float)JBUI.scale((int)3) + lw) * 2.0f, innerArc, innerArc), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(border);
            g2.setClip(clip);
            this.paint(c, g2, width, height, arc);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)3).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    protected boolean isFocused(Component c) {
        if (c instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c;
            if (!comboBox.isEnabled()) {
                return false;
            }
            if (comboBox.isEditable()) {
                ComboBoxEditor ed = comboBox.getEditor();
                Component editorComponent = ed.getEditorComponent();
                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                return focused != null && editorComponent != null && SwingUtilities.isDescendingFrom(focused, editorComponent);
            }
            return comboBox.hasFocus();
        }
        return false;
    }

    Area getButtonBounds(Component c) {
        Rectangle bounds = null;
        if (c instanceof JComboBox && ((JComboBox)c).getUI() instanceof MacIntelliJComboBoxUI) {
            MacIntelliJComboBoxUI ui = (MacIntelliJComboBoxUI)((JComboBox)c).getUI();
            bounds = ui.getArrowButtonBounds();
        }
        return bounds != null ? new Area(bounds) : new Area();
    }

    boolean isRound(Component c) {
        return c instanceof JComboBox && !((JComboBox)c).isEditable();
    }

    @Override
    protected void clipForBorder(Component c, Graphics2D g2, int width, int height) {
        float lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        RectangularShape innerShape = this.isRound(c) ? new RoundRectangle2D.Float((float)JBUI.scale((int)3) + lw, (float)JBUI.scale((int)3) + lw, (float)width - ((float)JBUI.scale((int)3) + lw) * 2.0f, (float)height - ((float)JBUI.scale((int)3) + lw) * 2.0f, (float)JBUI.scale((int)3) + lw, (float)JBUI.scale((int)3) + lw) : new Rectangle2D.Float((float)JBUI.scale((int)3) + lw, (float)JBUI.scale((int)3) + lw, (float)width - ((float)JBUI.scale((int)3) + lw) * 2.0f, (float)height - ((float)JBUI.scale((int)3) + lw) * 2.0f);
        area.subtract(new Area(innerShape));
        area.add(this.getButtonBounds(c));
        Area clip = new Area(g2.getClip());
        area.intersect(clip);
        g2.setClip(area);
    }

    @Override
    protected boolean isSymmetric() {
        return false;
    }
}

