/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class MacIntelliJTextBorder
extends DarculaTextBorder {
    private static final Color OUTLINE_COLOR = Gray.xBC;

    private static float lwImpl(Graphics2D g2) {
        return JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
    }

    private static float bwImpl() {
        return JBUI.scale((int)3);
    }

    @Override
    protected float lw(Graphics2D g2) {
        return MacIntelliJTextBorder.lwImpl(g2);
    }

    @Override
    protected float bw() {
        return MacIntelliJTextBorder.bwImpl();
    }

    @Override
    protected Color getOutlineColor(boolean enabled) {
        return OUTLINE_COLOR;
    }

    @Override
    protected void paintSearchArea(Graphics2D g, Rectangle r, JTextComponent c, boolean fillBackground) {
        MacIntelliJTextBorder.paintMacSearchArea(g, r, c, fillBackground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintMacSearchArea(Graphics2D g, Rectangle r, JTextComponent c, boolean fillBackground) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = JBUI.scale((int)6);
            float lw = MacIntelliJTextBorder.lwImpl(g2);
            float bw = MacIntelliJTextBorder.bwImpl();
            RoundRectangle2D.Float outerShape = new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
            if (fillBackground) {
                g2.setColor(c.getBackground());
                g2.fill(outerShape);
            }
            Path2D.Float path = new Path2D.Float(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
            g2.setColor(OUTLINE_COLOR);
            g2.fill(path);
            if (c.hasFocus()) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c instanceof JTextField && c.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        JBInsets.JBInsetsUIResource insets = JBUI.insets((int)5, (int)8).asUIResource();
        TextFieldWithPopupHandlerUI.updateBorderInsets(c, (Insets)insets);
        return insets;
    }
}

