/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.SwingUtilities2;

public class WinIntelliJButtonUI
extends DarculaButtonUI {
    static final float DISABLED_ALPHA_LEVEL = 0.47f;
    private PropertyChangeListener helpButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton && DarculaButtonUI.isHelpButton((JComponent)source)) {
                ((AbstractButton)source).setOpaque(false);
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        ((AbstractButton)c).setRolloverEnabled(true);
        return new WinIntelliJButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("JButton.buttonType", this.helpButtonListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener("JButton.buttonType", this.helpButtonListener);
        super.uninstallListeners(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (WinIntelliJButtonUI.isHelpButton(c)) {
            Icon help = MacIntelliJIconCache.getIcon("winHelp");
            Insets i = c.getInsets();
            help.paintIcon(c, g, i.left, i.top + (c.getHeight() - help.getIconHeight()) / 2);
        } else if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel bm = b.getModel();
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Color color;
                Rectangle r = new Rectangle(c.getSize());
                Container parent = c.getParent();
                if (c.isOpaque() && parent != null) {
                    g2.setColor(parent.getBackground());
                    g2.fill(r);
                }
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2));
                if (UIUtil.getParentOfType(ActionToolbar.class, (Component)c) != null) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insetsRight((int)3));
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                Color color2 = bm.isPressed() ? UIManager.getColor("Button.intellij.native.pressedBackgroundColor") : (color = c.hasFocus() || bm.isRollover() ? UIManager.getColor("Button.intellij.native.focusedBackgroundColor") : c.getBackground());
                if (!b.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                g2.setColor(color);
                g2.fill(r);
                this.paintContents(g2, b);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        if (!WinIntelliJButtonUI.isComboButton(b)) {
            JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        }
        if (WinIntelliJButtonUI.isComboButton(b)) {
            int delta = JBUI.scale((int)6);
            rect.x += delta;
            rect.width -= delta;
        } else if (b instanceof JBOptionButton) {
            rect.x -= JBUI.scale((int)4);
        }
        rect.y -= JBUI.scale((int)1);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (WinIntelliJButtonUI.isHelpButton(c)) {
            Icon icon = MacIntelliJIconCache.getIcon("winHelp");
            Insets i = c.getInsets();
            return new Dimension(icon.getIconWidth() + i.left + i.right, JBUI.scale((int)24));
        }
        if (WinIntelliJButtonUI.isSquare(c)) {
            return new JBDimension(24, 24);
        }
        return super.getPreferredSize(c);
    }

    @Override
    protected void setupDefaultButton(JButton button) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(UIManager.getColor("Button.disabledText"));
            SwingUtilities2.drawStringUnderlineCharAt(c, g2, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        }
        finally {
            g2.dispose();
        }
    }
}

