/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.FieldAccessor;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.IconsLoadTime");
    private static final boolean IS_INTERNAL_MODE = Boolean.valueOf(System.getProperty("idea.is.internal"));
    private static final int STATS_LIMIT = 10000;
    private static final int FIXED_SCOPE = 100;
    private static final List<Integer> stats;

    public void actionPerformed(AnActionEvent e) {
        IconsLoadTime.log(false);
    }

    private static void log(boolean measureStartupLoad) {
        if (stats == null || stats.isEmpty()) {
            return;
        }
        int size = stats.size();
        long sum = stats.stream().mapToInt(Integer::intValue).sum();
        long average = sum / (long)size;
        long median = size % 2 == 0 ? (long)(stats.get(size / 2 - 1) + stats.get(size / 2)) : (long)stats.get(size / 2).intValue();
        Function<Long, String> ms = nano -> String.format("%.02fms", Float.valueOf((float)nano.longValue() / 1000000.0f));
        LOG.info((Registry.is((String)"ide.svg.icon") ? "SVG" : "PNG") + " load time: " + (measureStartupLoad ? "ide_startup=" : "total=") + ms.apply(sum) + ", average=" + ms.apply(average) + ", median=" + ms.apply(median) + "; number of icons: " + size);
    }

    private static Image measure(ImageLoader.LoadFunction func) throws IOException {
        boolean measure = stats.size() < 10000;
        long t = measure ? System.nanoTime() : 0L;
        Image img = func.load(null);
        if (measure) {
            stats.add((int)(System.nanoTime() - t));
            if (stats.size() == 100) {
                IconsLoadTime.log(false);
            }
        }
        return img;
    }

    static {
        List<Object> list2 = stats = IS_INTERNAL_MODE ? Collections.synchronizedList(new LinkedList()) : null;
        if (IS_INTERNAL_MODE) {
            new FieldAccessor(ImageLoader.class, "measureLoad").set(null, func -> IconsLoadTime.measure(Objects.requireNonNull(func)));
        }
    }

    public static class StartupLoadTime
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                StartupLoadTime.$$$reportNull$$$0(0);
            }
            if (IS_INTERNAL_MODE) {
                IconsLoadTime.log(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/IconsLoadTime$StartupLoadTime", "runActivity"));
        }
    }
}

