/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.beans;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class ConvertUsagesUtil {
    static final char GROUP_SEPARATOR = ':';
    static final char GROUPS_SEPARATOR = ';';
    static final char GROUP_VALUE_SEPARATOR = ',';

    private ConvertUsagesUtil() {
    }

    public static <T extends UsageDescriptor> String convertUsages(Map<GroupDescriptor, Set<T>> map) {
        assert (map != null);
        Map<GroupDescriptor, Set<T>> sortedMap = ConvertUsagesUtil.sortDescriptorsByPriority(map);
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<GroupDescriptor, Set<T>> entry : sortedMap.entrySet()) {
            String value = ConvertUsagesUtil.convertValueMap(entry.getValue());
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            buffer.append(entry.getKey().getId());
            buffer.append(':');
            buffer.append(value);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public static String convertValueMap(Set<? extends UsageDescriptor> descriptors) {
        assert (descriptors != null);
        if (descriptors.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (UsageDescriptor usageDescriptor : descriptors) {
            int value = usageDescriptor.getValue();
            if (value == 0) continue;
            buffer.append(usageDescriptor.getKey());
            buffer.append("=");
            buffer.append(value);
            buffer.append(',');
        }
        if (buffer.length() == 0) {
            return "";
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String cutDataString(String patchStr, int maxSize) {
        assert (patchStr != null);
        for (int i = maxSize - 1; i >= 0; --i) {
            char c = patchStr.charAt(i);
            if (c != ';' && c != ',') continue;
            return patchStr.substring(0, i);
        }
        return "";
    }

    public static Map<GroupDescriptor, Set<UsageDescriptor>> convertString(String usages) {
        assert (usages != null);
        HashMap<GroupDescriptor, Set<UsageDescriptor>> descriptors = new HashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (String groupStr : usages.split(Character.toString(';'))) {
            StringPair group;
            if (ConvertUsagesUtil.isEmptyOrSpaces(groupStr) || (group = ConvertUsagesUtil.getPair(groupStr, Character.toString(':'))) == null) continue;
            String groupId = group.first;
            assert (groupId != null);
            descriptors.putAll(ConvertUsagesUtil.convertValueString(GroupDescriptor.create(groupId), group.second));
        }
        return descriptors;
    }

    public static Map<GroupDescriptor, Set<UsageDescriptor>> convertValueString(GroupDescriptor groupId, String valueData) {
        assert (groupId != null);
        HashMap<GroupDescriptor, Set<UsageDescriptor>> descriptors = new HashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (String value : valueData.split(Character.toString(','))) {
            String count;
            StringPair pair;
            if (ConvertUsagesUtil.isEmptyOrSpaces(value) || (pair = ConvertUsagesUtil.getPair(value, "=")) == null || ConvertUsagesUtil.isEmptyOrSpaces(count = pair.second)) continue;
            try {
                int i = Integer.parseInt(count);
                if (!descriptors.containsKey(groupId)) {
                    descriptors.put(groupId, new LinkedHashSet());
                }
                ((Set)descriptors.get(groupId)).add(new UsageDescriptor(pair.first, i));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return descriptors;
    }

    public static StringPair getPair(String str, String separator) {
        assert (str != null);
        assert (separator != null);
        int i = str.indexOf(separator);
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!ConvertUsagesUtil.isEmptyOrSpaces(key) && !ConvertUsagesUtil.isEmptyOrSpaces(value)) {
                return new StringPair(key, value);
            }
        }
        return null;
    }

    public static <T extends UsageDescriptor> Map<GroupDescriptor, Set<T>> sortDescriptorsByPriority(Map<GroupDescriptor, Set<T>> descriptors) {
        assert (descriptors != null);
        TreeMap<GroupDescriptor, Set<T>> map = new TreeMap<GroupDescriptor, Set<T>>((g1, g2) -> {
            int priority = (int)(g2.getPriority() - g1.getPriority());
            return priority == 0 ? g1.getId().compareTo(g2.getId()) : priority;
        });
        map.putAll(descriptors);
        return map;
    }

    @NotNull
    public static String escapeDescriptorName(@NotNull String name) {
        if (name == null) {
            ConvertUsagesUtil.$$$reportNull$$$0(0);
        }
        String string = name.replace(':', '_').replace(';', '_').replace(',', '_').replace("'", " ").replace("\"", " ");
        if (string == null) {
            ConvertUsagesUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isEmptyOrSpaces(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void assertDescriptorName(String key) {
        assert (key != null);
        assert (key.indexOf(58) == -1) : key + " contains invalid chars";
        assert (key.indexOf(59) == -1) : key + " contains invalid chars";
        assert (key.indexOf(44) == -1) : key + " contains invalid chars";
        assert (!key.contains("=")) : key + " contains invalid chars";
        assert (!key.contains("'")) : key + " contains invalid chars";
        assert (!key.contains("\"")) : key + " contains invalid chars";
    }

    public static String ensureProperKey(String input) {
        StringBuilder escaped = new StringBuilder();
        block3: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    escaped.append(' ');
                    continue block3;
                }
                default: {
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/beans/ConvertUsagesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/beans/ConvertUsagesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeDescriptorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeDescriptorName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringPair {
        public final String first;
        public final String second;

        public StringPair(String first, String second) {
            this.first = first;
            this.second = second;
        }
    }
}

