/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToolsUsagesCollector
extends AbstractProjectsUsagesCollector {
    private static final Predicate<ScopeToolState> BUNDLED = state -> {
        PluginDescriptor descriptor = state.getTool().getExtension().getPluginDescriptor();
        return descriptor instanceof IdeaPluginDescriptor && ((IdeaPluginDescriptor)descriptor).isBundled();
    };
    private static final Predicate<ScopeToolState> LISTED = state -> {
        PluginDescriptor descriptor = state.getTool().getExtension().getPluginDescriptor();
        if (descriptor instanceof IdeaPluginDescriptor) {
            PluginId id;
            String path;
            try {
                path = ((IdeaPluginDescriptor)descriptor).getPath().getCanonicalPath();
            }
            catch (IOException e) {
                path = ((IdeaPluginDescriptor)descriptor).getPath().getAbsolutePath();
            }
            if (path.startsWith(PathManager.getPluginsPath()) && (id = descriptor.getPluginId()) != null && AbstractToolsUsagesCollector.getRepositoryPluginIds().contains(id.getIdString())) {
                return true;
            }
        }
        return false;
    };
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(0);
        }
        List<ScopeToolState> tools = InspectionProjectProfileManager.getInstance(project).getCurrentProfile().getAllTools();
        Set<UsageDescriptor> set2 = this.filter(tools.stream()).map(ScopeToolState::getTool).map(tool -> tool.getLanguage() + "." + tool.getID()).map(UsageDescriptor::new).collect(Collectors.toSet());
        if (set2 == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    protected abstract Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> var1);

    private static Set<String> getRepositoryPluginIds() {
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            List<Object> plugins2 = Collections.emptyList();
            try {
                List<IdeaPluginDescriptor> cached = RepositoryHelper.loadCachedPlugins();
                if (cached != null) {
                    plugins2 = cached;
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RepositoryHelper.loadPlugins(null));
                }
            }
            catch (IOException cached) {
                // empty catch block
            }
            Set ids = StreamEx.of(plugins2).map(PluginDescriptor::getPluginId).nonNull().map(PluginId::getIdString).toSet();
            return CachedValueProvider.Result.create((Object)ids, (Object[])new Object[]{new DelayModificationTracker(1L, TimeUnit.HOURS)});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelayModificationTracker
    implements ModificationTracker {
        private final long myStamp;
        private final long myDelay;

        /*
         * WARNING - void declaration
         */
        private DelayModificationTracker(long delay, @NotNull TimeUnit timeUnit) {
            void unit;
            if (timeUnit == null) {
                DelayModificationTracker.$$$reportNull$$$0(0);
            }
            this.myStamp = System.currentTimeMillis();
            this.myDelay = TimeUnit.MILLISECONDS.convert(delay, (TimeUnit)unit);
        }

        public long getModificationCount() {
            long diff = System.currentTimeMillis() - (this.myStamp + this.myDelay);
            return diff > 0L ? diff : 0L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DelayModificationTracker", "<init>"));
        }
    }

    public static class DisabledListedToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        private static final GroupDescriptor GROUP_ID = GroupDescriptor.create("disabled-listed-tools");

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_ID;
            if (groupDescriptor == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(DISABLED).filter(LISTED);
            if (stream == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DisabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        private static final GroupDescriptor GROUP_ID = GroupDescriptor.create("disabled-bundled-tools");

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_ID;
            if (groupDescriptor == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(DISABLED).filter(BUNDLED);
            if (stream == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnabledListedToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        private static final GroupDescriptor GROUP_ID = GroupDescriptor.create("enabled-listed-tools");

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_ID;
            if (groupDescriptor == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(ENABLED).filter(LISTED);
            if (stream == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        private static final GroupDescriptor GROUP_ID = GroupDescriptor.create("enabled-bundled-tools");

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_ID;
            if (groupDescriptor == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(ENABLED).filter(BUNDLED);
            if (stream == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AllListedToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        private static final GroupDescriptor GROUP_ID = GroupDescriptor.create("all-listed-tools");

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_ID;
            if (groupDescriptor == null) {
                AllListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                AllListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(LISTED);
            if (stream == null) {
                AllListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$AllListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$AllListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AllBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        private static final GroupDescriptor GROUP_ID = GroupDescriptor.create("all-bundled-tools");

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_ID;
            if (groupDescriptor == null) {
                AllBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                AllBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(BUNDLED);
            if (stream == null) {
                AllBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$AllBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$AllBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

