/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.JBPanelFactory;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelTestAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            new ComponentPanelTest(project).show();
        }
    }

    private static class ComponentPanelTest
    extends DialogWrapper {
        private final Project myProject;
        private final Alarm myAlarm = new Alarm(this.getDisposable());
        private ProgressTimerRequest timerRequest;

        private ComponentPanelTest(Project project) {
            super(project);
            this.myProject = project;
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JBEditorTabs tabs = new JBEditorTabs(this.myProject, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)this.myProject), this.getDisposable()){

                public boolean isAlphabeticalMode() {
                    return false;
                }
            };
            tabs.addTab(new TabInfo(this.createComponentPanel()).setText("Component"));
            tabs.addTab(new TabInfo(this.createComponentGridPanel()).setText("Component Grid"));
            final TabInfo progressTab = new TabInfo(this.createProgressPanel()).setText("Progress");
            tabs.addTab(progressTab);
            tabs.addListener((TabsListener)new TabsListener.Adapter(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    if (timerRequest != null && timerRequest.canPlay()) {
                        if (newSelection == progressTab) {
                            myAlarm.addRequest((Runnable)timerRequest, 200, ModalityState.any());
                        } else {
                            myAlarm.cancelRequest((Runnable)timerRequest);
                        }
                    }
                }
            });
            tabs.addTab(new TabInfo(this.createProgressGridPanel()).setText("Progress Grid"));
            return tabs;
        }

        private JComponent createComponentPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            JTextField text = new JTextField();
            Dimension d = text.getPreferredSize();
            text.setPreferredSize(new Dimension(JBUI.scale((int)100), d.height));
            panel2.add(JBPanelFactory.panel((JComponent)text).withLabel("&Textfield:").withComment("Textfield description").moveCommentRight().createPanel());
            panel2.add(JBPanelFactory.panel((JComponent)new JTextField()).withLabel("&Path:").createPanel());
            panel2.add(JBPanelFactory.panel((JComponent)new JCheckBox("This is a checkbox 1")).withComment("My long long long long long long long long long long comment").createPanel());
            panel2.add(JBPanelFactory.panel((JComponent)new JCheckBox("This is a checkbox 2")).withTooltip("Help tooltip description").createPanel());
            panel2.add(JBPanelFactory.panel((JComponent)new JButton("Abracadabra")).withComment("Abradabra comment").createPanel());
            String[] items = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
            panel2.add(JBPanelFactory.panel(new JComboBox<String>(items)).withComment("Combobox comment").createPanel());
            final String[] columns = new String[]{"First column", "Second column"};
            final String[][] data = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}, {"four", "4"}, {"five", "5"}, {"six", "6"}, {"seven", "7"}, {"eight", "8"}, {"nine", "9"}, {"ten", "10"}, {"eleven", "11"}, {"twelve", "12"}, {"thirteen", "13"}, {"fourteen", "14"}, {"fifteen", "15"}, {"sixteen", "16"}};
            JBTable table = new JBTable((TableModel)new AbstractTableModel(){

                @Override
                public String getColumnName(int column) {
                    return columns[column];
                }

                @Override
                public int getRowCount() {
                    return data.length;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return data[row][col];
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                @Override
                public void setValueAt(Object value, int row, int col) {
                }
            });
            JBScrollPane pane = new JBScrollPane((Component)table);
            pane.setPreferredSize((Dimension)JBUI.size((int)200, (int)100));
            panel2.add(JBPanelFactory.panel((JComponent)pane).withLabel("Table label:").moveLabelOnTop().withComment("Table comment").createPanel());
            panel2.add(new Box.Filler((Dimension)JBUI.size((int)100, (int)20), (Dimension)JBUI.size((int)200, (int)30), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));
            return panel2;
        }

        private JComponent createComponentGridPanel() {
            ComboboxWithBrowseButton cbb = new ComboboxWithBrowseButton(new JComboBox<String>(new String[]{"One", "Two", "Three", "Four"}));
            cbb.addActionListener(e -> System.out.println("Browse for combobox"));
            JPanel p1 = JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JComponent)new JTextField()).withLabel("&Port:").withComment("Port comment")).add((PanelBuilder)JBPanelFactory.panel((JComponent)new JTextField()).withLabel("&Host:").withComment("Host comment")).add((PanelBuilder)JBPanelFactory.panel(new JComboBox<String>(new String[]{"HTTP", "HTTPS", "FTP", "SSL"})).withLabel("P&rotocol:").withComment("Protocol comment").withTooltip("Protocol selection").withTooltipLink("Check here for more info", () -> System.out.println("More info"))).add((PanelBuilder)JBPanelFactory.panel((JComponent)new ComponentWithBrowseButton((JComponent)new JTextField(), e -> System.out.println("Browse for text"))).withLabel("&Text field:").withComment("Text field comment")).add((PanelBuilder)JBPanelFactory.panel((JComponent)cbb).withLabel("&Combobox selection:")).add((PanelBuilder)JBPanelFactory.panel((JComponent)new JCheckBox("Checkbox")).withComment("Checkbox comment text")).add((PanelBuilder)JBPanelFactory.panel((JComponent)new JTextArea(3, 40)).withLabel("Text area:").withComment("Text area comment").moveLabelOnTop()).createPanel();
            ButtonGroup bg = new ButtonGroup();
            JRadioButton rb1 = new JRadioButton("RadioButton 1");
            JRadioButton rb2 = new JRadioButton("RadioButton 1");
            JRadioButton rb3 = new JRadioButton("RadioButton 1");
            bg.add(rb1);
            bg.add(rb2);
            bg.add(rb3);
            rb1.setSelected(true);
            JPanel p2 = JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JComponent)new JCheckBox("Checkbox 1")).withComment("Comment 1").moveCommentRight()).add((PanelBuilder)JBPanelFactory.panel((JComponent)new JCheckBox("Checkbox 2")).withComment("Comment 2")).add((PanelBuilder)JBPanelFactory.panel((JComponent)new JCheckBox("Checkbox 3")).withTooltip("Checkbox tooltip")).add((PanelBuilder)JBPanelFactory.panel((JComponent)rb1).withComment("Comment 1").moveCommentRight()).add((PanelBuilder)JBPanelFactory.panel((JComponent)rb2).withComment("Comment 2")).add((PanelBuilder)JBPanelFactory.panel((JComponent)rb3).withTooltip("RadioButton tooltip")).createPanel();
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            panel2.add(p1);
            panel2.add(Box.createVerticalStrut(JBUI.scale((int)5)));
            panel2.add(p2);
            panel2.add(new Box.Filler((Dimension)JBUI.size((int)100, (int)20), (Dimension)JBUI.size((int)200, (int)30), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));
            return panel2;
        }

        private JComponent createProgressPanel() {
            JProgressBar progressBar = new JProgressBar(0, 100);
            JPanel innerPanel = JBPanelFactory.panel((JProgressBar)progressBar).withLabel("Process").withCancel(() -> this.myAlarm.cancelRequest((Runnable)this.timerRequest)).createPanel();
            this.timerRequest = new ProgressTimerRequest(progressBar);
            this.myAlarm.addRequest((Runnable)this.timerRequest, 200, ModalityState.any());
            ProgressPanel progressPanel = ProgressPanel.forComponent((JComponent)progressBar);
            if (progressPanel != null) {
                progressPanel.setCommentText(Integer.toString(0));
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            panel2.add((Component)innerPanel, "North");
            return panel2;
        }

        private JComponent createProgressGridPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            JProgressBar pb1 = new JProgressBar(0, 100);
            JProgressBar pb2 = new JProgressBar(0, 100);
            panel2.add(JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JProgressBar)pb1).withLabel("Label 1.1").withCancel(() -> System.out.println("Cancel action #1"))).add((PanelBuilder)JBPanelFactory.panel((JProgressBar)pb2).withLabel("Label 1.2").withPause(() -> System.out.println("Pause action #2")).withResume(() -> System.out.println("Resume action #2"))).createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.forComponent((JComponent)pb1))).setCommentText("Long long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.forComponent((JComponent)pb2))).setCommentText("Short text");
            JProgressBar pb3 = new JProgressBar(0, 100);
            JProgressBar pb4 = new JProgressBar(0, 100);
            panel2.add(JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JProgressBar)pb3).withTopSeparator().withLabel("Label 2.1").moveLabelLeft().withCancel(() -> System.out.println("Cancel action #3"))).add((PanelBuilder)JBPanelFactory.panel((JProgressBar)pb4).withLabel("Label 2.2").moveLabelLeft().withPause(() -> System.out.println("Pause action #4")).withResume(() -> System.out.println("Resume action #4"))).createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.forComponent((JComponent)pb3))).setCommentText("Long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.forComponent((JComponent)pb4))).setCommentText("Short text");
            JProgressBar pb5 = new JProgressBar(0, 100);
            JProgressBar pb6 = new JProgressBar(0, 100);
            panel2.add(JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JProgressBar)pb5).withTopSeparator().withLabel("Label 3.1").withCancel(() -> System.out.println("Cancel action #5")).andSmallIcons()).add((PanelBuilder)JBPanelFactory.panel((JProgressBar)pb6).withLabel("Label 3.2").withPause(() -> System.out.println("Pause action #6")).withResume(() -> System.out.println("Resume action #6")).andSmallIcons()).createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.forComponent((JComponent)pb5))).setCommentText("Long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.forComponent((JComponent)pb6))).setCommentText("Short text");
            panel2.add(JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withLabel("Label 4.1").withoutComment().withCancel(() -> System.out.println("Cancel action #7")).andSmallIcons()).add((PanelBuilder)JBPanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withLabel("Label 4.2").withoutComment().withPause(() -> System.out.println("Pause action #8")).withResume(() -> System.out.println("Resume action #8")).andSmallIcons()).createPanel());
            panel2.add(JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withoutComment().withCancel(() -> System.out.println("Cancel action #9")).andSmallIcons()).createPanel());
            panel2.add(JBPanelFactory.grid().add((PanelBuilder)JBPanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withoutComment().andCancelAsButton().withCancel(() -> System.out.println("Cancel action #11"))).createPanel());
            panel2.add(Box.createVerticalBox());
            return panel2;
        }

        private class ProgressTimerRequest
        implements Runnable {
            private final JProgressBar myProgressBar;

            private ProgressTimerRequest(JProgressBar progressBar) {
                this.myProgressBar = progressBar;
            }

            @Override
            public void run() {
                int v = this.myProgressBar.getValue() + 1;
                if (v > this.myProgressBar.getMaximum()) {
                    v = this.myProgressBar.getMinimum();
                }
                this.myProgressBar.setValue(v);
                ProgressPanel progressPanel = ProgressPanel.forComponent((JComponent)this.myProgressBar);
                if (progressPanel != null) {
                    progressPanel.setCommentText(Integer.toString(v));
                }
                ComponentPanelTest.this.myAlarm.addRequest((Runnable)this, 200, ModalityState.any());
            }

            private boolean canPlay() {
                ProgressPanel progressPanel = ProgressPanel.forComponent((JComponent)this.myProgressBar);
                return progressPanel != null && progressPanel.getState() == ProgressPanel.State.PLAYING;
            }
        }
    }
}

