/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.codeinsight.JsonStandardComplianceProvider;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStandardComplianceInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(JsonStandardComplianceInspection.class);
    public boolean myWarnAboutComments = true;
    public boolean myWarnAboutMultipleTopLevelValues = true;

    @NotNull
    public String getDisplayName() {
        String string = JsonBundle.message("inspection.compliance.name", new Object[0]);
        if (string == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(2);
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            public void visitComment(PsiComment comment) {
                if (JsonStandardComplianceInspection.this.myWarnAboutComments && JsonStandardComplianceProvider.shouldWarnAboutComment(comment)) {
                    holder.registerProblem((PsiElement)comment, JsonBundle.message("inspection.compliance.msg.comments", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitStringLiteral(@NotNull JsonStringLiteral stringLiteral) {
                if (stringLiteral == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JsonPsiUtil.getElementTextWithoutHostEscaping(stringLiteral).startsWith("'")) {
                    holder.registerProblem((PsiElement)stringLiteral, JsonBundle.message("inspection.compliance.msg.single.quoted.strings", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
                }
                super.visitStringLiteral(stringLiteral);
            }

            @Override
            public void visitLiteral(@NotNull JsonLiteral literal) {
                if (literal == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (JsonPsiUtil.isPropertyKey(literal) && !JsonPsiUtil.getElementTextWithoutHostEscaping(literal).startsWith("\"")) {
                    holder.registerProblem((PsiElement)literal, JsonBundle.message("inspection.compliance.msg.illegal.property.key", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
                }
                super.visitLiteral(literal);
            }

            @Override
            public void visitReferenceExpression(@NotNull JsonReferenceExpression reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(2);
                }
                holder.registerProblem((PsiElement)reference, JsonBundle.message("inspection.compliance.msg.bad.token", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
                super.visitReferenceExpression(reference);
            }

            @Override
            public void visitArray(@NotNull JsonArray array) {
                PsiElement trailingComma;
                if (array == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((trailingComma = JsonStandardComplianceInspection.findTrailingComma(array, JsonElementTypes.R_BRACKET)) != null) {
                    holder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
                }
                super.visitArray(array);
            }

            @Override
            public void visitObject(@NotNull JsonObject object) {
                PsiElement trailingComma;
                if (object == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((trailingComma = JsonStandardComplianceInspection.findTrailingComma(object, JsonElementTypes.R_CURLY)) != null) {
                    holder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
                }
                super.visitObject(object);
            }

            @Override
            public void visitValue(@NotNull JsonValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (value.getContainingFile() instanceof JsonFile) {
                    JsonFile jsonFile = (JsonFile)value.getContainingFile();
                    if (JsonStandardComplianceInspection.this.myWarnAboutMultipleTopLevelValues && value.getParent() == jsonFile && value != jsonFile.getTopLevelValue()) {
                        holder.registerProblem((PsiElement)value, JsonBundle.message("inspection.compliance.msg.multiple.top.level.values", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stringLiteral";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "array";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStringLiteral";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteral";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArray";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitObject";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jsonElementVisitor == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(3);
        }
        return jsonElementVisitor;
    }

    @Nullable
    private static PsiElement findTrailingComma(@NotNull JsonContainer container, @NotNull IElementType ending) {
        PsiElement lastChild;
        if (container == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(4);
        }
        if (ending == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(5);
        }
        if ((lastChild = container.getLastChild()).getNode().getElementType() != ending) {
            return null;
        }
        PsiElement beforeEnding = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        if (beforeEnding != null && beforeEnding.getNode().getElementType() == JsonElementTypes.COMMA) {
            return beforeEnding;
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.comments", new Object[0]), "myWarnAboutComments");
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.multiple.top.level.values", new Object[0]), "myWarnAboutMultipleTopLevelValues");
        return optionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ending";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingComma";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddDoubleQuotesFix
    implements LocalQuickFix {
        private AddDoubleQuotesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JsonBundle.message("quickfix.add.double.quotes.desc", new Object[0]);
            if (string == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            String rawText = element.getText();
            if (element instanceof JsonLiteral || element instanceof JsonReferenceExpression) {
                String content = JsonPsiUtil.stripQuotes(rawText);
                if (element instanceof JsonStringLiteral && rawText.startsWith("'")) {
                    content = AddDoubleQuotesFix.escapeSingleQuotedStringContent(content);
                }
                Object replacement = new JsonElementGenerator(project).createValue("\"" + content + "\"");
                CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> element.replace(replacement));
            } else {
                LOG.error("Quick fix was applied to unexpected element", new String[]{rawText, element.getParent().getText()});
            }
        }

        @NotNull
        private static String escapeSingleQuotedStringContent(@NotNull String content) {
            if (content == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(3);
            }
            StringBuilder result2 = new StringBuilder();
            boolean nextCharEscaped = false;
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (nextCharEscaped && c != '\'' || !nextCharEscaped && c == '\"') {
                    result2.append('\\');
                }
                if (c != '\\' || nextCharEscaped) {
                    result2.append(c);
                    nextCharEscaped = false;
                    continue;
                }
                nextCharEscaped = true;
            }
            if (nextCharEscaped) {
                result2.append('\\');
            }
            String string = result2.toString();
            if (string == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeSingleQuotedStringContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeSingleQuotedStringContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

