/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClipboardAnalyzeListener
implements ApplicationActivationListener {
    private static final int MAX_SIZE = 102400;
    @Nullable
    private String myCachedClipboardValue;

    public void applicationActivated(IdeFrame ideFrame) {
        Runnable processClipboard = () -> {
            String clipboard = ClipboardUtil.getTextInClipboard();
            if (clipboard != null && clipboard.length() < 102400 && !clipboard.equals(this.myCachedClipboardValue)) {
                this.myCachedClipboardValue = clipboard;
                Project project = ideFrame.getProject();
                if (project != null && !project.isDefault() && this.canHandle(this.myCachedClipboardValue)) {
                    this.handle(project, this.myCachedClipboardValue);
                }
            }
        };
        if (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS) {
            new Alarm().addRequest(processClipboard, 300);
        } else {
            processClipboard.run();
        }
    }

    protected abstract void handle(@NotNull Project var1, @NotNull String var2);

    public void applicationDeactivated(IdeFrame ideFrame) {
        this.myCachedClipboardValue = ClipboardUtil.getTextInClipboard();
    }

    public abstract boolean canHandle(@NotNull String var1);
}

