/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatePluginsApp
extends ApplicationStarterEx {
    public boolean isHeadless() {
        return true;
    }

    public String getCommandName() {
        return "update";
    }

    public void premain(String[] args) {
    }

    public void main(String[] args) {
        Set<String> pluginsToUpdate = UpdatePluginsApp.getPluginsToUpdate(args);
        ActionCallback callback = new ActionCallback().doWhenDone(() -> System.exit(0)).doWhenRejected(() -> System.exit(1));
        Runnable update = () -> UpdatePluginsApp.updateAllPlugins(callback, pluginsToUpdate, UpdatePluginsApp.getBuildNumber(args, callback));
        ApplicationManager.getApplication().executeOnPooledThread(update);
    }

    @Nullable
    private static Set<String> getPluginsToUpdate(String[] args) {
        if (args.length < 2) {
            return null;
        }
        int fromIndex = "-b".equals(args[1]) ? 3 : 1;
        return ContainerUtil.newTroveSet(Arrays.asList(args).subList(fromIndex, args.length));
    }

    @NotNull
    private static BuildNumber getBuildNumber(String[] args, ActionCallback callback) {
        if (args.length > 2 && "-b".equals(args[1])) {
            BuildNumber buildNumber = BuildNumber.fromString((String)args[2]);
            if (buildNumber != null) {
                BuildNumber buildNumber2 = buildNumber;
                if (buildNumber2 == null) {
                    UpdatePluginsApp.$$$reportNull$$$0(0);
                }
                return buildNumber2;
            }
            UpdatePluginsApp.log("Invalid build number: " + args[2]);
            callback.setRejected();
        }
        BuildNumber buildNumber = BuildNumber.currentVersion();
        if (buildNumber == null) {
            UpdatePluginsApp.$$$reportNull$$$0(1);
        }
        return buildNumber;
    }

    private static void updateAllPlugins(ActionCallback callback, @Nullable Set<String> plugins2, BuildNumber buildNumber) {
        Collection availableUpdates = UpdateChecker.checkPluginsUpdate(UpdateSettings.getInstance(), (ProgressIndicator)new EmptyProgressIndicator(), new HashSet<IdeaPluginDescriptor>(), buildNumber);
        if (availableUpdates == null) {
            UpdatePluginsApp.log("All plugins up to date.");
            callback.setDone();
            return;
        }
        Collection pluginsToUpdate = plugins2 == null || plugins2.isEmpty() ? availableUpdates : (Collection)availableUpdates.stream().filter(downloader -> plugins2.contains(downloader.getPluginId())).collect(Collectors.toList());
        UpdatePluginsApp.log("Plugins to update:");
        pluginsToUpdate.forEach(d -> UpdatePluginsApp.log("\t" + d.getPluginName()));
        if (UpdateInstaller.installPluginUpdates(pluginsToUpdate, (ProgressIndicator)new EmptyProgressIndicator())) {
            callback.setDone();
        } else {
            UpdatePluginsApp.log("Update failed");
            callback.setRejected();
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UpdatePluginsApp", "getBuildNumber"));
    }
}

