/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CharsetEP
implements PatchEP {
    private static final Key<Map<String, String>> ourName = Key.create((String)"Charset");
    private final Project myProject;
    private final String myBaseDir;

    public CharsetEP(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir().getPath();
    }

    @NotNull
    public String getName() {
        if ("com.intellij.openapi.diff.impl.patch.CharsetEP" == null) {
            CharsetEP.$$$reportNull$$$0(0);
        }
        return "com.intellij.openapi.diff.impl.patch.CharsetEP";
    }

    public CharSequence provideContent(@NotNull String path, CommitContext commitContext) {
        if (path == null) {
            CharsetEP.$$$reportNull$$$0(1);
        }
        File file2 = new File(this.myBaseDir, path);
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (vf == null) {
            return null;
        }
        String charsetName = vf.getCharset().name();
        UsageTrigger.trigger("Patch.CharsetEP." + charsetName);
        return charsetName;
    }

    public void consumeContent(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (path == null) {
            CharsetEP.$$$reportNull$$$0(2);
        }
        if (content == null) {
            CharsetEP.$$$reportNull$$$0(3);
        }
    }

    public void consumeContentBeforePatchApplied(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (path == null) {
            CharsetEP.$$$reportNull$$$0(4);
        }
        if (content == null) {
            CharsetEP.$$$reportNull$$$0(5);
        }
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map = (HashMap<String, String>)commitContext.getUserData(ourName);
        if (map == null) {
            map = new HashMap<String, String>();
            commitContext.putUserData(ourName, map);
        }
        File file2 = new File(this.myBaseDir, path);
        map.put(FilePathsHelper.convertPath((String)file2.getPath()), content.toString());
    }

    public static String getCharset(String path, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        Map userData = (Map)commitContext.getUserData(ourName);
        return userData == null ? null : (String)userData.get(FilePathsHelper.convertPath((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/CharsetEP";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/CharsetEP";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "provideContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consumeContent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "consumeContentBeforePatchApplied";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

