/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.Dumpable;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorUtil {
    private static final Logger LOG = Logger.getInstance(EditorUtil.class);

    private EditorUtil() {
    }

    public static boolean isRealFileEditor(@Nullable Editor editor) {
        return editor != null && TextEditorProvider.getInstance().getTextEditor(editor) instanceof TextEditorImpl;
    }

    public static boolean isPasswordEditor(@Nullable Editor editor) {
        return editor != null && editor.getContentComponent() instanceof JPasswordField;
    }

    @Nullable
    public static EditorEx getEditorEx(@Nullable FileEditor fileEditor) {
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        return editor instanceof EditorEx ? (EditorEx)editor : null;
    }

    public static int getLastVisualLineColumnNumber(@NotNull Editor editor, int line) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(0);
        }
        if (editor instanceof EditorImpl) {
            LogicalPosition lineEndPosition = editor.visualToLogicalPosition(new VisualPosition(line, Integer.MAX_VALUE));
            int lineEndOffset = editor.logicalPositionToOffset(lineEndPosition);
            return editor.offsetToVisualPosition((int)lineEndOffset, (boolean)true, (boolean)true).column;
        }
        Document document = editor.getDocument();
        int lastLine = document.getLineCount() - 1;
        if (lastLine < 0) {
            return 0;
        }
        VisualPosition visStart = new VisualPosition(line, 0);
        LogicalPosition logStart = editor.visualToLogicalPosition(visStart);
        int lastLogLine = logStart.line;
        while (lastLogLine < document.getLineCount() - 1) {
            logStart = new LogicalPosition(logStart.line + 1, logStart.column);
            VisualPosition tryVisible = editor.logicalToVisualPosition(logStart);
            if (tryVisible.line != visStart.line) break;
            lastLogLine = logStart.line;
        }
        int resultLogLine = Math.min(lastLogLine, lastLine);
        VisualPosition resVisStart = editor.offsetToVisualPosition(document.getLineStartOffset(resultLogLine));
        VisualPosition resVisEnd = editor.offsetToVisualPosition(document.getLineEndOffset(resultLogLine));
        if (resVisStart.line == resVisEnd.line) {
            return resVisEnd.column;
        }
        int visualLinesToSkip = line - resVisStart.line;
        List softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(resultLogLine);
        for (int i = 0; i < softWraps.size(); ++i) {
            SoftWrap softWrap = (SoftWrap)softWraps.get(i);
            CharSequence text = document.getCharsSequence();
            if (visualLinesToSkip <= 0) {
                VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
                int result2 = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                return result2 + EditorUtil.textWidthInColumns(editor, text, softWrap.getStart() - 1, softWrap.getStart(), x);
            }
            int softWrapLineFeeds = StringUtil.countNewLines((CharSequence)softWrap.getText());
            if (softWrapLineFeeds < visualLinesToSkip) {
                visualLinesToSkip -= softWrapLineFeeds;
                continue;
            }
            if (softWrapLineFeeds == visualLinesToSkip) {
                if (i >= softWraps.size() - 1) {
                    return resVisEnd.column;
                }
                SoftWrap nextSoftWrap = (SoftWrap)softWraps.get(i + 1);
                VisualPosition visual = editor.offsetToVisualPosition(nextSoftWrap.getStart() - 1);
                int result3 = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                result3 += EditorUtil.textWidthInColumns(editor, text, nextSoftWrap.getStart() - 1, nextSoftWrap.getStart(), x);
                int lineFeedIndex = StringUtil.indexOf((CharSequence)nextSoftWrap.getText(), (char)'\n');
                return result3 += EditorUtil.textWidthInColumns(editor, nextSoftWrap.getText(), 0, lineFeedIndex, 0);
            }
            int softWrapStartOffset = 0;
            int softWrapEndOffset = 0;
            int softWrapTextLength = softWrap.getText().length();
            while (visualLinesToSkip-- > 0) {
                softWrapStartOffset = softWrapEndOffset + 1;
                if (softWrapStartOffset >= softWrapTextLength) {
                    assert (false);
                    return resVisEnd.column;
                }
                softWrapEndOffset = StringUtil.indexOf((CharSequence)softWrap.getText(), (char)'\n', (int)softWrapStartOffset, (int)softWrapTextLength);
                if (softWrapEndOffset >= 0) continue;
                assert (false);
                return resVisEnd.column;
            }
            VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
            int result4 = visual.column;
            int x = editor.visualPositionToXY((VisualPosition)visual).x;
            result4 += EditorUtil.textWidthInColumns(editor, text, softWrap.getStart() - 1, softWrap.getStart(), x);
            return result4 += EditorUtil.calcColumnNumber(editor, softWrap.getText(), softWrapStartOffset, softWrapEndOffset);
        }
        String editorInfo = "editor's class: " + editor.getClass() + ", all soft wraps: " + editor.getSoftWrapModel().getSoftWrapsForRange(0, document.getTextLength()) + ", fold regions: " + Arrays.toString(editor.getFoldingModel().getAllFoldRegions());
        LogMessageEx.error(LOG, "Can't calculate last visual column", String.format("Target visual line: %d, mapped logical line: %d, visual lines range for the mapped logical line: [%s]-[%s], soft wraps for the target logical line: %s. Editor info: %s", line, resultLogLine, resVisStart, resVisEnd, softWraps, editorInfo));
        return resVisEnd.column;
    }

    public static int getVisualLineEndOffset(@NotNull Editor editor, int line) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(1);
        }
        VisualPosition endLineVisualPosition = new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(editor, line));
        LogicalPosition endLineLogicalPosition = editor.visualToLogicalPosition(endLineVisualPosition);
        return editor.logicalPositionToOffset(endLineLogicalPosition);
    }

    public static float calcVerticalScrollProportion(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(2);
        }
        Rectangle viewArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (viewArea.height == 0) {
            return 0.0f;
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point location = editor.logicalPositionToXY(pos);
        return (float)(location.y - viewArea.y) / (float)viewArea.height;
    }

    public static void setVerticalScrollProportion(@NotNull Editor editor, float proportion) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(3);
        }
        Rectangle viewArea = editor.getScrollingModel().getVisibleArea();
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        Point caretLocation = editor.logicalPositionToXY(caretPosition);
        int yPos = caretLocation.y;
        yPos = (int)((float)yPos - (float)viewArea.height * proportion);
        editor.getScrollingModel().scrollVertically(yPos);
    }

    public static int calcRelativeCaretPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(4);
        }
        int caretY = editor.getCaretModel().getVisualPosition().line * editor.getLineHeight();
        int viewAreaPosition = editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return caretY - viewAreaPosition;
    }

    public static void setRelativeCaretPosition(@NotNull Editor editor, int position) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(5);
        }
        int caretY = editor.getCaretModel().getVisualPosition().line * editor.getLineHeight();
        editor.getScrollingModel().scrollVertically(caretY - position);
    }

    public static void fillVirtualSpaceUntilCaret(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(6);
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(final @NotNull Editor editor, int columnNumber, int lineNumber) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(7);
        }
        final int offset = editor.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        final String filler = EditorModificationUtil.calcStringToFillVirtualSpace((Editor)editor);
        if (!filler.isEmpty()) {
            new WriteAction(){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    editor.getDocument().insertString(offset, (CharSequence)filler);
                    editor.getCaretModel().moveToOffset(offset + filler.length());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/editor/ex/util/EditorUtil$1", "run"));
                }
            }.execute();
        }
    }

    private static int getTabLength(int colNumber, int tabSize) {
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return tabSize - colNumber % tabSize;
    }

    public static int calcColumnNumber(@NotNull Editor editor, @NotNull CharSequence text, int start, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(8);
        }
        if (text == null) {
            EditorUtil.$$$reportNull$$$0(9);
        }
        return EditorUtil.calcColumnNumber(editor, text, start, offset, EditorUtil.getTabSize(editor));
    }

    public static int calcColumnNumber(@Nullable Editor editor, @NotNull CharSequence text, int start, int offset, int tabSize) {
        int i;
        if (text == null) {
            EditorUtil.$$$reportNull$$$0(10);
        }
        if (editor instanceof TextComponentEditor) {
            return offset - start;
        }
        boolean useOptimization = true;
        if (editor != null) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(start);
            boolean bl = useOptimization = softWrap == null;
        }
        if (useOptimization) {
            boolean hasNonTabs = false;
            for (i = start; i < offset; ++i) {
                if (text.charAt(i) == '\t') {
                    if (!hasNonTabs) continue;
                    useOptimization = false;
                    break;
                }
                hasNonTabs = true;
            }
        }
        if (editor != null && useOptimization) {
            Document document = editor.getDocument();
            if (start < offset - 1 && document.getLineNumber(start) != document.getLineNumber(offset - 1)) {
                String editorInfo = editor instanceof EditorImpl ? ". Editor info: " + ((EditorImpl)editor).dumpState() : "";
                String documentInfo = text instanceof Dumpable ? ((Dumpable)text).dumpState() : "Text holder class: " + text.getClass();
                LogMessageEx.error(LOG, "detected incorrect offset -> column number calculation", "start: " + start + ", given offset: " + offset + ", given tab size: " + tabSize + ". " + documentInfo + editorInfo);
            }
        }
        int shift = 0;
        for (i = start; i < offset; ++i) {
            char c = text.charAt(i);
            if (c != '\t') continue;
            shift += EditorUtil.getTabLength(i + shift - start, tabSize) - 1;
        }
        return offset - start + shift;
    }

    public static void setHandCursor(@NotNull Editor view) {
        if (view == null) {
            EditorUtil.$$$reportNull$$$0(11);
        }
        Cursor c = Cursor.getPredefinedCursor(12);
        if (view.getContentComponent().getCursor() != c) {
            view.getContentComponent().setCursor(c);
        }
    }

    @NotNull
    public static FontInfo fontForChar(char c, @JdkConstants.FontStyle int style, @NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(12);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((int)c, style, colorsScheme.getFontPreferences(), FontInfo.getFontRenderContext(editor.getContentComponent()));
        if (fontInfo == null) {
            EditorUtil.$$$reportNull$$$0(13);
        }
        return fontInfo;
    }

    public static Icon scaleIconAccordingEditorFont(Icon icon, Editor editor) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && editor instanceof EditorImpl && icon instanceof ScalableIcon && Math.abs(1.0f - (scale = ((EditorImpl)editor).getScale())) > 0.1f) {
            return ((ScalableIcon)icon).scale(scale);
        }
        return icon;
    }

    public static int charWidth(char c, @JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(14);
        }
        return EditorUtil.fontForChar(c, fontType, editor).charWidth(c);
    }

    public static int getSpaceWidth(@JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        int width;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(15);
        }
        return (width = EditorUtil.charWidth(' ', fontType, editor)) > 0 ? width : 1;
    }

    public static int getPlainSpaceWidth(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(16);
        }
        return EditorUtil.getSpaceWidth(0, editor);
    }

    public static int getTabSize(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(17);
        }
        return editor.getSettings().getTabSize(editor.getProject());
    }

    public static int nextTabStop(int x, @NotNull Editor editor) {
        int tabSize;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(18);
        }
        if ((tabSize = EditorUtil.getTabSize(editor)) <= 0) {
            tabSize = 1;
        }
        return EditorUtil.nextTabStop(x, editor, tabSize);
    }

    public static int nextTabStop(int x, @NotNull Editor editor, int tabSize) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(19);
        }
        int leftInset = editor.getContentComponent().getInsets().left;
        return EditorUtil.nextTabStop(x - leftInset, EditorUtil.getSpaceWidth(0, editor), tabSize) + leftInset;
    }

    public static int nextTabStop(int x, int plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        int nTabs = x / (tabSize *= plainSpaceWidth);
        return (nTabs + 1) * tabSize;
    }

    public static float nextTabStop(float x, float plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        tabSize = (int)((float)tabSize * plainSpaceWidth);
        int nTabs = (int)(x / (float)tabSize);
        return (nTabs + 1) * tabSize;
    }

    public static int textWidthInColumns(@NotNull Editor editor, @NotNull CharSequence text, int start, int end, int x) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(20);
        }
        if (text == null) {
            EditorUtil.$$$reportNull$$$0(21);
        }
        int startToUse = start;
        int lastTabSymbolIndex = -1;
        block8: for (int i = end - 1; i >= start; --i) {
            switch (text.charAt(i)) {
                case '\n': {
                    startToUse = i + 1;
                    break block8;
                }
                case '\t': {
                    if (lastTabSymbolIndex < 0) {
                        lastTabSymbolIndex = i;
                    }
                }
                default: {
                    continue block8;
                }
            }
        }
        if (lastTabSymbolIndex < 0) {
            return end - startToUse;
        }
        int result2 = 0;
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        block9: for (int i = startToUse; i <= lastTabSymbolIndex; ++i) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(i);
            if (softWrap != null) {
                x = softWrap.getIndentInPixels();
            }
            char c = text.charAt(i);
            int prevX = x;
            switch (c) {
                case '\t': {
                    x = EditorUtil.nextTabStop(x, editor);
                    result2 += EditorUtil.columnsNumber(x - prevX, spaceSize);
                    continue block9;
                }
                case '\n': {
                    result2 = 0;
                    x = 0;
                    continue block9;
                }
                default: {
                    x += EditorUtil.charWidth(c, 0, editor);
                    ++result2;
                }
            }
        }
        return result2 += end - lastTabSymbolIndex - 1;
    }

    public static int columnsNumber(int width, int plainSpaceSize) {
        int result2 = width / plainSpaceSize;
        if (width % plainSpaceSize > 0) {
            ++result2;
        }
        return result2;
    }

    public static int columnsNumber(float width, float plainSpaceSize) {
        return (int)Math.ceil(width / plainSpaceSize);
    }

    public static int textWidth(@NotNull Editor editor, @NotNull CharSequence text, int start, int end, @JdkConstants.FontStyle int fontType, int x) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(22);
        }
        if (text == null) {
            EditorUtil.$$$reportNull$$$0(23);
        }
        int result2 = 0;
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '\t') {
                FontInfo font = EditorUtil.fontForChar(c, fontType, editor);
                result2 += font.charWidth(c);
                continue;
            }
            result2 += EditorUtil.nextTabStop(x + result2, editor) - result2 - x;
        }
        return result2;
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(24);
        }
        return EditorUtil.calcSurroundingRange(editor, editor.getCaretModel().getVisualPosition(), editor.getCaretModel().getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Caret caret) {
        if (caret == null) {
            EditorUtil.$$$reportNull$$$0(25);
        }
        return EditorUtil.calcSurroundingRange(caret.getEditor(), caret.getVisualPosition(), caret.getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcSurroundingRange(@NotNull Editor editor, @NotNull VisualPosition start, @NotNull VisualPosition end) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(26);
        }
        if (start == null) {
            EditorUtil.$$$reportNull$$$0(27);
        }
        if (end == null) {
            EditorUtil.$$$reportNull$$$0(28);
        }
        Document document = editor.getDocument();
        FoldingModel foldingModel = editor.getFoldingModel();
        LogicalPosition first = editor.visualToLogicalPosition(new VisualPosition(start.line, 0));
        int line = first.line;
        int offset = document.getLineStartOffset(line);
        while (offset >= 0) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset);
            if (foldRegion == null) {
                first = new LogicalPosition(line, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getStartOffset());
            if (foldEndLine <= line) {
                first = new LogicalPosition(line, 0);
                break;
            }
            line = foldEndLine;
            offset = document.getLineStartOffset(line);
        }
        LogicalPosition second = editor.visualToLogicalPosition(new VisualPosition(end.line, 0));
        int line2 = second.line;
        int offset2 = document.getLineEndOffset(line2);
        while (offset2 <= document.getTextLength()) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset2);
            if (foldRegion == null) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getEndOffset());
            if (foldEndLine <= line2) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            line2 = foldEndLine;
            offset2 = document.getLineEndOffset(line2);
        }
        if (second.line >= document.getLineCount()) {
            second = editor.offsetToLogicalPosition(document.getTextLength());
        }
        return Pair.create((Object)first, (Object)second);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(29);
        }
        while (true) {
            offset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
            if (foldRegion == null || foldRegion.getStartOffset() >= offset) break;
            offset = foldRegion.getStartOffset();
        }
        return offset;
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(30);
        }
        while (true) {
            offset = EditorUtil.getLineEndOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion == null || foldRegion.getEndOffset() <= offset) break;
            offset = foldRegion.getEndOffset();
        }
        return offset;
    }

    private static int getLineEndOffset(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    public static void scrollToTheEnd(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(31);
        }
        EditorUtil.scrollToTheEnd(editor, false);
    }

    public static void scrollToTheEnd(@NotNull Editor editor, boolean preferVerticalScroll) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(32);
        }
        editor.getSelectionModel().removeSelection();
        Document document = editor.getDocument();
        int lastLine = Math.max(0, document.getLineCount() - 1);
        if (editor.getCaretModel().getLogicalPosition().line == lastLine) {
            editor.getCaretModel().moveToOffset(document.getTextLength());
        } else {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lastLine, 0));
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (preferVerticalScroll && document.getLineStartOffset(lastLine) == document.getLineEndOffset(lastLine)) {
            int scrollOffset;
            if (editor instanceof EditorEx) {
                JScrollBar verticalScrollBar = ((EditorEx)editor).getScrollPane().getVerticalScrollBar();
                scrollOffset = verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent();
            } else {
                scrollOffset = editor.getContentComponent().getHeight() - scrollingModel.getVisibleArea().height;
            }
            scrollingModel.scrollVertically(scrollOffset);
        } else {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static boolean isChangeFontSize(@NotNull MouseWheelEvent e) {
        if (e == null) {
            EditorUtil.$$$reportNull$$$0(33);
        }
        if (e.getWheelRotation() == 0) {
            return false;
        }
        return SystemInfo.isMac ? !e.isControlDown() && e.isMetaDown() && !e.isAltDown() && !e.isShiftDown() : e.isControlDown() && !e.isMetaDown() && !e.isAltDown() && !e.isShiftDown();
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, @NotNull LogicalPosition logicalPosition) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(34);
        }
        if (logicalPosition == null) {
            EditorUtil.$$$reportNull$$$0(35);
        }
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals((Object)logicalPosition);
    }

    public static void reinitSettings() {
        EditorFactory.getInstance().refreshAllEditors();
    }

    @NotNull
    public static TextRange getSelectionInAnyMode(Editor editor) {
        SelectionModel selection = editor.getSelectionModel();
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        int start = starts.length > 0 ? starts[0] : selection.getSelectionStart();
        int end = ends.length > 0 ? ends[ends.length - 1] : selection.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start, (int)end);
        if (textRange == null) {
            EditorUtil.$$$reportNull$$$0(36);
        }
        return textRange;
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull MouseEvent event) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(37);
        }
        if (event == null) {
            EditorUtil.$$$reportNull$$$0(38);
        }
        return EditorUtil.yPositionToLogicalLine(editor, event.getY());
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(39);
        }
        if (point == null) {
            EditorUtil.$$$reportNull$$$0(40);
        }
        return EditorUtil.yPositionToLogicalLine(editor, point.y);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, int y) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(41);
        }
        int line = editor instanceof EditorImpl ? ((EditorImpl)editor).yToVisibleLine(y) : y / editor.getLineHeight();
        return line > 0 ? editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line : 0;
    }

    public static boolean isAtLineEnd(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(42);
        }
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return false;
        }
        int line = document.getLineNumber(offset);
        return offset == document.getLineEndOffset(line);
    }

    public static void setSelectionExpandingFoldedRegionsIfNeeded(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion endFoldRegion;
        FoldingModel foldingModel;
        FoldRegion startFoldRegion;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(43);
        }
        if ((startFoldRegion = (foldingModel = editor.getFoldingModel()).getCollapsedRegionAtOffset(startOffset)) != null && (startFoldRegion.getStartOffset() == startOffset || startFoldRegion.isExpanded())) {
            startFoldRegion = null;
        }
        if ((endFoldRegion = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && (endFoldRegion.getStartOffset() == endOffset || endFoldRegion.isExpanded())) {
            endFoldRegion = null;
        }
        if (startFoldRegion != null || endFoldRegion != null) {
            FoldRegion finalStartFoldRegion = startFoldRegion;
            FoldRegion finalEndFoldRegion = endFoldRegion;
            foldingModel.runBatchFoldingOperation(() -> {
                if (finalStartFoldRegion != null) {
                    finalStartFoldRegion.setExpanded(true);
                }
                if (finalEndFoldRegion != null) {
                    finalEndFoldRegion.setExpanded(true);
                }
            });
        }
        editor.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public static Font getEditorFont() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        int size = UISettings.getInstance().getPresentationMode() ? UISettings.getInstance().getPresentationModeFontSize() - 4 : scheme2.getEditorFontSize();
        return new Font(scheme2.getEditorFontName(), 0, size);
    }

    public static int getSoftWrapCountAfterLineStart(@NotNull Editor editor, @NotNull LogicalPosition position) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(44);
        }
        if (position == null) {
            EditorUtil.$$$reportNull$$$0(45);
        }
        if (position.visualPositionAware) {
            return position.softWrapLinesOnCurrentLogicalLine;
        }
        int startOffset = editor.getDocument().getLineStartOffset(position.line);
        int endOffset = editor.logicalPositionToOffset(position);
        return editor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset).size();
    }

    public static boolean attributesImpactFontStyleOrColor(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && (attributes.getFontType() != 0 || attributes.getForegroundColor() != null);
    }

    public static boolean isCurrentCaretPrimary(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(46);
        }
        return editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret();
    }

    public static void disposeWithEditor(@NotNull Editor editor, final @NotNull Disposable disposable) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(47);
        }
        if (disposable == null) {
            EditorUtil.$$$reportNull$$$0(48);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed((Disposable)disposable)) {
            return;
        }
        if (editor.isDisposed()) {
            Disposer.dispose((Disposable)disposable);
            return;
        }
        final Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event.getEditor() == hostEditor) {
                    Disposer.dispose((Disposable)disposable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/ex/util/EditorUtil$2", "editorReleased"));
            }
        }, disposable);
    }

    public static void runBatchFoldingOperationOutsideOfBulkUpdate(final @NotNull Editor editor, final @NotNull Runnable operation) {
        DocumentEx document;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(49);
        }
        if (operation == null) {
            EditorUtil.$$$reportNull$$$0(50);
        }
        if ((document = (DocumentEx)ObjectUtils.tryCast((Object)editor.getDocument(), DocumentEx.class)) != null && document.isInBulkUpdate()) {
            final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            EditorUtil.disposeWithEditor(editor, (Disposable)connection);
            connection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

                @Override
                public void updateFinished(@NotNull Document doc) {
                    if (doc == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (doc == editor.getDocument()) {
                        editor.getFoldingModel().runBatchFoldingOperation(operation);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/editor/ex/util/EditorUtil$3", "updateFinished"));
                }
            });
        } else {
            editor.getFoldingModel().runBatchFoldingOperation(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithAnimationDisabled(@NotNull Editor editor, @NotNull Runnable taskWithScrolling) {
        ScrollingModel scrollingModel;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(51);
        }
        if (taskWithScrolling == null) {
            EditorUtil.$$$reportNull$$$0(52);
        }
        if (!((scrollingModel = editor.getScrollingModel()) instanceof ScrollingModelImpl)) {
            taskWithScrolling.run();
        } else {
            boolean animationWasEnabled = ((ScrollingModelImpl)scrollingModel).isAnimationEnabled();
            scrollingModel.disableAnimation();
            try {
                taskWithScrolling.run();
            }
            finally {
                if (animationWasEnabled) {
                    scrollingModel.enableAnimation();
                }
            }
        }
    }

    @NotNull
    public static String displayCharInEditor(char c, @NotNull TextAttributesKey textAttributesKey, @NotNull String fallback) {
        char codePoint;
        if (textAttributesKey == null) {
            EditorUtil.$$$reportNull$$$0(53);
        }
        if (fallback == null) {
            EditorUtil.$$$reportNull$$$0(54);
        }
        if (!Character.isValidCodePoint(codePoint = c)) {
            String string = fallback;
            if (string == null) {
                EditorUtil.$$$reportNull$$$0(55);
            }
            return string;
        }
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme2.getAttributes(textAttributesKey);
        int style = textAttributes != null ? textAttributes.getFontType() : 0;
        FontInfo fallbackFont = ComplementaryFontsRegistry.getFontAbleToDisplay((int)c, style, scheme2.getFontPreferences(), null);
        String string = fallbackFont.canDisplay(codePoint) ? String.valueOf(c) : fallback;
        if (string == null) {
            EditorUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 36: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 36: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 10: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 13: 
            case 36: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/EditorUtil";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskWithScrolling";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributesKey";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fontForChar";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionInAnyMode";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "displayCharInEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastVisualLineColumnNumber";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineEndOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcVerticalScrollProportion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setVerticalScrollProportion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcRelativeCaretPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRelativeCaretPosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillVirtualSpaceUntilCaret";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillVirtualSpaceUntil";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnNumber";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setHandCursor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fontForChar";
                break;
            }
            case 13: 
            case 36: 
            case 55: 
            case 56: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "charWidth";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceWidth";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPlainSpaceWidth";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTabSize";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "nextTabStop";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "textWidthInColumns";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "textWidth";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcCaretLineRange";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "calcSurroundingRange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoldedLineStartOffset";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoldedLineEndOffset";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "scrollToTheEnd";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isChangeFontSize";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualSpace";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "yPositionToLogicalLine";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionExpandingFoldedRegionsIfNeeded";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSoftWrapCountAfterLineStart";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentCaretPrimary";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "disposeWithEditor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperationOutsideOfBulkUpdate";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "runWithAnimationDisabled";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "displayCharInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 36: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

