/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareFileEditorManagerImpl");
    private final PsiManager myPsiManager;
    private final WolfTheProblemSolver myProblemSolver;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;

    public PsiAwareFileEditorManagerImpl(Project project, PsiManager psiManager, WolfTheProblemSolver problemSolver, DockManager dockManager) {
        super(project, dockManager);
        this.myPsiManager = psiManager;
        this.myProblemSolver = problemSolver;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myProblemListener = new MyProblemListener();
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        project.getMessageBus().connect().subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                });
            }
        });
    }

    @Override
    protected void projectOpened(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(0);
        }
        super.projectOpened(connection);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myProblemSolver.addProblemListener(this.myProblemListener);
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(1);
        }
        return this.myProblemSolver.isProblemFile(file2);
    }

    @Override
    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(2);
        }
        StringBuilder tooltipText = new StringBuilder();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.getProject());
        if (module != null) {
            tooltipText.append("[");
            tooltipText.append(module.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(super.getFileTooltipText(file2));
        String string = tooltipText.toString();
        if (string == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        if (editor == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(4);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = editor.getDocument();
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (!focusEditor || documentManager.isUncommited(document)) {
            return editor;
        }
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProblem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTooltipText";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOpenedEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(0);
            }
            this.updateFile(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(1);
            }
            this.updateFile(file2);
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(2);
            }
            this.updateFile(file2);
        }

        private void updateFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(3);
            }
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsAppeared";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsDisappeared";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if ("roots".equals(e.getPropertyName())) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                VirtualFile[] openFiles = PsiAwareFileEditorManagerImpl.this.getOpenFiles();
                for (int i = openFiles.length - 1; i >= 0; --i) {
                    VirtualFile file2 = openFiles[i];
                    LOG.assertTrue(file2 != null);
                    PsiAwareFileEditorManagerImpl.this.updateFileIcon(file2);
                }
            }
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            this.doChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            this.doChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.doChange(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.doChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            this.doChange(event);
        }

        private void doChange(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 == null) {
                return;
            }
            FileEditor[] editors = PsiAwareFileEditorManagerImpl.this.getAllEditors(file2);
            if (editors.length == 0) {
                return;
            }
            VirtualFile currentFile = PsiAwareFileEditorManagerImpl.this.getCurrentFile();
            if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
                PsiAwareFileEditorManagerImpl.this.updateFileIcon(currentFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

