/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImplKt;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(value="keymap.xml", roamingType=RoamingType.PER_OS)}, additionalExportFile="keymaps")
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 92\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u00019B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0017J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b0$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020\u000bH\u0016J\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010+\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020\u0015H\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0017J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u000eH\u0016J\u0012\u00102\u001a\u00020\u00152\b\u00103\u001a\u0004\u0018\u00010\u0013H\u0016J.\u00104\u001a\u00020\u00152\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\b\u00106\u001a\u0004\u0018\u00010\u00132\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010)J\u0010\u00108\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000bH\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\f\u001a$\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl;", "Lcom/intellij/openapi/keymap/ex/KeymapManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "defaultKeymap", "Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "factory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "(Lcom/intellij/openapi/keymap/impl/DefaultKeymap;Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "boundShortcuts", "Lgnu/trove/THashMap;", "", "listeners", "", "Lcom/intellij/openapi/keymap/KeymapManagerListener;", "kotlin.jvm.PlatformType", "", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/openapi/keymap/Keymap;", "addKeymapManagerListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addWeakListener", "bindShortcuts", "sourceActionId", "targetActionId", "getActionBinding", "actionId", "getActiveKeymap", "getAllKeymaps", "", "()[Lcom/intellij/openapi/keymap/Keymap;", "getBoundActions", "", "getKeymap", "name", "getKeymaps", "additionalFilter", "Lcom/intellij/openapi/util/Condition;", "getSchemeManager", "getState", "loadState", "state", "pollQueue", "removeKeymapManagerListener", "removeWeakListener", "listenerToRemove", "setActiveKeymap", "keymap", "setKeymaps", "keymaps", "active", "removeCondition", "unbindShortcuts", "Companion", "platform-impl"})
public final class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element> {
    private final List<KeymapManagerListener> listeners;
    private final THashMap<String, String> boundShortcuts;
    private final SchemeManager<Keymap> schemeManager;
    @JvmField
    public static boolean ourKeymapManagerInitialized;
    public static final Companion Companion;

    @Override
    @NotNull
    public Keymap[] getAllKeymaps() {
        Collection $receiver$iv;
        Condition condition = Conditions.alwaysTrue();
        Intrinsics.checkExpressionValueIsNotNull((Object)condition, (String)"Conditions.alwaysTrue<Keymap>()");
        Collection collection = $receiver$iv = (Collection)this.getKeymaps((Condition<Keymap>)condition);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Keymap[] keymapArray = thisCollection$iv.toArray(new Keymap[0]);
        if (keymapArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return keymapArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Keymap> getKeymaps(@NotNull Condition<Keymap> additionalFilter) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(additionalFilter, (String)"additionalFilter");
        Iterable iterable = $receiver$iv = (Iterable)this.schemeManager.getAllSchemes();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Keymap it = (Keymap)element$iv$iv;
            if (!(!StringsKt.startsWith$default((String)it.getPresentableName(), (String)"$", (boolean)false, (int)2, null) && additionalFilter.value((Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Keymap getKeymap(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.schemeManager.findSchemeByName(name);
    }

    @Nullable
    public Keymap getActiveKeymap() {
        return this.schemeManager.getActiveScheme();
    }

    @Override
    public void setActiveKeymap(@Nullable Keymap keymap) {
        SchemeManager.setCurrent$default(this.schemeManager, keymap, false, 2, null);
    }

    @Override
    public void bindShortcuts(@NotNull String sourceActionId, @NotNull String targetActionId) {
        Intrinsics.checkParameterIsNotNull((Object)sourceActionId, (String)"sourceActionId");
        Intrinsics.checkParameterIsNotNull((Object)targetActionId, (String)"targetActionId");
        this.boundShortcuts.put((Object)targetActionId, (Object)sourceActionId);
    }

    @Override
    public void unbindShortcuts(@NotNull String targetActionId) {
        Intrinsics.checkParameterIsNotNull((Object)targetActionId, (String)"targetActionId");
        this.boundShortcuts.remove((Object)targetActionId);
    }

    @Override
    @NotNull
    public Set<String> getBoundActions() {
        return this.boundShortcuts.keySet();
    }

    @Override
    @Nullable
    public String getActionBinding(@NotNull String actionId) {
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        Set visited = null;
        String id = actionId;
        do {
            String next;
            if ((String)this.boundShortcuts.get((Object)id) == null) {
                break;
            }
            if (visited == null) {
                visited = (Set)new SmartHashSet();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)next, (String)"next");
        } while (visited.add(id));
        return Intrinsics.areEqual((Object)id, (Object)actionId) ? null : id;
    }

    @Override
    @NotNull
    public SchemeManager<Keymap> getSchemeManager() {
        return this.schemeManager;
    }

    public final void setKeymaps(@NotNull List<? extends Keymap> keymaps, @Nullable Keymap active, @Nullable Condition<Keymap> removeCondition) {
        Intrinsics.checkParameterIsNotNull(keymaps, (String)"keymaps");
        this.schemeManager.setSchemes(keymaps, active, removeCondition);
    }

    @NotNull
    public Element getState() {
        Element result2;
        block0: {
            Keymap keymap;
            Keymap it;
            result2 = new Element("state");
            Keymap keymap2 = this.schemeManager.getActiveScheme();
            if (keymap2 == null || !(Intrinsics.areEqual((Object)(it = (keymap = keymap2)).getName(), (Object)DefaultKeymap.Companion.getInstance().getDefaultKeymapName()) ^ true)) break block0;
            Element e = new Element("active_keymap");
            e.setAttribute("name", it.getName());
            result2.addContent(e);
        }
        return result2;
    }

    public void loadState(@NotNull Element state) {
        Element child;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Element element = child = state.getChild("active_keymap");
        String activeKeymapName = element != null ? element.getAttributeValue("name") : null;
        CharSequence charSequence = activeKeymapName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.schemeManager.setCurrentSchemeName(activeKeymapName);
        }
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.add(listener2);
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.pollQueue();
        this.listeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(this, listener2){
            final /* synthetic */ KeymapManagerImpl this$0;
            final /* synthetic */ KeymapManagerListener $listener;

            public final void dispose() {
                this.this$0.removeKeymapManagerListener(this.$listener);
            }
            {
                this.this$0 = keymapManagerImpl;
                this.$listener = keymapManagerListener;
            }
        });
    }

    private final void pollQueue() {
        CollectionsKt.removeAll(this.listeners, (Function1)pollQueue.1.INSTANCE);
    }

    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.remove(listener2);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.addKeymapManagerListener(new WeakKeymapManagerListener(this, listener2));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        Intrinsics.checkParameterIsNotNull((Object)listenerToRemove, (String)"listenerToRemove");
        CollectionsKt.removeAll(this.listeners, (Function1)((Function1)new Function1<KeymapManagerListener, Boolean>(listenerToRemove){
            final /* synthetic */ KeymapManagerListener $listenerToRemove;

            public final boolean invoke(KeymapManagerListener it) {
                return it instanceof WeakKeymapManagerListener && ((WeakKeymapManagerListener)it).isWrapped(this.$listenerToRemove);
            }
            {
                this.$listenerToRemove = keymapManagerListener;
                super(1);
            }
        }));
    }

    public KeymapManagerImpl(final @NotNull DefaultKeymap defaultKeymap, @NotNull SchemeManagerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)defaultKeymap, (String)"defaultKeymap");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        this.listeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.boundShortcuts = new THashMap();
        this.schemeManager = SchemeManagerFactory.create$default(factory, "keymaps", new LazySchemeProcessor<Keymap, KeymapImpl>(){

            @Override
            @NotNull
            public KeymapImpl createScheme(@NotNull SchemeDataHolder<? super KeymapImpl> dataHolder, @NotNull String name, @NotNull Function<String, String> attributeProvider2, boolean isBundled) {
                Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(attributeProvider2, (String)"attributeProvider");
                return KeymapImplKt.KeymapImpl(name, dataHolder);
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable Keymap oldScheme, @Nullable Keymap newScheme) {
                for (KeymapManagerListener listener2 : listeners) {
                    listener2.activeKeymapChanged(newScheme);
                }
            }

            @Override
            public void reloaded(@NotNull SchemeManager<Keymap> schemeManager2, @NotNull Collection<? extends Keymap> schemes) {
                Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
                Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
                if (schemeManager2.getActiveScheme() == null) {
                    AppUIUtil.invokeOnEdt(new Runnable(this, schemeManager2){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ SchemeManager $schemeManager;

                        public final void run() {
                            this.$schemeManager.setCurrentSchemeName(this.this$0.defaultKeymap.getDefaultKeymapName(), true);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$schemeManager = schemeManager2;
                        }
                    });
                }
            }
        }, null, null, 12, null);
        String systemDefaultKeymap = WelcomeWizardUtil.getWizardMacKeymap() == null ? defaultKeymap.getDefaultKeymapName() : WelcomeWizardUtil.getWizardMacKeymap();
        for (Keymap keymap : defaultKeymap.getKeymaps()) {
            this.schemeManager.addScheme(keymap);
            if (!Intrinsics.areEqual((Object)keymap.getName(), (Object)systemDefaultKeymap)) continue;
            this.setActiveKeymap(keymap);
        }
        this.schemeManager.loadSchemes();
        ourKeymapManagerInitialized = true;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl$Companion;", "", "()V", "ourKeymapManagerInitialized", "", "platform-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

