/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.OptionsEditorContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public abstract class SettingsFilter
extends ElementFilter.Active.Impl<SimpleNode> {
    final OptionsEditorContext myContext = new OptionsEditorContext();
    final Project myProject;
    boolean myDocumentWasChanged;
    private final SearchTextField mySearch;
    private final ConfigurableGroup[] myGroups;
    private SearchableOptionsRegistrar myRegistrar = SearchableOptionsRegistrar.getInstance();
    private Set<Configurable> myFiltered;
    private ConfigurableHit myHits;
    private boolean myUpdateRejected;
    private Configurable myLastSelected;

    SettingsFilter(Project project, ConfigurableGroup[] groups, SearchTextField search2) {
        this.myProject = project;
        this.myGroups = groups;
        this.mySearch = search2;
        this.mySearch.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                SettingsFilter.this.update(event.getType(), true, false);
                IdeFocusManager manager = IdeFocusManager.findInstanceByComponent((Component)SettingsFilter.this.mySearch);
                if (manager.getFocusedDescendantFor((Component)SettingsFilter.this.mySearch) == null) {
                    manager.requestFocus((Component)SettingsFilter.this.mySearch, true);
                }
            }
        });
        this.mySearch.getTextEditor().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (!SettingsFilter.this.mySearch.getText().isEmpty()) {
                    if (!SettingsFilter.this.myContext.isHoldingFilter()) {
                        SettingsFilter.this.setHoldingFilter(true);
                    }
                    if (!SettingsFilter.this.mySearch.getTextEditor().isFocusOwner()) {
                        SettingsFilter.this.mySearch.selectText();
                    }
                }
            }
        });
    }

    abstract Configurable getConfigurable(SimpleNode var1);

    abstract SimpleNode findNode(Configurable var1);

    abstract void updateSpotlight(boolean var1);

    public boolean shouldBeShowing(SimpleNode node) {
        Configurable configurable;
        if (this.myFiltered != null && (configurable = this.getConfigurable(node)) != null && !this.myFiltered.contains(configurable)) {
            if (this.myHits != null) {
                Set configurables = this.myHits.getNameFullHits();
                while (node != null) {
                    if (configurable != null && configurables.contains(configurable)) {
                        return true;
                    }
                    node = node.getParent();
                    configurable = this.getConfigurable(node);
                }
            }
            return false;
        }
        return true;
    }

    String getFilterText() {
        String text = this.mySearch.getText();
        if (text != null && 1 < (text = text.trim()).length()) {
            return text;
        }
        return "";
    }

    void setHoldingFilter(boolean holding) {
        this.myContext.setHoldingFilter(holding);
        this.updateSpotlight(false);
    }

    boolean contains(Configurable configurable) {
        return this.myHits != null && this.myHits.getNameHits().contains(configurable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionCallback update(String text, boolean adjustSelection, boolean now) {
        try {
            this.myUpdateRejected = true;
            this.mySearch.setText(text);
        }
        finally {
            this.myUpdateRejected = false;
        }
        return this.update(DocumentEvent.EventType.CHANGE, adjustSelection, now);
    }

    private ActionCallback update(@NotNull DocumentEvent.EventType type, boolean adjustSelection, boolean now) {
        Configurable candidate;
        boolean shouldMoveSelection;
        if (type == null) {
            SettingsFilter.$$$reportNull$$$0(0);
        }
        if (this.myUpdateRejected) {
            return ActionCallback.REJECTED;
        }
        String text = this.getFilterText();
        if (text.isEmpty()) {
            this.myContext.setHoldingFilter(false);
            this.myFiltered = null;
        } else {
            this.myContext.setHoldingFilter(true);
            this.myHits = this.myRegistrar.getConfigurables(this.myGroups, type, this.myFiltered, text, this.myProject);
            this.myFiltered = this.myHits.getAll();
        }
        this.mySearch.getTextEditor().setBackground(this.myFiltered != null && this.myFiltered.isEmpty() ? LightColors.RED : UIUtil.getTextFieldBackground());
        Configurable current = this.myContext.getCurrentConfigurable();
        boolean bl = shouldMoveSelection = this.myHits == null || !this.myHits.getNameFullHits().contains(current) && !this.myHits.getContentHits().contains(current);
        if (shouldMoveSelection && type != DocumentEvent.EventType.INSERT && (this.myFiltered == null || this.myFiltered.contains(current))) {
            shouldMoveSelection = false;
        }
        Object object = candidate = adjustSelection ? current : null;
        if (shouldMoveSelection && this.myHits != null) {
            if (!this.myHits.getNameHits().isEmpty()) {
                candidate = SettingsFilter.findConfigurable(this.myHits.getNameHits(), this.myHits.getNameFullHits());
            } else if (!this.myHits.getContentHits().isEmpty()) {
                candidate = SettingsFilter.findConfigurable(this.myHits.getContentHits(), null);
            }
        }
        this.updateSpotlight(false);
        if (!(this.myFiltered != null && this.myFiltered.isEmpty() || candidate != null || this.myLastSelected == null)) {
            candidate = this.myLastSelected;
            this.myLastSelected = null;
        }
        if (candidate == null && current != null) {
            this.myLastSelected = current;
        }
        SimpleNode node = !adjustSelection ? null : this.findNode(candidate);
        ActionCallback callback = this.fireUpdate(node, adjustSelection, now);
        this.myDocumentWasChanged = true;
        return callback;
    }

    private static Configurable findConfigurable(Set<Configurable> configurables, Set<Configurable> hits) {
        Configurable candidate = null;
        for (Configurable configurable : configurables) {
            if (hits != null && hits.contains(configurable)) {
                return configurable;
            }
            if (candidate != null || SettingsFilter.isEmptyParent(configurable)) continue;
            candidate = configurable;
        }
        return candidate;
    }

    private static boolean isEmptyParent(Configurable configurable) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, (UnnamedConfigurable)configurable);
        return parent != null && !parent.hasOwnContent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/options/newEditor/SettingsFilter", "update"));
    }
}

